/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation.generation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.generation.UtilsKt;
import org.jetbrains.completion.full.line.local.generation.search.BeamSearchGraph;
import org.jetbrains.completion.full.line.local.generation.search.Search;
import org.jetbrains.completion.full.line.tokenizer.Tokenizer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\fJ\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\u0014\u00107\u001a\u0002042\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000509J\u0010\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R6\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR6\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000fR6\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR6\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR6\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR*\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00160\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000fR6\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00130\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000fR\u001e\u0010&\u001a\u00020%2\u0006\u0010\r\u001a\u00020%@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010(R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000f\u00a8\u0006<"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/generation/SearchState;", "", "tokenizer", "Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;", "searchSize", "", "prefixes", "", "", "<init>", "(Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;ILjava/util/List;)V", "prefix", "(Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;ILjava/lang/String;)V", "value", "getPrefixes", "()Ljava/util/List;", "length", "getLength", "()I", "", "hypothesesTokens", "getHypothesesTokens", "", "hypothesesProbabilities", "getHypothesesProbabilities", "hypothesesNormalizedProbabilities", "getHypothesesNormalizedProbabilities", "hypothesesTokenScores", "getHypothesesTokenScores", "hypothesesNormalizedTokenScores", "getHypothesesNormalizedTokenScores", "hypothesesScores", "getHypothesesScores", "hypothesesNormalizedScores", "getHypothesesNormalizedScores", "tokenEntropies", "getTokenEntropies", "", "sortMask", "getSortMask", "()[I", "graph", "Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph;", "getGraph", "()Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph;", "lastPredictions", "getLastPredictions", "lastIndents", "getLastIndents", "isEmpty", "", "update", "", "stepResult", "Lorg/jetbrains/completion/full/line/local/generation/search/Search$StepResult;", "dropHypotheses", "indices", "", "applySliceToState", "tensorSlice", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nSearchState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchState.kt\norg/jetbrains/completion/full/line/local/generation/generation/SearchState\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n11735#2:106\n12085#2,3:107\n11735#2:116\n12085#2,3:117\n11735#2:120\n12085#2,3:121\n11735#2:124\n12085#2,3:125\n11735#2:128\n12085#2,3:129\n11735#2:132\n12085#2,3:133\n11735#2:136\n12085#2,3:137\n1924#3,3:110\n777#3:113\n873#3,2:114\n*S KotlinDebug\n*F\n+ 1 SearchState.kt\norg/jetbrains/completion/full/line/local/generation/generation/SearchState\n*L\n51#1:106\n51#1:107,3\n96#1:116\n96#1:117,3\n97#1:120\n97#1:121,3\n98#1:124\n98#1:125,3\n99#1:128\n99#1:129,3\n100#1:132\n100#1:133,3\n101#1:136\n101#1:137,3\n73#1:110,3\n85#1:113\n85#1:114,2\n*E\n"})
public final class SearchState {
    @NotNull
    private final Tokenizer tokenizer;
    private final int searchSize;
    @NotNull
    private List<String> prefixes;
    private int length;
    @NotNull
    private List<? extends List<Integer>> hypothesesTokens;
    @NotNull
    private List<? extends List<Double>> hypothesesProbabilities;
    @NotNull
    private List<? extends List<Double>> hypothesesNormalizedProbabilities;
    @NotNull
    private List<? extends List<Double>> hypothesesTokenScores;
    @NotNull
    private List<? extends List<Double>> hypothesesNormalizedTokenScores;
    @NotNull
    private List<Double> hypothesesScores;
    @NotNull
    private List<Double> hypothesesNormalizedScores;
    @NotNull
    private List<? extends List<Double>> tokenEntropies;
    private int[] sortMask;
    @NotNull
    private final BeamSearchGraph graph;

    public SearchState(@NotNull Tokenizer tokenizer, int searchSize, @NotNull List<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        this.tokenizer = tokenizer;
        this.searchSize = searchSize;
        this.prefixes = prefixes;
        this.hypothesesTokens = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesProbabilities = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesNormalizedProbabilities = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesTokenScores = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesNormalizedTokenScores = CollectionsKt.listOf((Object)new ArrayList());
        this.hypothesesScores = CollectionsKt.listOf((Object)0.0);
        this.hypothesesNormalizedScores = CollectionsKt.listOf((Object)0.0);
        this.tokenEntropies = CollectionsKt.listOf((Object)new ArrayList());
        this.graph = new BeamSearchGraph(this.tokenizer);
    }

    public SearchState(@NotNull Tokenizer tokenizer, int searchSize, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this(tokenizer, searchSize, CollectionsKt.listOf((Object)prefix));
    }

    @NotNull
    public final List<String> getPrefixes() {
        return this.prefixes;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public final List<List<Integer>> getHypothesesTokens() {
        return this.hypothesesTokens;
    }

    @NotNull
    public final List<List<Double>> getHypothesesProbabilities() {
        return this.hypothesesProbabilities;
    }

    @NotNull
    public final List<List<Double>> getHypothesesNormalizedProbabilities() {
        return this.hypothesesNormalizedProbabilities;
    }

    @NotNull
    public final List<List<Double>> getHypothesesTokenScores() {
        return this.hypothesesTokenScores;
    }

    @NotNull
    public final List<List<Double>> getHypothesesNormalizedTokenScores() {
        return this.hypothesesNormalizedTokenScores;
    }

    @NotNull
    public final List<Double> getHypothesesScores() {
        return this.hypothesesScores;
    }

    @NotNull
    public final List<Double> getHypothesesNormalizedScores() {
        return this.hypothesesNormalizedScores;
    }

    @NotNull
    public final List<List<Double>> getTokenEntropies() {
        return this.tokenEntropies;
    }

    @NotNull
    public final int[] getSortMask() {
        if (this.sortMask != null) {
            return this.sortMask;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sortMask");
        return null;
    }

    @NotNull
    public final BeamSearchGraph getGraph() {
        return this.graph;
    }

    @NotNull
    public final int[] getLastPredictions() {
        if (this.isEmpty()) {
            return new int[0];
        }
        int n = 0;
        int n2 = this.hypothesesTokens.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = ((Number)CollectionsKt.last(this.hypothesesTokens.get(n3))).intValue();
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getLastIndents() {
        void $this$mapTo$iv$iv;
        if (this.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int[] $this$map$iv = this.getSortMask();
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.graph.getLastNodes().get((int)it).getIndent());
        }
        return (List)destination$iv$iv;
    }

    public final boolean isEmpty() {
        return this.hypothesesTokens.isEmpty() || this.hypothesesTokens.get(0).size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull Search.StepResult stepResult) {
        Intrinsics.checkNotNullParameter((Object)stepResult, (String)"stepResult");
        int n = 0;
        int n2 = stepResult.getNewTokens().length;
        int[] nArray = new int[n2];
        SearchState searchState = this;
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        searchState.sortMask = nArray;
        this.applySliceToState(stepResult.getSortMask());
        this.hypothesesScores = ArraysKt.toMutableList((double[])stepResult.getScores());
        this.hypothesesNormalizedScores = ArraysKt.toMutableList((double[])stepResult.getNormalizedScores());
        n2 = ((Collection)this.hypothesesTokens).size();
        for (int i = 0; i < n2; ++i) {
            this.hypothesesTokens.get(i).add(stepResult.getNewTokens()[i]);
            this.hypothesesProbabilities.get(i).add(stepResult.getProbabilities()[i]);
            this.hypothesesNormalizedProbabilities.get(i).add(stepResult.getNormalizedProbabilities()[i]);
            this.hypothesesTokenScores.get(i).add(stepResult.getScores()[i]);
            this.hypothesesNormalizedTokenScores.get(i).add(stepResult.getNormalizedScores()[i]);
            this.tokenEntropies.get(i).add(stepResult.getEntropies()[i]);
        }
        ++this.length;
        ArrayList<String> result = new ArrayList<String>(this.prefixes.size());
        Iterable $this$forEachIndexed$iv = this.prefixes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String newPrefix;
            void prefix;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n4;
            boolean bl = false;
            int tokenId = ((Number)CollectionsKt.last(this.hypothesesTokens.get(i))).intValue();
            String token = this.tokenizer.decode(tokenId);
            Intrinsics.checkNotNullExpressionValue((Object)prefix.substring(Math.min(prefix.length(), token.length())), (String)"substring(...)");
            result.add(newPrefix);
        }
        this.prefixes = result;
        this.graph.update(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropHypotheses(@NotNull Collection<Integer> indices) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Iterable $this$filter$iv = (Iterable)CollectionsKt.getIndices((Collection)this.hypothesesScores);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(!indices.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int[] newSortMask = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        this.applySliceToState(newSortMask);
        int[] topBsMask = UtilsKt.topk1d(CollectionsKt.toDoubleArray((Collection)this.hypothesesScores), Math.min(this.searchSize, this.hypothesesScores.size()));
        this.applySliceToState(topBsMask);
        this.graph.terminateHypotheses(this.length - 1, indices);
    }

    private final void applySliceToState(int[] tensorSlice) {
        int n;
        int it;
        Collection collection;
        int item$iv$iv2;
        int[] $this$mapTo$iv$iv;
        int[] $this$map$iv;
        this.prefixes = UtilsKt.slice(this.prefixes, tensorSlice);
        this.hypothesesScores = CollectionsKt.toMutableList((Collection)UtilsKt.slice(this.hypothesesScores, tensorSlice));
        this.hypothesesNormalizedScores = CollectionsKt.toMutableList((Collection)UtilsKt.slice(this.hypothesesNormalizedScores, tensorSlice));
        int[] nArray = tensorSlice;
        SearchState searchState = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (int item$iv$iv2 : $this$mapTo$iv$iv) {
            void var10_11 = item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesTokens.get(it)));
        }
        searchState.hypothesesTokens = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesProbabilities.get(it)));
        }
        searchState.hypothesesProbabilities = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesNormalizedProbabilities.get(it)));
        }
        searchState.hypothesesNormalizedProbabilities = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesTokenScores.get(it)));
        }
        searchState.hypothesesTokenScores = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.hypothesesNormalizedTokenScores.get(it)));
        }
        searchState.hypothesesNormalizedTokenScores = (List)destination$iv$iv;
        $this$map$iv = tensorSlice;
        searchState = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n2 = $this$mapTo$iv$iv.length;
        for (n = 0; n < n2; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList(this.tokenEntropies.get(it)));
        }
        searchState.tokenEntropies = (List)destination$iv$iv;
        this.sortMask = UtilsKt.sliceArray(this.getSortMask(), tensorSlice);
    }
}

