/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.completion.frontend.split.FrontendCompletionLookupManagerListenerKt;
import com.intellij.platform.completion.frontend.split.FrontendCompletionLookupMirror;
import com.intellij.platform.completion.frontend.split.FrontendCompletionPrefixChangeListener;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendCompletionLookupManagerListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "intellij.platform.completion.frontend.split"})
public final class FrontendCompletionLookupManagerListener
implements LookupManagerListener {
    @NotNull
    private final CoroutineScope scope;

    public FrontendCompletionLookupManagerListener(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        if (!Registry.Companion.is("remdev.completion.on.frontend")) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        Lookup lookup = newLookup;
        if (lookup == null || (lookup = FrontendCompletionLookupManagerListenerKt.getCompletionLookup(lookup)) == null) {
            return;
        }
        Lookup newCompletionLookup = lookup;
        CoroutineScope subScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.scope, (String)("Frontend Lookup listeners " + (LookupImpl)newCompletionLookup), null, (boolean)false, (int)6, null);
        FrontendCompletionLookupMirror lookupMirror = new FrontendCompletionLookupMirror(subScope);
        newCompletionLookup.addLookupListener((LookupListener)lookupMirror);
        lookupMirror.activeLookupChanged(newLookup);
        FrontendCompletionPrefixChangeListener prefixListener = new FrontendCompletionPrefixChangeListener(subScope, (LookupImpl)newCompletionLookup);
        newCompletionLookup.setPrefixChangeListener((PrefixChangeListener)prefixListener);
    }
}

