/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonArray;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001f\u0010\f\u001a\u0002H\r\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonElementGenerator;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/FileType;)V", "createDummyFile", "Lcom/intellij/psi/PsiFile;", "content", "", "createValue", "T", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonValue;", "(Ljava/lang/String;)Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonValue;", "createStringLiteral", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonStringLiteral;", "unescapedContent", "createComma", "Lcom/intellij/psi/PsiElement;", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonElementGenerator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileType fileType;

    public MongoDBJsonElementGenerator(@NotNull Project myProject, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.myProject = myProject;
        this.fileType = fileType;
    }

    private final PsiFile createDummyFile(String content) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.myProject);
        PsiFile psiFile = psiFileFactory.createFileFromText("dummy", this.fileType, (CharSequence)content);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        return psiFile;
    }

    public final <T extends MongoDBJsonValue> T createValue(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        PsiFile file = this.createDummyFile("{\"foo\": " + content + "}");
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject");
        return (T)((MongoDBJsonObject)psiElement).getPropertyList().get(0).getValue();
    }

    @NotNull
    public final MongoDBJsonStringLiteral createStringLiteral(@NotNull String unescapedContent) {
        Intrinsics.checkNotNullParameter((Object)unescapedContent, (String)"unescapedContent");
        return (MongoDBJsonStringLiteral)this.createValue("\"" + StringUtil.escapeStringCharacters((String)unescapedContent) + "\"");
    }

    @NotNull
    public final PsiElement createComma() {
        MongoDBJsonArray jsonArray1 = (MongoDBJsonArray)this.createValue("[1, 2]");
        PsiElement psiElement = jsonArray1.getValueList().get(0).getNextSibling();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNextSibling(...)");
        return psiElement;
    }
}

