/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.psi;

import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.mongodb.json.MongoDBJsonElementTypes;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonElementGenerator;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonObject;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonProperty;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0000\u00a8\u0006\n"}, d2={"isPropertyKey", "", "element", "Lcom/intellij/psi/PsiElement;", "addProperty", "jsonObject", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonObject;", "property", "Lcom/intellij/persistence/mongodb/json/psi/MongoDBJsonProperty;", "first", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonPsiUtilKt {
    public static final boolean isPropertyKey(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement parent = element.getParent();
        return parent instanceof MongoDBJsonProperty && element == ((MongoDBJsonProperty)parent).getNameElement();
    }

    @NotNull
    public static final PsiElement addProperty(@NotNull MongoDBJsonObject jsonObject, @NotNull MongoDBJsonProperty property, boolean first) {
        MongoDBJsonProperty lastProperty;
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        List<MongoDBJsonProperty> list = jsonObject.getPropertyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
        List<MongoDBJsonProperty> propertyList = list;
        if (!first && (lastProperty = (MongoDBJsonProperty)CollectionsKt.lastOrNull(propertyList)) != null) {
            PsiElement addedProperty22 = jsonObject.addAfter(property, lastProperty);
            Project project = jsonObject.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            FileType fileType = jsonObject.getContainingFile().getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
            jsonObject.addBefore(new MongoDBJsonElementGenerator(project, fileType).createComma(), addedProperty22);
            Intrinsics.checkNotNull((Object)addedProperty22);
            return addedProperty22;
        }
        PsiElement leftBrace = jsonObject.getFirstChild();
        IElementType[] addedProperty22 = new IElementType[]{MongoDBJsonElementTypes.L_CURLY};
        boolean addedProperty22 = JsonPsiUtil.hasElementType((PsiElement)leftBrace, (IElementType[])addedProperty22);
        if (_Assertions.ENABLED && !addedProperty22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiElement addedProperty = jsonObject.addAfter(property, leftBrace);
        if (!propertyList.isEmpty()) {
            Project project = jsonObject.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            FileType fileType = jsonObject.getContainingFile().getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
            jsonObject.addAfter(new MongoDBJsonElementGenerator(project, fileType).createComma(), addedProperty);
        }
        Intrinsics.checkNotNull((Object)addedProperty);
        return addedProperty;
    }
}

