/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Casing;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlResolveMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u001a \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u000b"}, d2={"findDataSourcesAssociatedWithFile", "", "Lcom/intellij/database/psi/DbDataSource;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getResolveScopePattern", "Lcom/intellij/database/util/TreePattern;", "file", "getFilteredDataSources", "", "filter", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nDatasourceResolveUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasourceResolveUtil.kt\ncom/intellij/persistence/util/DatasourceResolveUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n777#2:36\n873#2,2:37\n*S KotlinDebug\n*F\n+ 1 DatasourceResolveUtil.kt\ncom/intellij/persistence/util/DatasourceResolveUtilKt\n*L\n31#1:36\n31#1:37,2\n*E\n"})
public final class DatasourceResolveUtilKt {
    @ApiStatus.Experimental
    @NotNull
    public static final Collection<DbDataSource> findDataSourcesAssociatedWithFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return DatasourceResolveUtilKt.getFilteredDataSources(psiFile, DatasourceResolveUtilKt.getResolveScopePattern(psiFile));
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TreePattern getResolveScopePattern(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SqlResolveMappings mapping = SqlResolveMappings.getInstance((Project)file.getProject());
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile vFile = virtualFile;
        return (TreePattern)mapping.getMapping(vFile);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @NotNull
    public static final List<DbDataSource> getFilteredDataSources(@NotNull PsiFile psiFile, @Nullable TreePattern filter) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        TreePattern treePattern = filter;
        if (treePattern == null || (treePattern = treePattern.root) == null || (treePattern = treePattern.getGroup(SqlImportUtil.DATA_SOURCE)) == null) {
            return CollectionsKt.emptyList();
        }
        TreePattern group = treePattern;
        boolean all = TreePatternUtils.isWildcard((TreePatternNode.Group)group);
        List list = DbPsiFacade.getInstance((Project)psiFile.getProject()).getDataSources();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        List res = list;
        if (!all) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = res;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DbDataSource ds = (DbDataSource)element$iv$iv;
                boolean bl = false;
                if (!group.matchedChildren(SqlImportUtil.getDataSourceName((DasDataSource)((DasDataSource)ds)), Casing.EXACT, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            res = (List)destination$iv$iv;
        }
        return res;
    }
}

