/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\n0\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0018\u00010\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javaee/oss/server/WslAwareJreSelector;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "serverModel", "Lcom/intellij/javaee/oss/server/JavaeeServerModel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/javaee/oss/server/JavaeeServerModel;Lcom/intellij/openapi/project/Project;)V", "projectSdkSelector", "projectPath", "", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/annotations/SystemIndependent;", "Lorg/jetbrains/annotations/NonNls;", "getVersion", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "getWslServerHome", "intellij.javaee.appServers"})
public final class WslAwareJreSelector
extends DefaultJreSelector {
    @NotNull
    private final JavaeeServerModel serverModel;
    @NotNull
    private final DefaultJreSelector projectSdkSelector;
    @Nullable
    private final String projectPath;

    public WslAwareJreSelector(@NotNull JavaeeServerModel serverModel, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)serverModel, (String)"serverModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.serverModel = serverModel;
        this.projectSdkSelector = DefaultJreSelector.Companion.projectSdk(project);
        this.projectPath = project.getBasePath();
    }

    @Nullable
    public String getVersion() {
        if (this.getWslServerHome() != null) {
            return null;
        }
        return this.projectSdkSelector.getVersion();
    }

    @NotNull
    public Pair<String, String> getNameAndDescription() {
        String string = this.getWslServerHome();
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (this.projectPath == null || !WslSupportUtil.isWslPath(this.projectPath)) {
                Pair pair = Pair.create((Object)WslSupportUtil.INSTANCE.getWslJavaHome(it), (Object)"WSL");
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                return pair;
            }
        }
        return this.projectSdkSelector.getNameAndDescription();
    }

    private final String getWslServerHome() {
        String home = this.serverModel.getHome();
        if (WslSupportUtil.isWslPath(home)) {
            return home;
        }
        return null;
    }
}

