/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.transport;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.transport.RemoteStagingTarget;
import com.intellij.javaee.oss.transport.StagingTargetModel;
import com.intellij.javaee.oss.transport.StagingTargetModelEditor;
import com.intellij.javaee.oss.transport.StagingTargetModelImpl;
import com.intellij.javaee.oss.transport.TargetModelEditor;
import com.intellij.javaee.oss.transport.TransportTargetModelBase;
import com.intellij.javaee.oss.transport.WatchedTargetModel;
import com.intellij.javaee.oss.transport.WatchedTargetModelEditor;
import com.intellij.javaee.oss.transport.WatchedTargetModelImpl;
import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.local.LocalTransportService;
import com.intellij.openapi.util.text.StringUtil;

public enum TransportTargetKind {
    STAGING{

        @Override
        public TransportTargetModelBase createModel() {
            return new StagingTargetModelImpl();
        }

        @Override
        public TargetModelEditor createTargetModelEditor() {
            return new StagingTargetModelEditor();
        }

        @Override
        public boolean isRequiredForHost(String transportHostId) {
            return !LocalTransportService.isHostLocal((String)transportHostId);
        }

        @Override
        protected void doCheckConfiguration(RemoteStagingTarget targetModel, String caption) throws RuntimeConfigurationError {
            if (StringUtil.isEmpty((String)((StagingTargetModel)targetModel).getStagingRemotePath())) {
                throw new RuntimeConfigurationError(AppServersCommonBundle.getText("TransportTargetKind.staging.error.remotePathNotSpecified", caption));
            }
        }
    }
    ,
    WATCHED{

        @Override
        public TransportTargetModelBase createModel() {
            return new WatchedTargetModelImpl();
        }

        @Override
        public TargetModelEditor createTargetModelEditor() {
            return new WatchedTargetModelEditor();
        }

        @Override
        public boolean isRequiredForHost(String transportHostId) {
            return LocalTransportService.isHostLocal((String)transportHostId);
        }

        @Override
        protected void doCheckConfiguration(RemoteStagingTarget targetModel, String caption) throws RuntimeConfigurationError {
            if (StringUtil.isEmpty((String)((WatchedTargetModel)targetModel).getWatchedLocalPath())) {
                throw new RuntimeConfigurationError(AppServersCommonBundle.getText("TransportTargetKind.watched.error.localPathNotSpecified", caption));
            }
        }
    };


    public abstract TransportTargetModelBase createModel();

    public abstract TargetModelEditor createTargetModelEditor();

    public boolean isRequiredForHost(TransportHost host) {
        return this.isRequiredForHost(host.getId());
    }

    public void checkConfiguration(String transportHostId, RemoteStagingTarget targetModel, String caption) throws RuntimeConfigurationError {
        if (!this.isRequiredForHost(transportHostId)) {
            return;
        }
        this.doCheckConfiguration(targetModel, caption);
    }

    protected abstract boolean isRequiredForHost(String var1);

    protected abstract void doCheckConfiguration(RemoteStagingTarget var1, String var2) throws RuntimeConfigurationError;
}

