/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jpa.jpb.model.db.provider;

import com.intellij.database.DbModelRegistry;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.javaee.jpa.jpb.model.db.DataStoreUtils;
import com.intellij.javaee.jpa.jpb.model.db.IdeaDataStore;
import com.intellij.jpa.jpb.model.action.creation.EventDataProviderEP;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.DataStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.orm.ep.OrmUnitsProvider;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J(\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016*\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javaee/jpa/jpb/model/db/provider/DatabaseEventDataProvider;", "Lcom/intellij/jpa/jpb/model/action/creation/EventDataProviderEP;", "<init>", "()V", "getRdbmsDataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDataStore", "Lcom/intellij/jpa/jpb/model/core/model/DataStore;", "getOrmFramework", "Lcom/intellij/jpa/jpb/model/orm/model/OrmFramework;", "getDataStoreWithTypes", "supportedTypes", "", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "findConsoleDatabase", "project", "Lcom/intellij/openapi/project/Project;", "isGlobalActionPlace", "", "getSelectedDbElementFamilies", "", "Lcom/intellij/database/model/BaseModel$BaseNamingFamily;", "Lcom/intellij/openapi/actionSystem/DataContext;", "toDbElement", "Lcom/intellij/database/psi/DbElement;", "Lcom/intellij/database/model/basic/BasicElement;", "isCurrentEditorDbConsole", "intellij.javaee.jpa.jpb.model.db"})
@SourceDebugExtension(value={"SMAP\nDatabaseEventDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseEventDataProvider.kt\ncom/intellij/javaee/jpa/jpb/model/db/provider/DatabaseEventDataProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,106:1\n296#2,2:107\n812#2,12:109\n296#2,2:121\n812#2,12:123\n30#3,2:135\n*S KotlinDebug\n*F\n+ 1 DatabaseEventDataProvider.kt\ncom/intellij/javaee/jpa/jpb/model/db/provider/DatabaseEventDataProvider\n*L\n44#1:107,2\n68#1:109,12\n69#1:121,2\n92#1:123,12\n96#1:135,2\n*E\n"})
public final class DatabaseEventDataProvider
implements EventDataProviderEP {
    @Nullable
    public AbstractRdbmsStore getRdbmsDataStore(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.getDataStoreWithTypes(event, DbType.RELATIONAL_DB_TYPES);
    }

    @Nullable
    public DataStore getDataStore(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return (DataStore)this.getDataStoreWithTypes(event, SetsKt.emptySet());
    }

    @Nullable
    public OrmFramework getOrmFramework(@NotNull AnActionEvent event) {
        Object v2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Project project = event.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            DataStore dataStore = this.getDataStore(event);
            CustomDataStore customDataStore = dataStore instanceof CustomDataStore ? (CustomDataStore)dataStore : null;
            if (customDataStore == null) {
                return null;
            }
            CustomDataStore dataStore2 = customDataStore;
            Iterable $this$firstOrNull$iv = OrmUnitsProvider.Companion.getEP_NAME().getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OrmUnitsProvider it = (OrmUnitsProvider)element$iv;
                boolean bl = false;
                if (!(OrmUtil.INSTANCE.isOrmFrameworkCompatibleWithDataStore(it.getFramework(), (AbstractRdbmsStore)dataStore2) && it.isFrameworkPresent(project2))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        OrmUnitsProvider ormUnitsProvider = v2;
        return ormUnitsProvider != null ? ormUnitsProvider.getFramework() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractRdbmsStore getDataStoreWithTypes(AnActionEvent event, Set<? extends DbType> supportedTypes) {
        Object v7;
        LocalDataSource dataSource;
        Project project;
        block8: {
            void $this$firstOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Project project2 = event.getProject();
            if (project2 == null) {
                return null;
            }
            project = project2;
            if (Intrinsics.areEqual((Object)"EditorToolbar", (Object)event.getPlace()) && this.isCurrentEditorDbConsole(project)) {
                return this.findConsoleDatabase(project, event, supportedTypes);
            }
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DbElement dbElement = (DbElement)CollectionsKt.firstOrNull((Iterable)((Iterable)DatabaseContextFun.getSelectedDbElements((DataContext)dataContext)));
            if (dbElement == null) {
                DataContext dataContext2 = event.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
                BaseModel.BaseNamingFamily baseNamingFamily = (BaseModel.BaseNamingFamily)CollectionsKt.firstOrNull(this.getSelectedDbElementFamilies(dataContext2));
                if ((baseNamingFamily != null && (baseNamingFamily = baseNamingFamily.getHost()) != null ? this.toDbElement((BasicElement)baseNamingFamily, project) : (dbElement = null)) == null) {
                    return null;
                }
            }
            DbElement selectedDbNode = dbElement;
            DbDataSource dbDataSource = selectedDbNode.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
            LocalDataSource localDataSource = DataSourceFun.getLocalDataSource((DasDataSource)((DasDataSource)dbDataSource));
            if (localDataSource == null) {
                return null;
            }
            dataSource = localDataSource;
            if (!Intrinsics.areEqual((Object)"schema", (Object)selectedDbNode.getTypeName())) {
                return (AbstractRdbmsStore)DataStoreUtils.Companion.createDataStore(project, dataSource, supportedTypes);
            }
            String string = selectedDbNode.getName();
            Intrinsics.checkNotNull((Object)string);
            String schemaName = string;
            Iterable iterable = DataStoreUtils.Companion.createReverseEngineeringDataStores(project, dataSource, supportedTypes);
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IdeaDataStore)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IdeaDataStore it = (IdeaDataStore)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)schemaName, (Object)it.getCustomSchemaName())) continue;
                v7 = element$iv;
                break block8;
            }
            v7 = null;
        }
        IdeaDataStore ideaDataStore = v7;
        return ideaDataStore != null ? (AbstractRdbmsStore)ideaDataStore : (AbstractRdbmsStore)DataStoreUtils.Companion.createDataStore(project, dataSource, supportedTypes);
    }

    private final AbstractRdbmsStore findConsoleDatabase(Project project, AnActionEvent event, Set<? extends DbType> supportedTypes) {
        VirtualFile virtualFile = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vfile = virtualFile;
        JdbcConsoleCore jdbcConsoleCore = JdbcConsoleProviderCore.getValidConsole((Project)project, (VirtualFile)vfile);
        if (jdbcConsoleCore == null) {
            return null;
        }
        JdbcConsoleCore console = jdbcConsoleCore;
        DbDataSource dbDataSource = DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)((DasDataSource)console.getDataSource()));
        if (dbDataSource == null || (dbDataSource = DataSourceFun.getLocalDataSource((DasDataSource)((DasDataSource)dbDataSource))) == null) {
            return null;
        }
        DbDataSource forcedDataSource = dbDataSource;
        return (AbstractRdbmsStore)DataStoreUtils.Companion.createDataStore(project, (LocalDataSource)forcedDataSource, supportedTypes);
    }

    public boolean isGlobalActionPlace(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DbElement dbElement = (DbElement)CollectionsKt.firstOrNull((Iterable)((Iterable)DatabaseContextFun.getSelectedDbElements((DataContext)dataContext)));
        if (dbElement == null) {
            DataContext dataContext2 = event.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            BaseModel.BaseNamingFamily baseNamingFamily = (BaseModel.BaseNamingFamily)CollectionsKt.firstOrNull(this.getSelectedDbElementFamilies(dataContext2));
            if ((baseNamingFamily != null && (baseNamingFamily = baseNamingFamily.getHost()) != null ? this.toDbElement((BasicElement)baseNamingFamily, project2) : (dbElement = null)) == null) {
                return false;
            }
        }
        DbElement selectedDbNode = dbElement;
        DbDataSource dbDataSource = selectedDbNode.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        return DataSourceFun.getLocalDataSource((DasDataSource)((DasDataSource)dbDataSource)) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BaseModel.BaseNamingFamily<?>> getSelectedDbElementFamilies(DataContext $this$getSelectedDbElementFamilies) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = (Iterable)DatabaseContextFun.getSelectedNodes((DataContext)$this$getSelectedDbElementFamilies);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BaseModel.BaseNamingFamily)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final DbElement toDbElement(BasicElement $this$toDbElement, Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DbModelRegistry dbModelRegistry = (DbModelRegistry)object;
        return DatabaseViewTreeFun.getDbWrapperFor((BasicNode)((BasicNode)$this$toDbElement), (DbModelRegistry)dbModelRegistry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCurrentEditorDbConsole(Project project) {
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return false;
        }
        Editor currentEditor = editor;
        VirtualFile virtualFile = currentEditor.getVirtualFile();
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile == null) return false;
        VirtualFile virtualFile3 = virtualFile2.getParent();
        virtualFile2 = virtualFile3;
        if (virtualFile3 == null) return false;
        if ((virtualFile2 = virtualFile2.getParent()) == null) {
            return false;
        }
        VirtualFile directory = virtualFile2;
        if (!Intrinsics.areEqual((Object)"db", (Object)directory.getName())) return false;
        VirtualFile virtualFile4 = directory.getParent();
        if (!Intrinsics.areEqual((Object)"consoles", (Object)(virtualFile4 != null ? virtualFile4.getName() : null))) return false;
        return true;
    }
}

