/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.ContextsConfiguration;
import com.intellij.kubernetes.api.KubeConfigEntity;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a(\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001e\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0000\u001a7\u0010\u0012\u001a\u0002H\u0013\"\f\b\u0000\u0010\u0013\u0018\u0001*\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u001a=\u0010\u0017\u001a\u001f\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00040\u00042\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\t\u001a\u00020\nH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"LOG", "Lfleet/util/logging/KLogger;", "getAsNonBlankStringSafely", "", "", "key", "getAsMapSafely", "", "", "entity", "Lcom/intellij/kubernetes/api/KubeConfigEntity;", "getAsListSafely", "", "asNonBlankStringSafely", "yamlNode", "asStringSafely", "asMapSafely", "asListSafely", "asTypeSafely", "T", "typeConstructor", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "associateByName", "Lcom/intellij/openapi/util/NlsSafe;", "configuration", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubeConfigUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubeConfigUtils.kt\ncom/intellij/kubernetes/api/KubeConfigUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,46:1\n25#1,8:48\n25#1,8:56\n25#1,8:64\n1#2:47\n18#3:72\n*S KotlinDebug\n*F\n+ 1 KubeConfigUtils.kt\ncom/intellij/kubernetes/api/KubeConfigUtilsKt\n*L\n16#1:48,8\n18#1:56,8\n20#1:64,8\n6#1:72\n*E\n"})
public final class KubeConfigUtilsKt {
    @NotNull
    private static final KLogger LOG;

    @Nullable
    public static final String getAsNonBlankStringSafely(@NotNull Map<?, ?> $this$getAsNonBlankStringSafely, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$getAsNonBlankStringSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return KubeConfigUtilsKt.asNonBlankStringSafely($this$getAsNonBlankStringSafely.get(key));
    }

    @NotNull
    public static final Map<Object, Object> getAsMapSafely(@NotNull Map<?, ?> $this$getAsMapSafely, @NotNull KubeConfigEntity entity) {
        Intrinsics.checkNotNullParameter($this$getAsMapSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        return KubeConfigUtilsKt.asMapSafely($this$getAsMapSafely.get(entity.getSingularKey()));
    }

    @NotNull
    public static final List<Object> getAsListSafely(@NotNull Map<?, ?> $this$getAsListSafely, @NotNull KubeConfigEntity entity) {
        Intrinsics.checkNotNullParameter($this$getAsListSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        return KubeConfigUtilsKt.asListSafely($this$getAsListSafely.get(entity.getPluralKey()));
    }

    @Nullable
    public static final String asNonBlankStringSafely(@Nullable Object yamlNode) {
        String string;
        String string2 = KubeConfigUtilsKt.asStringSafely(yamlNode);
        if (string2 != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = string2;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String asStringSafely(@Nullable Object yamlNode) {
        Object object;
        Object yamlNode$iv = yamlNode;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode$iv;
        if (object2 == null) {
            boolean bl = false;
            object = null;
        } else if (object2 instanceof String) {
            object = yamlNode$iv;
        } else {
            KubeConfigUtilsKt.LOG.warn((Object)("Unable to parse kubeconfig node. Expected: " + String.class + ", Actual: " + yamlNode$iv.getClass() + " \n\t" + yamlNode$iv));
            boolean bl = false;
            object = null;
        }
        return (String)object;
    }

    @NotNull
    public static final Map<Object, Object> asMapSafely(@Nullable Object yamlNode) {
        Object object;
        Object yamlNode$iv = yamlNode;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode$iv;
        if (object2 == null) {
            boolean bl = false;
            object = new LinkedHashMap();
        } else if (TypeIntrinsics.isMutableMap((Object)object2)) {
            object = yamlNode$iv;
        } else {
            KubeConfigUtilsKt.LOG.warn((Object)("Unable to parse kubeconfig node. Expected: " + Map.class + ", Actual: " + yamlNode$iv.getClass() + " \n\t" + yamlNode$iv));
            boolean bl = false;
            object = new LinkedHashMap();
        }
        return (Map)object;
    }

    @NotNull
    public static final List<Object> asListSafely(@Nullable Object yamlNode) {
        Object object;
        Object yamlNode$iv = yamlNode;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode$iv;
        if (object2 == null) {
            boolean bl = false;
            object = new ArrayList();
        } else if (TypeIntrinsics.isMutableList((Object)object2)) {
            object = yamlNode$iv;
        } else {
            KubeConfigUtilsKt.LOG.warn((Object)("Unable to parse kubeconfig node. Expected: " + List.class + ", Actual: " + yamlNode$iv.getClass() + " \n\t" + yamlNode$iv));
            boolean bl = false;
            object = new ArrayList();
        }
        return (List)object;
    }

    public static final /* synthetic */ <T> T asTypeSafely(Object yamlNode, Function0<? extends T> typeConstructor) {
        Object object;
        Intrinsics.checkNotNullParameter(typeConstructor, (String)"typeConstructor");
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            object = typeConstructor.invoke();
        } else {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (object2 instanceof Object) {
                object = yamlNode;
            } else {
                KLogger kLogger = KubeConfigUtilsKt.LOG;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                kLogger.warn((Object)("Unable to parse kubeconfig node. Expected: " + Object.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode));
                object = typeConstructor.invoke();
            }
        }
        return (T)object;
    }

    @NotNull
    public static final Map<String, Map<Object, Object>> associateByName(@NotNull Map<?, ?> configuration, @NotNull KubeConfigEntity entity) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Map entities = new LinkedHashMap();
        for (Object entityNode : KubeConfigUtilsKt.getAsListSafely(configuration, entity)) {
            String entityName;
            Map<Object, Object> entityMap = KubeConfigUtilsKt.asMapSafely(entityNode);
            if (KubeConfigUtilsKt.getAsNonBlankStringSafely(entityMap, "name") == null) continue;
            entities.put(entityName, KubeConfigUtilsKt.getAsMapSafely(entityMap, entity));
        }
        return MapsKt.toMap((Map)entities);
    }

    static {
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ContextsConfiguration.class));
    }
}

