/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.pattern.matching;

import com.intellij.kubernetes.logs.pattern.matching.DrainNode;
import com.intellij.kubernetes.logs.pattern.matching.InternalLogCluster;
import com.intellij.kubernetes.logs.pattern.matching.LogCluster;
import com.intellij.kubernetes.logs.pattern.matching.PatternMatchingModel;
import com.intellij.kubernetes.logs.pattern.matching.Tokenizer;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\f\u0018\u0000 12\u00020\u0001:\u0003/01B)\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010 \u001a\u00020\bH\u0016J\u0018\u0010$\u001a\u0004\u0018\u00010\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002J&\u0010'\u001a\u0004\u0018\u00010\u00152\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150&2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\bH\u0002J\u0018\u0010-\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00062"}, d2={"Lcom/intellij/kubernetes/logs/pattern/matching/Drain;", "Lcom/intellij/kubernetes/logs/pattern/matching/PatternMatchingModel;", "maxTreeDepth", "", "minSimilarityThreshold", "", "maxChildrenPerNode", "additionalDelimiters", "", "<init>", "(IDILjava/lang/String;)V", "getMaxTreeDepth", "()I", "getMinSimilarityThreshold", "()D", "getMaxChildrenPerNode", "logMessageDelimiters", "getLogMessageDelimiters", "()Ljava/lang/String;", "clusters", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/kubernetes/logs/pattern/matching/InternalLogCluster;", "root", "Lcom/intellij/kubernetes/logs/pattern/matching/DrainNode;", "tokenizer", "Lcom/intellij/kubernetes/logs/pattern/matching/Tokenizer;", "getTokenizer", "()Lcom/intellij/kubernetes/logs/pattern/matching/Tokenizer;", "tokenizer$delegate", "Lkotlin/Lazy;", "parseLogMessage", "", "message", "", "Lcom/intellij/kubernetes/logs/pattern/matching/LogCluster;", "searchLogMessage", "searchPrefixTree", "logTokens", "", "findBestMatchingCluster", "insertClusterIntoPrefixTree", "newLogCluster", "findOrCreateNode", "node", "token", "handleMissingToken", "createNodeForNonNumericToken", "SequenceMatch", "DrainBuilder", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nDrain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Drain.kt\ncom/intellij/kubernetes/logs/pattern/matching/Drain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1915#2,2:182\n1915#2,2:184\n*S KotlinDebug\n*F\n+ 1 Drain.kt\ncom/intellij/kubernetes/logs/pattern/matching/Drain\n*L\n69#1:182,2\n85#1:184,2\n*E\n"})
public final class Drain
implements PatternMatchingModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxTreeDepth;
    private final double minSimilarityThreshold;
    private final int maxChildrenPerNode;
    @NotNull
    private final String logMessageDelimiters;
    @NotNull
    private final ConcurrentList<InternalLogCluster> clusters;
    @NotNull
    private final DrainNode root;
    @NotNull
    private final Lazy tokenizer$delegate = LazyKt.lazy(() -> Drain.tokenizer_delegate$lambda$0(this));
    @NotNull
    public static final String PARAM_MARKER = "<*>";
    private static final int ROOT_AND_LEAF_LEVELS = 2;

    public final int getMaxTreeDepth() {
        return this.maxTreeDepth;
    }

    public final double getMinSimilarityThreshold() {
        return this.minSimilarityThreshold;
    }

    public final int getMaxChildrenPerNode() {
        return this.maxChildrenPerNode;
    }

    @NotNull
    public final String getLogMessageDelimiters() {
        return this.logMessageDelimiters;
    }

    private Drain(int maxTreeDepth, double minSimilarityThreshold, int maxChildrenPerNode, String additionalDelimiters) {
        this.maxTreeDepth = maxTreeDepth - 2;
        this.minSimilarityThreshold = minSimilarityThreshold;
        this.maxChildrenPerNode = maxChildrenPerNode;
        this.logMessageDelimiters = " " + additionalDelimiters;
        this.root = new DrainNode("(ROOT)", 0);
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.clusters = concurrentList;
    }

    @NotNull
    public final Tokenizer getTokenizer() {
        Lazy lazy = this.tokenizer$delegate;
        return (Tokenizer)lazy.getValue();
    }

    @Override
    public void parseLogMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        List<String> contentTokens = this.getTokenizer().tokenize(message2);
        InternalLogCluster matchCluster = this.searchPrefixTree(contentTokens);
        if (matchCluster == null) {
            matchCluster = new InternalLogCluster(contentTokens, this.getTokenizer());
            this.clusters.add((Object)matchCluster);
            this.insertClusterIntoPrefixTree(matchCluster);
        } else {
            matchCluster.newSighting(contentTokens);
        }
    }

    @Override
    @NotNull
    public List<LogCluster> clusters() {
        return CollectionsKt.toList((Iterable)((Iterable)this.clusters));
    }

    @Override
    @Nullable
    public LogCluster searchLogMessage(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        List<String> contentTokens = this.getTokenizer().tokenize(message2);
        return this.searchPrefixTree(contentTokens);
    }

    private final InternalLogCluster searchPrefixTree(List<String> logTokens) {
        DrainNode node = null;
        DrainNode drainNode = this.root.get(logTokens.size());
        if (drainNode == null) {
            return null;
        }
        node = drainNode;
        if (logTokens.isEmpty()) {
            return node.clusterOf(0);
        }
        int currentDepth = 0;
        currentDepth = 1;
        Iterable $this$forEach$iv = logTokens;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String token = (String)element$iv;
            boolean bl = false;
            if (currentDepth == this.maxTreeDepth || currentDepth == logTokens.size()) continue;
            DrainNode drainNode2 = node.get(token);
            if (drainNode2 == null && (drainNode2 = node.get(PARAM_MARKER)) == null) {
                return null;
            }
            node = drainNode2;
            ++currentDepth;
        }
        return this.findBestMatchingCluster(node.clusters(), logTokens);
    }

    private final InternalLogCluster findBestMatchingCluster(List<InternalLogCluster> clusters, List<String> logTokens) {
        double maxSimilarity = 0.0;
        maxSimilarity = -1.0;
        int maxParamCount = 0;
        maxParamCount = -1;
        InternalLogCluster maxCluster = null;
        Iterable $this$forEach$iv = clusters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InternalLogCluster cluster = (InternalLogCluster)element$iv;
            boolean bl = false;
            SequenceMatch seqDistance = Drain.Companion.computeSequenceDistance(cluster.tokens(), logTokens);
            if (!(seqDistance.getSimilarity() > maxSimilarity) && (!(seqDistance.getSimilarity() == maxSimilarity) || seqDistance.getParamCount() <= maxParamCount)) continue;
            maxSimilarity = seqDistance.getSimilarity();
            maxParamCount = seqDistance.getParamCount();
            maxCluster = cluster;
        }
        return maxSimilarity >= this.minSimilarityThreshold ? maxCluster : null;
    }

    private final void insertClusterIntoPrefixTree(InternalLogCluster newLogCluster) {
        int tokensCount = newLogCluster.tokens().size();
        DrainNode node = this.root.getOrCreateChild(tokensCount);
        if (tokensCount == 0) {
            node.appendCluster(newLogCluster);
            return;
        }
        int currentDepth = 1;
        for (String token : newLogCluster.tokens()) {
            if (currentDepth == this.maxTreeDepth || currentDepth == tokensCount) {
                node.appendCluster(newLogCluster);
                break;
            }
            node = this.findOrCreateNode(node, token);
            ++currentDepth;
        }
    }

    private final DrainNode findOrCreateNode(DrainNode node, String token) {
        DrainNode drainNode;
        if (!node.contains(token)) {
            drainNode = this.handleMissingToken(node, token);
        } else {
            DrainNode drainNode2 = node.get(token);
            drainNode = drainNode2;
            Intrinsics.checkNotNull((Object)drainNode2);
        }
        return drainNode;
    }

    private final DrainNode handleMissingToken(DrainNode node, String token) {
        DrainNode drainNode;
        if (!Drain.Companion.containsNumericToken(token)) {
            drainNode = this.createNodeForNonNumericToken(node, token);
        } else if (!node.contains(PARAM_MARKER)) {
            drainNode = node.getOrCreateChild(PARAM_MARKER);
        } else {
            DrainNode drainNode2 = node.get(PARAM_MARKER);
            drainNode = drainNode2;
            Intrinsics.checkNotNull((Object)drainNode2);
        }
        return drainNode;
    }

    private final DrainNode createNodeForNonNumericToken(DrainNode node, String token) {
        DrainNode drainNode;
        if (node.contains(PARAM_MARKER) && node.childrenCount() >= this.maxChildrenPerNode) {
            DrainNode drainNode2 = node.get(PARAM_MARKER);
            drainNode = drainNode2;
            Intrinsics.checkNotNull((Object)drainNode2);
        } else {
            drainNode = node.childrenCount() < this.maxChildrenPerNode ? node.getOrCreateChild(token) : node.getOrCreateChild(PARAM_MARKER);
        }
        return drainNode;
    }

    private static final Tokenizer tokenizer_delegate$lambda$0(Drain this$0) {
        return new Tokenizer(this$0.logMessageDelimiters);
    }

    public /* synthetic */ Drain(int maxTreeDepth, double minSimilarityThreshold, int maxChildrenPerNode, String additionalDelimiters, DefaultConstructorMarker $constructor_marker) {
        this(maxTreeDepth, minSimilarityThreshold, maxChildrenPerNode, additionalDelimiters);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/logs/pattern/matching/Drain$Companion;", "", "<init>", "()V", "PARAM_MARKER", "", "ROOT_AND_LEAF_LEVELS", "", "computeSequenceDistance", "Lcom/intellij/kubernetes/logs/pattern/matching/Drain$SequenceMatch;", "templateTokens", "", "logTokens", "containsNumericToken", "", "s", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nDrain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Drain.kt\ncom/intellij/kubernetes/logs/pattern/matching/Drain$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,181:1\n1924#2,3:182\n1107#3,2:185\n*S KotlinDebug\n*F\n+ 1 Drain.kt\ncom/intellij/kubernetes/logs/pattern/matching/Drain$Companion\n*L\n170#1:182,3\n177#1:185,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final SequenceMatch computeSequenceDistance(List<String> templateTokens, List<String> logTokens) {
            if (!(templateTokens.size() == logTokens.size())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int similarTokens = 0;
            int paramCount = 0;
            Iterable $this$forEachIndexed$iv = templateTokens;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void token;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)token, (Object)Drain.PARAM_MARKER)) {
                    ++paramCount;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)token, (Object)logTokens.get(index))) continue;
                ++similarTokens;
            }
            double similarity = (double)similarTokens / (double)templateTokens.size();
            return new SequenceMatch(similarity, paramCount);
        }

        private final boolean containsNumericToken(String s) {
            boolean bl;
            block1: {
                CharSequence $this$any$iv = s;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!Character.isDigit(it)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/logs/pattern/matching/Drain$DrainBuilder;", "", "<init>", "()V", "maxTreeDepth", "", "additionalDelimiters", "", "minSimilarityThreshold", "", "maxChildrenPerNode", "depth", "build", "Lcom/intellij/kubernetes/logs/pattern/matching/Drain;", "intellij.clouds.kubernetes"})
    public static final class DrainBuilder {
        private int maxTreeDepth = 4;
        @NotNull
        private String additionalDelimiters = "";
        private double minSimilarityThreshold = 0.4;
        private int maxChildrenPerNode = 100;

        @NotNull
        public final DrainBuilder depth(int maxTreeDepth) {
            if (!(maxTreeDepth > 2)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.maxTreeDepth = maxTreeDepth;
            return this;
        }

        @NotNull
        public final Drain build() {
            return new Drain(this.maxTreeDepth, this.minSimilarityThreshold, this.maxChildrenPerNode, this.additionalDelimiters, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/logs/pattern/matching/Drain$SequenceMatch;", "", "similarity", "", "paramCount", "", "<init>", "(DI)V", "getSimilarity", "()D", "getParamCount", "()I", "intellij.clouds.kubernetes"})
    private static final class SequenceMatch {
        private final double similarity;
        private final int paramCount;

        public SequenceMatch(double similarity, int paramCount) {
            this.similarity = similarity;
            this.paramCount = paramCount;
        }

        public final double getSimilarity() {
            return this.similarity;
        }

        public final int getParamCount() {
            return this.paramCount;
        }
    }
}

