/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.AddDataSourceFromCloud;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.cloudExplorer.CloudConnectionDataStorage;
import com.intellij.database.cloudExplorer.CloudDataSourceProvider;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.ui.CloudConfigurable;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.KnownCloudProviderPlugins;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Consumer;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001f\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/actions/AddDataSourceFromCloud;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getActions", "", "getNewCloudActions", "isDumbAware", "", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nAddDataSourceFromCloud.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddDataSourceFromCloud.kt\ncom/intellij/database/actions/AddDataSourceFromCloud\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n37#2,2:86\n1915#3,2:88\n*S KotlinDebug\n*F\n+ 1 AddDataSourceFromCloud.kt\ncom/intellij/database/actions/AddDataSourceFromCloud\n*L\n33#1:86,2\n38#1:88,2\n*E\n"})
public class AddDataSourceFromCloud
extends DefaultActionGroup
implements DumbAware {
    public AddDataSourceFromCloud() {
        super(DatabaseBundle.message((String)"add.data.source.from.cloud", (Object[])new Object[0]), true);
        this.getTemplatePresentation().setIcon(DatabaseIcons.CloudService);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && Registry.Companion.is("database.datasource.cloud.provider") && DatabaseViewActions.isDataSourceActionsEnabled(e));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        Collection $this$toTypedArray$iv = this.getActions();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    private final List<AnAction> getActions() {
        ArrayList<getActions.1.1> actions = new ArrayList<getActions.1.1>();
        Iterable $this$forEach$iv = CloudConnectionDataStorage.Companion.getInstance().getConnectionsData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloudConnectionData it = (CloudConnectionData)element$iv;
            boolean bl = false;
            String string = it.getName();
            Icon icon = it.getIcon();
            actions.add(new DumbAwareAction(it, string, icon){
                final /* synthetic */ CloudConnectionData $it;
                {
                    this.$it = $it;
                    super($super_call_param$1, null, $super_call_param$2);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project project = e.getProject();
                    if (project == null) {
                        return;
                    }
                    Project project2 = project;
                    DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project2), this.$it, null, (Consumer<? super DatabaseConfigEditor>)((Consumer)arg_0 -> getActions.1.1.actionPerformed$lambda$1(arg_0 -> getActions.1.1.actionPerformed$lambda$0(this.$it, arg_0), arg_0)));
                }

                private static final Unit actionPerformed$lambda$0(CloudConnectionData $it, DatabaseConfigEditor editor2) {
                    block0: {
                        CloudConfigurable cloudConfigurable = (CloudConfigurable)((Object)editor2.getConfigurable((Object)$it, false, CloudConfigurable.class));
                        if (cloudConfigurable == null) break block0;
                        cloudConfigurable.navigateToDatabasesTab();
                    }
                    return Unit.INSTANCE;
                }

                private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            });
        }
        actions.add(Separator.create((String)DatabaseBundle.message((String)"connect.cloud.provider", (Object[])new Object[0])));
        actions.addAll((Collection)this.getNewCloudActions());
        return actions;
    }

    private final List<AnAction> getNewCloudActions() {
        ArrayList<Separator> actions = new ArrayList<Separator>();
        Set presentedProviders = new LinkedHashSet();
        CloudDataSourceProvider.Companion.getProviders().forEach(arg_0 -> AddDataSourceFromCloud.getNewCloudActions$lambda$0(presentedProviders, actions, arg_0));
        List<AnAction> stubsDownloadActions = KnownCloudProviderPlugins.Companion.createDownloadActions(presentedProviders);
        if (!((Collection)stubsDownloadActions).isEmpty()) {
            actions.add(Separator.create((String)DatabaseBundle.message((String)"separator.download.cloud.provider.plugin", (Object[])new Object[0])));
            actions.addAll((Collection)stubsDownloadActions);
        }
        return actions;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static final void getNewCloudActions$lambda$0(Set $presentedProviders, ArrayList $actions, Pair pair) {
        String key = (String)pair.component1();
        CloudDataSourceProvider p = (CloudDataSourceProvider)pair.component2();
        $presentedProviders.add(key);
        String string = p.getDisplayName();
        Icon icon = p.getIcon();
        $actions.add(new DumbAwareAction(p, string, icon){
            final /* synthetic */ CloudDataSourceProvider $p;
            {
                this.$p = $p;
                super($super_call_param$1, null, $super_call_param$2);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                Iterable $this$map$iv = CloudConnectionDataStorage.Companion.getInstance().getConnectionsData();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CloudConnectionData cloudConnectionData = (CloudConnectionData)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                Set existingNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                CloudConnectionData newConnectionData = this.$p.createConnectionData();
                String string = DbUtil.generateUniqueName((String)newConnectionData.getName(), (Set)existingNames);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
                newConnectionData.setName(string);
                DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project2), (Object)newConnectionData, null);
            }
        });
    }
}

