/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.migration;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseToggleNotebookModeAction;
import com.intellij.database.console.DataSourcePerFileMappings;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.migration.ConsolesMigrationManagerImpl;
import com.intellij.database.console.migration.ConsolesMigrationNotification;
import com.intellij.database.console.migration.ConsolesMigrator;
import com.intellij.database.console.migration.ConsolesMigratorKt;
import com.intellij.database.console.migration.dialog.FinishedWithExceptionsMigrationDialog;
import com.intellij.database.console.queryFiles.QueryFilesIgnoreUpdater;
import com.intellij.database.console.queryFiles.QueryFilesOpener;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.database.vfs.DbConsoleRootTypeCore;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0004KLMNB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0086@\u00a2\u0006\u0002\u0010'J\u001c\u0010(\u001a\u0004\u0018\u00010\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0010\u00101\u001a\u0002002\u0006\u0010\u001f\u001a\u00020)H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020$H\u0002J\b\u00105\u001a\u000203H\u0002J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u0012H\u0002J\b\u00108\u001a\u000203H\u0002J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00172\u0006\u0010;\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010<J\u0014\u0010=\u001a\u00020 *\u00020\u00122\u0006\u0010>\u001a\u00020\u0016H\u0002J\b\u0010?\u001a\u000203H\u0002J\u0010\u0010@\u001a\u0002032\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u0002032\u0006\u00107\u001a\u00020DH\u0002J\b\u0010E\u001a\u000203H\u0002J\f\u0010F\u001a\u000203*\u00020\u0013H\u0002J\f\u0010G\u001a\u000203*\u00020\u0013H\u0002J\b\u0010H\u001a\u000203H\u0002J\u001a\u0010I\u001a\u0004\u0018\u00010\u00122\u0006\u0010J\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00190\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "migrationInfo", "Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;)V", "defaultConsoleRegex", "Lkotlin/text/Regex;", "getDefaultConsoleRegex", "()Lkotlin/text/Regex;", "defaultConsoleRegex$delegate", "Lkotlin/Lazy;", "copiedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/database/console/migration/ConsolesMigrator$CopiedFile;", "allConsoles", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "consolesToMigrate", "", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "kotlin.jvm.PlatformType", "invalidDirectoryError", "Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult$Failure;", "path", "", "doPreMigrationChecks", "Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult;", "migrateConsoles", "Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus;", "result", "Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult$Ready;", "(Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult$Ready;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOrCreateDirectory", "Ljava/nio/file/Path;", "localFileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "validateDir", "Lcom/intellij/database/console/migration/ConsolesMigrator$Error;", "file", "checkIfDirectory", "", "checkIfHavePermissionToWrite", "migrationFinished", "", "status", "updateGitignoreIfNeeded", "closeTab", "console", "closeTabs", "copyFiles", "Lcom/intellij/database/console/migration/dialog/FinishedWithExceptionsMigrationDialog$ErrorInfo;", "destinationDir", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveNameForMigratedFile", "ds", "updateMappings", "closeSessionIfNeeded", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "closeConnection", "Lcom/intellij/database/console/JdbcConsole;", "cleanUpConnections", "copyNotebookMode", "copySchema", "saveSettings", "tryToCreateRoot", "contentRootPath", "Error", "MigrationStatus", "PrecheckResult", "CopiedFile", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nConsolesMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsolesMigrator.kt\ncom/intellij/database/console/migration/ConsolesMigrator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n78#2:274\n99#2,5:275\n78#2:281\n99#2,5:282\n221#2,2:289\n221#2,2:291\n1#3:280\n1915#4,2:287\n777#4:293\n873#4,2:294\n1915#4,2:296\n*S KotlinDebug\n*F\n+ 1 ConsolesMigrator.kt\ncom/intellij/database/console/migration/ConsolesMigrator\n*L\n53#1:274\n53#1:275,5\n167#1:281\n167#1:282,5\n168#1:289,2\n176#1:291,2\n167#1:287,2\n207#1:293\n207#1:294,2\n209#1:296,2\n*E\n"})
public final class ConsolesMigrator {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConsolesMigrationManagerImpl.MigrationInfo migrationInfo;
    @NotNull
    private final Lazy defaultConsoleRegex$delegate;
    @NotNull
    private final Map<VirtualFile, CopiedFile> copiedFiles;
    @NotNull
    private final Map<LocalDataSource, List<VirtualFile>> allConsoles;
    @NotNull
    private final Map<LocalDataSource, List<VirtualFile>> consolesToMigrate;
    private final FileEditorManager fileEditorManager;

    public ConsolesMigrator(@NotNull Project project, @NotNull CoroutineScope scope2, @NotNull ConsolesMigrationManagerImpl.MigrationInfo migrationInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        this.project = project;
        this.scope = scope2;
        this.migrationInfo = migrationInfo;
        this.defaultConsoleRegex$delegate = LazyKt.lazy(ConsolesMigrator::defaultConsoleRegex_delegate$lambda$0);
        this.copiedFiles = new LinkedHashMap();
        this.allConsoles = this.migrationInfo.getAllConsoles();
        this.consolesToMigrate = this.migrationInfo.getConsolesToMigrate();
        this.fileEditorManager = FileEditorManager.getInstance((Project)this.project);
    }

    private final Regex getDefaultConsoleRegex() {
        Lazy lazy = this.defaultConsoleRegex$delegate;
        return (Regex)lazy.getValue();
    }

    private final PrecheckResult.Failure invalidDirectoryError(String path) {
        String string = DatabaseBundle.message((String)"consoles.migration.dialog.path.error.unsure", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new PrecheckResult.Failure(new Error.InvalidDirectory(path, string));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PrecheckResult doPreMigrationChecks() {
        Object $this$doPreMigrationChecks_u24lambda_u241;
        void $this$flatMapTo$iv$iv;
        Map<LocalDataSource, List<VirtualFile>> $this$flatMap$iv = this.consolesToMigrate;
        boolean $i$f$flatMap = false;
        Map<LocalDataSource, List<VirtualFile>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        if (((List)destination$iv$iv).isEmpty()) {
            this.migrationFinished(MigrationStatus.Successful.INSTANCE);
            return PrecheckResult.NoWork.INSTANCE;
        }
        Path projectPath = QueryFileSettings.Companion.getValidPathOrNull(Paths.get(this.migrationInfo.getQueriesDirectory(), new String[0]));
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        Object object = this;
        try {
            $this$doPreMigrationChecks_u24lambda_u241 = object;
            boolean bl = false;
            $this$doPreMigrationChecks_u24lambda_u241 = Result.constructor-impl((Object)super.getOrCreateDirectory(projectPath, localFileSystem2));
        }
        catch (Throwable bl) {
            $this$doPreMigrationChecks_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$doPreMigrationChecks_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object e = $this$doPreMigrationChecks_u24lambda_u241 = throwable;
            boolean bl = false;
            String string = this.migrationInfo.getQueriesDirectory();
            String string2 = ((Throwable)e).getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalizedMessage(...)");
            return new PrecheckResult.Failure(new Error.InvalidDirectory(string, string2));
        }
        VirtualFile virtualFile = (VirtualFile)(Result.isFailure-impl((Object)object) ? null : object);
        if (virtualFile == null) {
            return this.invalidDirectoryError(this.migrationInfo.getQueriesDirectory());
        }
        VirtualFile projectDir = virtualFile;
        Error error = this.validateDir(projectDir);
        if (error != null) {
            Error it = error;
            boolean bl = false;
            return new PrecheckResult.Failure(it);
        }
        return new PrecheckResult.Ready(projectDir);
    }

    @Nullable
    public final Object migrateConsoles(@NotNull PrecheckResult.Ready result2, @NotNull Continuation<? super MigrationStatus> $completion) {
        VirtualFile queryFilesDirectory = result2.getProjectDir();
        String string = DatabaseBundle.message((String)"consoles.migration.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TasksKt.withBackgroundProgress((Project)this.project, (String)string, (boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MigrationStatus>, Object>(this, queryFilesDirectory, null){
            int label;
            final /* synthetic */ ConsolesMigrator this$0;
            final /* synthetic */ VirtualFile $queryFilesDirectory;
            {
                this.this$0 = $receiver;
                this.$queryFilesDirectory = $queryFilesDirectory;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = ConsolesMigrator.access$copyFiles(this.this$0, this.$queryFilesDirectory, (Continuation)this);
                        if (v0 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        notMigratedConsoles = (List)v0;
                        $this$map$iv = ConsolesMigrator.access$getCopiedFiles$p(this.this$0).values();
                        $i$f$map = false;
                        var6_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var11_13 = (CopiedFile)item$iv$iv;
                            var13_15 = destination$iv$iv;
                            $i$a$-map-ConsolesMigrator$migrateConsoles$2$migratedConsoles$1 = false;
                            var13_15.add(it.getFrom());
                        }
                        migratedConsoles = (List)destination$iv$iv;
                        status = ((Collection)notMigratedConsoles).isEmpty() == false != false ? (MigrationStatus)new MigrationStatus.FinishedWithExceptions(notMigratedConsoles, migratedConsoles) : (MigrationStatus)MigrationStatus.Successful.INSTANCE;
                        ConsolesMigrator.access$migrationFinished(this.this$0, status);
                        QueryFilesOpener.Companion.suggestAttachingDirectoryIfNotAttached$intellij_database_impl(ConsolesMigrator.access$getProject$p(this.this$0), this.$queryFilesDirectory);
                        $this$invokeSuspend_u24lambda_u241 = var5_6 = QueryFileSettings.Companion.getInstance(ConsolesMigrator.access$getProject$p(this.this$0));
                        $i$a$-apply-ConsolesMigrator$migrateConsoles$2$1 = false;
                        $this$invokeSuspend_u24lambda_u241.setAskedToAttachProjectDirectory();
                        return status;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super MigrationStatus> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final VirtualFile getOrCreateDirectory(Path path, LocalFileSystem localFileSystem) {
        VirtualFile virtualFile;
        Path path2 = path;
        if (path2 != null) {
            Path nonnullPath = path2;
            boolean bl = false;
            virtualFile = localFileSystem.refreshAndFindFileByPath(((Object)nonnullPath).toString());
            if (virtualFile == null) {
                virtualFile = this.tryToCreateRoot(nonnullPath, localFileSystem);
            }
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private final Error validateDir(VirtualFile file) {
        Error error;
        if (!this.checkIfDirectory(file)) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Object[] objectArray = new Object[]{file.getPath()};
            String string2 = DatabaseBundle.message((String)"consoles.migration.dialog.path.error.not.a.dir", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            error = new Error.InvalidDirectory(string, string2);
        } else {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            if (!this.checkIfHavePermissionToWrite(path)) {
                String string3 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                Object[] objectArray = new Object[]{file.getPath()};
                String string4 = DatabaseBundle.message((String)"consoles.migration.dialog.path.error.no.permission", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                error = new Error.InvalidDirectory(string3, string4);
            } else {
                error = null;
            }
        }
        return error;
    }

    private final boolean checkIfDirectory(VirtualFile file) {
        Object object;
        Object object2 = this;
        try {
            ConsolesMigrator $this$checkIfDirectory_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)file.isDirectory());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private final boolean checkIfHavePermissionToWrite(Path path) {
        Object object;
        Object object2 = this;
        try {
            ConsolesMigrator $this$checkIfHavePermissionToWrite_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Files.isWritable(path));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private final void migrationFinished(MigrationStatus status) {
        new ConsolesMigrationNotification(this.migrationInfo, status).notify(this.project);
        this.updateMappings();
        this.closeTabs();
        this.cleanUpConnections();
        this.saveSettings();
        this.updateGitignoreIfNeeded();
    }

    private final void updateGitignoreIfNeeded() {
        ((QueryFilesIgnoreUpdater)this.project.getService(QueryFilesIgnoreUpdater.class)).suggestUpdatingGitignoreIfNeeded();
    }

    private final void closeTab(VirtualFile console) {
        block4: {
            Object object;
            Object object2 = this;
            try {
                List list;
                ConsolesMigrator $this$closeTab_u24lambda_u240 = object2;
                boolean bl = false;
                $this$closeTab_u24lambda_u240.fileEditorManager.closeFile(console);
                CopiedFile copiedFile = $this$closeTab_u24lambda_u240.copiedFiles.get(console);
                if (copiedFile != null) {
                    CopiedFile copiedFile2 = copiedFile;
                    boolean bl2 = false;
                    list = $this$closeTab_u24lambda_u240.fileEditorManager.openFile(copiedFile2.getTo());
                } else {
                    list = null;
                }
                object = Result.constructor-impl(list);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object it = object = throwable;
            boolean bl = false;
            ConsolesMigratorKt.access$getLOG$p().error("Couldn't close tab for " + console.getPath(), (Throwable)it);
        }
    }

    private final void closeTabs() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ConsolesMigrator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ ConsolesMigrator this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$forEach$iv;
                                        void $this$filterTo$iv$iv;
                                        ResultKt.throwOnFailure((Object)$result);
                                        VirtualFile[] virtualFileArray = ConsolesMigrator.access$getFileEditorManager$p(this.this$0).getOpenFiles();
                                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
                                        Object $this$filter$iv = virtualFileArray;
                                        boolean $i$f$filter = false;
                                        Object[] objectArray = $this$filter$iv;
                                        Collection destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$filterTo = false;
                                        for (void element$iv$iv : $this$filterTo$iv$iv) {
                                            VirtualFile it = (VirtualFile)element$iv$iv;
                                            boolean bl = false;
                                            if (!(ScratchFileService.findRootType((VirtualFile)it) instanceof DbConsoleRootTypeCore)) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        $this$filter$iv = (List)destination$iv$iv;
                                        ConsolesMigrator consolesMigrator = this.this$0;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            VirtualFile it = (VirtualFile)element$iv;
                                            boolean bl = false;
                                            Intrinsics.checkNotNull((Object)it);
                                            ConsolesMigrator.access$closeTab(consolesMigrator, it);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object copyFiles(VirtualFile destinationDir, Continuation<? super List<FinishedWithExceptionsMigrationDialog.ErrorInfo>> $completion) {
        if (!($completion instanceof copyFiles.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ConsolesMigrator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConsolesMigrator.access$copyFiles(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                notMigratedConsoles = new ArrayList<E>();
                var4_7 = this.consolesToMigrate.entrySet().iterator();
                while (var4_7.hasNext()) {
                    ds = var4_7.next();
                    var6_9 = ((List)ds.getValue()).iterator();
lbl17:
                    // 3 sources

                    while (var6_9.hasNext()) {
                        console = (VirtualFile)var6_9.next();
                        var8_11 = this;
                        $this$copyFiles_u24lambda_u240 = var8_11;
                        $i$a$-runCatching-ConsolesMigrator$copyFiles$2 = 0;
                        $continuation.L$0 = destinationDir;
                        $continuation.L$1 = notMigratedConsoles;
                        $continuation.L$2 = var4_7;
                        $continuation.L$3 = ds;
                        $continuation.L$4 = var6_9;
                        $continuation.L$5 = console;
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)$this$copyFiles_u24lambda_u240);
                        $continuation.I$0 = $i$a$-runCatching-ConsolesMigrator$copyFiles$2;
                        $continuation.label = 1;
                        v0 = CoroutinesKt.edtWriteAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, copyFiles$lambda$0$0(com.intellij.openapi.vfs.VirtualFile com.intellij.openapi.vfs.VirtualFile com.intellij.database.console.migration.ConsolesMigrator java.util.Map$Entry ), ()Lkotlin/Unit;)((VirtualFile)console, (VirtualFile)destinationDir, (ConsolesMigrator)$this$copyFiles_u24lambda_u240, (Map.Entry)ds), (Continuation)$continuation);
                        ** if (v0 != var14_5) goto lbl37
lbl36:
                        // 1 sources

                        return var14_5;
lbl37:
                        // 1 sources

                        ** GOTO lbl53
                    }
                }
                break;
            }
            case 1: {
                $i$a$-runCatching-ConsolesMigrator$copyFiles$2 = $continuation.I$0;
                $this$copyFiles_u24lambda_u240 = (ConsolesMigrator)$continuation.L$6;
                console = (VirtualFile)$continuation.L$5;
                var6_9 = (Iterator<E>)$continuation.L$4;
                ds = (Map.Entry)$continuation.L$3;
                var4_7 = (Iterator)$continuation.L$2;
                notMigratedConsoles = (List)$continuation.L$1;
                destinationDir = (VirtualFile)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl53:
                    // 2 sources

                    var9_12 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable $i$a$-runCatching-ConsolesMigrator$copyFiles$2) {
                    var9_12 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-ConsolesMigrator$copyFiles$2));
                }
                var8_11 = var9_12;
                v1 = Result.exceptionOrNull-impl((Object)var8_11);
                if (v1 == null) ** GOTO lbl17
                e = var9_12 = v1;
                $i$a$-onFailure-ConsolesMigrator$copyFiles$3 = false;
                v2 = ((LocalDataSource)ds.getKey()).getName();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                notMigratedConsoles.add(new FinishedWithExceptionsMigrationDialog.ErrorInfo(console, v2, (Throwable)e));
                ConsolesMigratorKt.access$getLOG$p().error("Couldn't migrate " + console.getPath(), (Throwable)e);
                ConsolesMigratorKt.access$getLOG$p().error((Throwable)e);
                ** GOTO lbl17
            }
        }
        return notMigratedConsoles;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String resolveNameForMigratedFile(VirtualFile $this$resolveNameForMigratedFile, LocalDataSource ds) {
        String string;
        Regex regex = this.getDefaultConsoleRegex();
        String string2 = $this$resolveNameForMigratedFile.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
        if (!regex.matches((CharSequence)string2)) {
            String string3 = $this$resolveNameForMigratedFile.getNameWithoutExtension();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(...)");
        } else {
            String string4 = this.migrationInfo.getFileNameTemplate();
            String string5 = ds.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            string = QueryFileSettings.Companion.getNameForQueryFile(string4, string5);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMappings() {
        Object $this$updateMappings_u24lambda_u240;
        Object object = this;
        try {
            Object element$iv;
            Map<VirtualFile, CopiedFile> $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            $this$updateMappings_u24lambda_u240 = object;
            boolean bl = false;
            DataSourcePerFileMappings perFileMapping = DataSourcePerFileMappings.Companion.getInstance(((ConsolesMigrator)$this$updateMappings_u24lambda_u240).project);
            Map map2 = perFileMapping.getMappings();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getMappings(...)");
            Map map3 = MapsKt.toMutableMap((Map)map2);
            Object $this$flatMap$iv = ((ConsolesMigrator)$this$updateMappings_u24lambda_u240).allConsoles;
            boolean $i$f$flatMap = false;
            Iterator<Map.Entry<VirtualFile, CopiedFile>> iterator = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                Iterable list$iv$iv = (Iterable)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl3 = false;
                map3.remove(it);
            }
            $this$forEach$iv = ((ConsolesMigrator)$this$updateMappings_u24lambda_u240).copiedFiles;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = element$iv = iterator.next();
                boolean bl4 = false;
                CopiedFile createdFile = (CopiedFile)object2.getValue();
                map3.put(createdFile.getTo(), createdFile.getDataSource());
            }
            perFileMapping.setMappings(MapsKt.toMap((Map)map3));
            $this$updateMappings_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$updateMappings_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$updateMappings_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$updateMappings_u24lambda_u240 = throwable;
            boolean bl = false;
            ConsolesMigratorKt.access$getLOG$p().error("Couldn't update mappings", (Throwable)it);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            ConsolesMigratorKt.access$getLOG$p().info("DataSourcePerFileMappings successfully updated");
        }
        Map<VirtualFile, CopiedFile> $this$forEach$iv = this.copiedFiles;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, CopiedFile>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VirtualFile, CopiedFile> element$iv;
            Map.Entry<VirtualFile, CopiedFile> entry = element$iv = iterator.next();
            boolean bl = false;
            CopiedFile createdFile = entry.getValue();
            this.copySchema(createdFile);
            this.copyNotebookMode(createdFile);
        }
    }

    private final void closeSessionIfNeeded(DatabaseSession session) {
        if (session.getClients().length == 0) {
            SessionsUtil.close((DatabaseSession)session);
            ConsolesMigratorKt.access$getLOG$p().info("Session closed for " + session.getDisplayName());
        }
    }

    private final void closeConnection(JdbcConsole console) {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(console, this, null){
            int label;
            final /* synthetic */ JdbcConsole $console;
            final /* synthetic */ ConsolesMigrator this$0;
            {
                this.$console = $console;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$console, this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ JdbcConsole $console;
                            final /* synthetic */ ConsolesMigrator this$0;
                            {
                                this.$console = $console;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Object $this$invokeSuspend_u24lambda_u240;
                                        void $this$withContext;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object = $this$withContext;
                                        JdbcConsole jdbcConsole = this.$console;
                                        Object object2 = this.this$0;
                                        try {
                                            $this$invokeSuspend_u24lambda_u240 = object;
                                            boolean bl = false;
                                            DatabaseSession databaseSession = jdbcConsole.getSession();
                                            Intrinsics.checkNotNullExpressionValue((Object)databaseSession, (String)"<get-session>(...)");
                                            DatabaseSession session = databaseSession;
                                            session.detach((DatabaseSessionClient)jdbcConsole);
                                            ConsolesMigratorKt.access$getLOG$p().info("Console " + jdbcConsole.getVirtualFile().getPath() + " detached from session");
                                            ConsolesMigrator.access$closeSessionIfNeeded((ConsolesMigrator)object2, session);
                                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                                        }
                                        catch (Throwable bl) {
                                            $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                                        }
                                        object = $this$invokeSuspend_u24lambda_u240;
                                        jdbcConsole = this.$console;
                                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                                        if (throwable != null) {
                                            Object it = object2 = throwable;
                                            boolean bl = false;
                                            ConsolesMigratorKt.access$getLOG$p().error("Couldn't detach console " + jdbcConsole.getVirtualFile().getPath() + " from session", (Throwable)it);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanUpConnections() {
        void $this$filterTo$iv$iv;
        List<JdbcConsole> list = JdbcConsole.getActiveConsoles(this.project);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getActiveConsoles(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JdbcConsole it = (JdbcConsole)((Object)element$iv$iv);
            boolean bl = false;
            if (!(ScratchFileService.findRootType((VirtualFile)it.getVirtualFile()) instanceof DbConsoleRootTypeCore)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdbcConsole it = (JdbcConsole)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)((Object)it));
            this.closeConnection(it);
        }
    }

    private final void copyNotebookMode(CopiedFile $this$copyNotebookMode) {
        Object $this$copyNotebookMode_u24lambda_u240;
        Object object = $this$copyNotebookMode;
        try {
            $this$copyNotebookMode_u24lambda_u240 = object;
            boolean bl = false;
            boolean isNotebookNode = DatabaseToggleNotebookModeAction.isNotebookMode(this.project, ((CopiedFile)$this$copyNotebookMode_u24lambda_u240).getFrom());
            DatabaseToggleNotebookModeAction.setNotebookMode(this.project, ((CopiedFile)$this$copyNotebookMode_u24lambda_u240).getTo(), isNotebookNode);
            $this$copyNotebookMode_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$copyNotebookMode_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$copyNotebookMode_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object e = $this$copyNotebookMode_u24lambda_u240 = throwable;
            boolean bl = false;
            ConsolesMigratorKt.access$getLOG$p().error("Couldn't copy notebook mode for " + $this$copyNotebookMode.getFrom().getPath() + " to " + $this$copyNotebookMode.getTo().getPath(), (Throwable)e);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            ConsolesMigratorKt.access$getLOG$p().info("Notebook mode for " + $this$copyNotebookMode.getFrom().getPath() + " successfully copied to " + $this$copyNotebookMode.getTo().getPath());
        }
    }

    private final void copySchema(CopiedFile $this$copySchema) {
        Object $this$copySchema_u24lambda_u240;
        Object object = $this$copySchema;
        try {
            $this$copySchema_u24lambda_u240 = object;
            boolean bl = false;
            ChooseSchemaAction.copySearchPathTo(this.project, ((CopiedFile)$this$copySchema_u24lambda_u240).getFrom(), ((CopiedFile)$this$copySchema_u24lambda_u240).getTo(), ((CopiedFile)$this$copySchema_u24lambda_u240).getDataSource());
            $this$copySchema_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$copySchema_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$copySchema_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object e = $this$copySchema_u24lambda_u240 = throwable;
            boolean bl = false;
            ConsolesMigratorKt.access$getLOG$p().error("Couldn't copy schema for " + $this$copySchema.getFrom().getPath() + " to " + $this$copySchema.getTo().getPath(), (Throwable)e);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            ConsolesMigratorKt.access$getLOG$p().info("Schema from " + $this$copySchema.getFrom().getPath() + " successfully copied to " + $this$copySchema.getTo().getPath());
        }
    }

    private final void saveSettings() {
        Object object;
        QueryFileSettings $this$saveSettings_u24lambda_u240 = QueryFileSettings.Companion.getInstance(this.project);
        boolean bl = false;
        Object object2 = $this$saveSettings_u24lambda_u240;
        QueryFileSettings queryFileSettings = $this$saveSettings_u24lambda_u240;
        try {
            QueryFileSettings $this$saveSettings_u24lambda_u240_u240 = object2;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)Paths.get(this.migrationInfo.getQueriesDirectory(), new String[0]));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        queryFileSettings.setQueriesDirectory((Path)(Result.isFailure-impl((Object)object2) ? null : object2));
        $this$saveSettings_u24lambda_u240.setFileNameTemplate(this.migrationInfo.getFileNameTemplate());
    }

    private final VirtualFile tryToCreateRoot(Path contentRootPath, LocalFileSystem localFileSystem) {
        VirtualFile virtualFile;
        ConsolesMigratorKt.access$getLOG$p().info("Trying to find or create directory " + contentRootPath + " for migrated files");
        Files.createDirectories(contentRootPath, new FileAttribute[0]);
        VirtualFile $this$tryToCreateRoot_u24lambda_u240 = virtualFile = localFileSystem.refreshAndFindFileByNioFile(contentRootPath);
        boolean bl = false;
        if ($this$tryToCreateRoot_u24lambda_u240 == null) {
            ConsolesMigratorKt.access$getLOG$p().error("Couldn't find or create directory " + contentRootPath + " for migrated files");
        } else {
            ConsolesMigratorKt.access$getLOG$p().info("Directory " + contentRootPath + " successfully created");
        }
        return virtualFile;
    }

    private static final Regex defaultConsoleRegex_delegate$lambda$0() {
        return new Regex("console(_[1-9]\\d{0,4})?");
    }

    private static final Unit copyFiles$lambda$0$0(VirtualFile $console, VirtualFile $destinationDir, ConsolesMigrator $this_runCatching, Map.Entry $ds) {
        ConsolesMigratorKt.access$getLOG$p().info("Starting migration of " + $console.getPath() + " to " + $destinationDir.getPath());
        String defaultName = $this_runCatching.resolveNameForMigratedFile($console, (LocalDataSource)$ds.getKey());
        String string = $console.getExtension();
        if (string == null) {
            string = "sql";
        }
        String string2 = VfsUtil.getNextAvailableName((VirtualFile)$destinationDir, (String)defaultName, (String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNextAvailableName(...)");
        String newName = string2;
        VirtualFile virtualFile = $console.copy((Object)$this_runCatching, $destinationDir, newName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"copy(...)");
        VirtualFile newFile = virtualFile;
        $this_runCatching.copiedFiles.put($console, new CopiedFile((LocalDataSource)$ds.getKey(), $console, newFile));
        ConsolesMigratorKt.access$getLOG$p().info("File " + $console.getPath() + " successfully migrated to " + $destinationDir.getPath() + " with name " + newName);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$copyFiles(ConsolesMigrator $this, VirtualFile destinationDir, Continuation $completion) {
        return $this.copyFiles(destinationDir, (Continuation<? super List<FinishedWithExceptionsMigrationDialog.ErrorInfo>>)$completion);
    }

    public static final /* synthetic */ Map access$getCopiedFiles$p(ConsolesMigrator $this) {
        return $this.copiedFiles;
    }

    public static final /* synthetic */ void access$migrationFinished(ConsolesMigrator $this, MigrationStatus status) {
        $this.migrationFinished(status);
    }

    public static final /* synthetic */ Project access$getProject$p(ConsolesMigrator $this) {
        return $this.project;
    }

    public static final /* synthetic */ FileEditorManager access$getFileEditorManager$p(ConsolesMigrator $this) {
        return $this.fileEditorManager;
    }

    public static final /* synthetic */ void access$closeTab(ConsolesMigrator $this, VirtualFile console) {
        $this.closeTab(console);
    }

    public static final /* synthetic */ void access$closeSessionIfNeeded(ConsolesMigrator $this, DatabaseSession session) {
        $this.closeSessionIfNeeded(session);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$CopiedFile;", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "from", "Lcom/intellij/openapi/vfs/VirtualFile;", "to", "<init>", "(Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getFrom", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTo", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    private static final class CopiedFile {
        @NotNull
        private final LocalDataSource dataSource;
        @NotNull
        private final VirtualFile from;
        @NotNull
        private final VirtualFile to;

        public CopiedFile(@NotNull LocalDataSource dataSource, @NotNull VirtualFile from, @NotNull VirtualFile to) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            this.dataSource = dataSource;
            this.from = from;
            this.to = to;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public final VirtualFile getFrom() {
            return this.from;
        }

        @NotNull
        public final VirtualFile getTo() {
            return this.to;
        }

        @NotNull
        public final LocalDataSource component1() {
            return this.dataSource;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.from;
        }

        @NotNull
        public final VirtualFile component3() {
            return this.to;
        }

        @NotNull
        public final CopiedFile copy(@NotNull LocalDataSource dataSource, @NotNull VirtualFile from, @NotNull VirtualFile to) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return new CopiedFile(dataSource, from, to);
        }

        public static /* synthetic */ CopiedFile copy$default(CopiedFile copiedFile, LocalDataSource localDataSource, VirtualFile virtualFile, VirtualFile virtualFile2, int n, Object object) {
            if ((n & 1) != 0) {
                localDataSource = copiedFile.dataSource;
            }
            if ((n & 2) != 0) {
                virtualFile = copiedFile.from;
            }
            if ((n & 4) != 0) {
                virtualFile2 = copiedFile.to;
            }
            return copiedFile.copy(localDataSource, virtualFile, virtualFile2);
        }

        @NotNull
        public String toString() {
            return "CopiedFile(dataSource=" + this.dataSource + ", from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            int result2 = this.dataSource.hashCode();
            result2 = result2 * 31 + this.from.hashCode();
            result2 = result2 * 31 + this.to.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CopiedFile)) {
                return false;
            }
            CopiedFile copiedFile = (CopiedFile)other;
            if (!Intrinsics.areEqual((Object)this.dataSource, (Object)copiedFile.dataSource)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.from, (Object)copiedFile.from)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.to, (Object)copiedFile.to);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0001\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$Error;", "", "<init>", "()V", "InvalidDirectory", "Lcom/intellij/database/console/migration/ConsolesMigrator$Error$InvalidDirectory;", "intellij.database.impl"})
    public static abstract sealed class Error {
        private Error() {
        }

        public /* synthetic */ Error(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$Error$InvalidDirectory;", "Lcom/intellij/database/console/migration/ConsolesMigrator$Error;", "directory", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDirectory", "()Ljava/lang/String;", "getMessage", "intellij.database.impl"})
        public static final class InvalidDirectory
        extends Error {
            @NotNull
            private final String directory;
            @NotNull
            private final String message;

            public InvalidDirectory(@NotNull String directory, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.directory = directory;
                this.message = message;
            }

            @NotNull
            public final String getDirectory() {
                return this.directory;
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus;", "", "<init>", "()V", "Successful", "FinishedWithExceptions", "Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus$FinishedWithExceptions;", "Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus$Successful;", "intellij.database.impl"})
    public static abstract sealed class MigrationStatus {
        private MigrationStatus() {
        }

        public /* synthetic */ MigrationStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus$FinishedWithExceptions;", "Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus;", "errors", "", "Lcom/intellij/database/console/migration/dialog/FinishedWithExceptionsMigrationDialog$ErrorInfo;", "migratedConsoles", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getErrors", "()Ljava/util/List;", "getMigratedConsoles", "intellij.database.impl"})
        public static final class FinishedWithExceptions
        extends MigrationStatus {
            @NotNull
            private final List<FinishedWithExceptionsMigrationDialog.ErrorInfo> errors;
            @NotNull
            private final List<VirtualFile> migratedConsoles;

            public FinishedWithExceptions(@NotNull List<FinishedWithExceptionsMigrationDialog.ErrorInfo> errors, @NotNull List<? extends VirtualFile> migratedConsoles) {
                Intrinsics.checkNotNullParameter(errors, (String)"errors");
                Intrinsics.checkNotNullParameter(migratedConsoles, (String)"migratedConsoles");
                super(null);
                this.errors = errors;
                this.migratedConsoles = migratedConsoles;
            }

            @NotNull
            public final List<FinishedWithExceptionsMigrationDialog.ErrorInfo> getErrors() {
                return this.errors;
            }

            @NotNull
            public final List<VirtualFile> getMigratedConsoles() {
                return this.migratedConsoles;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus$Successful;", "Lcom/intellij/database/console/migration/ConsolesMigrator$MigrationStatus;", "<init>", "()V", "intellij.database.impl"})
        public static final class Successful
        extends MigrationStatus {
            @NotNull
            public static final Successful INSTANCE = new Successful();

            private Successful() {
                super(null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult;", "", "<init>", "()V", "Ready", "NoWork", "Failure", "intellij.database.impl"})
    public static class PrecheckResult {

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult$Failure;", "Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult;", "error", "Lcom/intellij/database/console/migration/ConsolesMigrator$Error;", "<init>", "(Lcom/intellij/database/console/migration/ConsolesMigrator$Error;)V", "getError", "()Lcom/intellij/database/console/migration/ConsolesMigrator$Error;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.database.impl"})
        public static final class Failure
        extends PrecheckResult {
            @NotNull
            private final Error error;

            public Failure(@NotNull Error error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.error = error;
            }

            @NotNull
            public final Error getError() {
                return this.error;
            }

            @NotNull
            public final Error component1() {
                return this.error;
            }

            @NotNull
            public final Failure copy(@NotNull Error error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                return new Failure(error);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, Error error, int n, Object object) {
                if ((n & 1) != 0) {
                    error = failure.error;
                }
                return failure.copy(error);
            }

            @NotNull
            public String toString() {
                return "Failure(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failure.error);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult$NoWork;", "Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.database.impl"})
        public static final class NoWork
        extends PrecheckResult {
            @NotNull
            public static final NoWork INSTANCE = new NoWork();

            private NoWork() {
            }

            @NotNull
            public String toString() {
                return "NoWork";
            }

            public int hashCode() {
                return 1615178185;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoWork)) {
                    return false;
                }
                NoWork cfr_ignored_0 = (NoWork)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult$Ready;", "Lcom/intellij/database/console/migration/ConsolesMigrator$PrecheckResult;", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProjectDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.database.impl"})
        public static final class Ready
        extends PrecheckResult {
            @NotNull
            private final VirtualFile projectDir;

            public Ready(@NotNull VirtualFile projectDir) {
                Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
                this.projectDir = projectDir;
            }

            @NotNull
            public final VirtualFile getProjectDir() {
                return this.projectDir;
            }

            @NotNull
            public final VirtualFile component1() {
                return this.projectDir;
            }

            @NotNull
            public final Ready copy(@NotNull VirtualFile projectDir) {
                Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
                return new Ready(projectDir);
            }

            public static /* synthetic */ Ready copy$default(Ready ready, VirtualFile virtualFile, int n, Object object) {
                if ((n & 1) != 0) {
                    virtualFile = ready.projectDir;
                }
                return ready.copy(virtualFile);
            }

            @NotNull
            public String toString() {
                return "Ready(projectDir=" + this.projectDir + ")";
            }

            public int hashCode() {
                return this.projectDir.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Ready)) {
                    return false;
                }
                Ready ready = (Ready)other;
                return Intrinsics.areEqual((Object)this.projectDir, (Object)ready.projectDir);
            }
        }
    }
}

