/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBus;
import icons.DatabaseIcons;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0015\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorTool;", "", "<init>", "()V", "toolWindowId", "", "toolWindows", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/wm/ToolWindow;", "show", "", "project", "model", "Lcom/intellij/database/model/basic/BasicModel;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "obtainDefaultContext", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "activate", "", "obtainToolWindow", "forgetProjectToolWindow", "forgetProjectToolWindow$intellij_database_impl", "intellij.database.impl"})
public final class ScriptGeneratorTool {
    @NotNull
    public static final ScriptGeneratorTool INSTANCE = new ScriptGeneratorTool();
    @NotNull
    private static final String toolWindowId = "SQL Generator";
    @NotNull
    private static final ConcurrentMap<Project, ToolWindow> toolWindows = new ConcurrentHashMap();

    private ScriptGeneratorTool() {
    }

    public final void show(@NotNull Project project, @NotNull BasicModel model, @NotNull Iterable<? extends BasicNode> nodes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        ScriptGeneratorUI context = this.obtainDefaultContext(project, true);
        context.getMainPanel$intellij_database_impl().setVisible(true);
        context.startGeneration(model, nodes);
    }

    private final ScriptGeneratorUI obtainDefaultContext(Project project, boolean activate) {
        ToolWindow toolWindow = this.obtainToolWindow(project);
        if (activate) {
            toolWindow.activate(ScriptGeneratorTool::obtainDefaultContext$lambda$0);
        }
        Content content = toolWindow.getContentManager().getSelectedContent();
        if (content == null) {
            throw new IllegalStateException("Database Scripting UI: no default content".toString());
        }
        Content content2 = content;
        ScriptGeneratorUI scriptGeneratorUI = (ScriptGeneratorUI)content2.getUserData(ScriptGeneratorUI.Companion.getContextKey$intellij_database_impl());
        if (scriptGeneratorUI == null) {
            throw new IllegalStateException("Database Scripting UI: the default content is not assigned with a context".toString());
        }
        ScriptGeneratorUI context = scriptGeneratorUI;
        return context;
    }

    private final ToolWindow obtainToolWindow(Project project) {
        String string = DatabaseBundle.message((String)"scriptGen.ui.toolWindowTitle", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        ToolWindow toolWindow = toolWindows.computeIfAbsent(project, arg_0 -> ScriptGeneratorTool.obtainToolWindow$lambda$1(arg_0 -> ScriptGeneratorTool.obtainToolWindow$lambda$0(project, title, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)toolWindow, (String)"computeIfAbsent(...)");
        return toolWindow;
    }

    public final void forgetProjectToolWindow$intellij_database_impl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        toolWindows.remove(project);
    }

    private static final void obtainDefaultContext$lambda$0() {
    }

    private static final ToolWindow obtainToolWindow$lambda$0(Project $project, String $title, Project it) {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance($project);
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
        MessageBus messageBus = $project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, false, toolWindowAnchor, (Disposable)messageBus);
        toolWindow.setTitle($title);
        toolWindow.setStripeTitle($title);
        toolWindow.setIcon(DatabaseIcons.ToolWindowSQLGenerator);
        ScriptGeneratorUI defaultContext = new ScriptGeneratorUI($project);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.getFactory().createContent((JComponent)defaultContext.getMainPanel$intellij_database_impl(), "", false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setPreferredFocusableComponent((JComponent)defaultContext.getViewer$intellij_database_impl());
        content2.putUserData(ScriptGeneratorUI.Companion.getContextKey$intellij_database_impl(), (Object)defaultContext);
        contentManager2.addContent(content2);
        defaultContext.setContent$intellij_database_impl(content2);
        Disposer.register((Disposable)((Disposable)$project.getMessageBus()), (Disposable)defaultContext);
        return toolWindow;
    }

    private static final ToolWindow obtainToolWindow$lambda$1(Function1 $tmp0, Object p0) {
        return (ToolWindow)$tmp0.invoke(p0);
    }
}

