/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.settings.AppearanceComponents;
import com.intellij.database.settings.DataGridAppearanceConfigurableKt;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridAppearanceSettingsImpl;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.DatabaseSettingsDataViews;
import com.intellij.database.util.TimeZoneTextField;
import com.intellij.database.util.common.TimeFunKt;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.ui.validation.ValidationUtilKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.PlatformUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 E2\u00020\u0001:\u0001EB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u008c\u0001\u0010\u0016\u001a\u00020\r*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0018\u00010\u001b2B\u0010\u001e\u001a>\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020!0 \u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020%0 \u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\r0\u001fH\u0002J\u0080\u0001\u0010'\u001a\u00020\r*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 2\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0018\u00010\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\fH\u0002JV\u0010.\u001a\u00020\r*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0018\u00010\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020/0\fH\u0002J\u0014\u00100\u001a\u00020\r*\u00020\u00172\u0006\u00101\u001a\u000202H\u0002J\u0012\u00103\u001a\b\u0012\u0004\u0012\u00020!0 *\u000204H\u0002J\u0017\u00105\u001a\t\u0018\u00010\u0019\u00a2\u0006\u0002\b62\u0006\u00107\u001a\u00020\u0019H\u0002J\u0017\u00108\u001a\t\u0018\u00010\u0019\u00a2\u0006\u0002\b62\u0006\u00109\u001a\u00020\u0019H\u0002J\b\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u00020AH\u0002J]\u0010B\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0 2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\fH\u0082\bJ3\u0010C\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020/0\fH\u0082\bJ\b\u0010D\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\u0004\u0018\u00010;8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006F"}, d2={"Lcom/intellij/database/settings/DatabaseSettingsDataViews;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "<init>", "()V", "isResetting", "", "appearanceComponents", "Lcom/intellij/database/settings/AppearanceComponents;", "useCustomFont", "getUseCustomFont", "()Z", "refreshZonedTimePreview", "Lkotlin/Function0;", "", "refreshZonedDateTimePreview", "timeZoneField", "Lcom/intellij/database/util/TimeZoneTextField;", "apply", "isModified", "reset", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "appendFormatControls", "Lcom/intellij/ui/dsl/builder/Panel;", "labelKey", "", "enabledProperty", "Lkotlin/reflect/KMutableProperty0;", "patternProperty", "previewRefresherProperty", "refresh", "Lkotlin/Function2;", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBTextField;", "Lkotlin/ParameterName;", "name", "formatField", "Ljavax/swing/JEditorPane;", "previewField", "appendNumberFormatControls", "decimalSeparatorField", "useGroupingCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "groupSeparatorField", "sample", "", "appendDateTimeFormatControls", "Ljava/time/temporal/TemporalAccessor;", "appendTimeZoneFormatControls", "settings", "Lcom/intellij/database/settings/DatabaseSettings;", "positiveIntTextField", "Lcom/intellij/ui/dsl/builder/Row;", "validateDatePattern", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "pattern", "validateTimeZone", "zoneId", "currentTimeZone", "Ljava/time/ZoneId;", "getCurrentTimeZone", "()Ljava/time/ZoneId;", "newZonedTime", "Ljava/time/OffsetTime;", "newZonedDateTime", "Ljava/time/OffsetDateTime;", "updateNumberFormatCommentField", "updateDateTimeFormatCommentField", "refreshZonedPreviews", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseSettingsDataViews.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseSettingsDataViews.kt\ncom/intellij/database/settings/DatabaseSettingsDataViews\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n503#1,15:541\n524#1,8:556\n27#2:538\n27#2:539\n1#3:540\n*S KotlinDebug\n*F\n+ 1 DatabaseSettingsDataViews.kt\ncom/intellij/database/settings/DatabaseSettingsDataViews\n*L\n417#1:541,15\n429#1:556,8\n301#1:538\n309#1:539\n*E\n"})
final class DatabaseSettingsDataViews
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isResetting;
    @Nullable
    private AppearanceComponents appearanceComponents;
    @NotNull
    private Function0<Unit> refreshZonedTimePreview;
    @NotNull
    private Function0<Unit> refreshZonedDateTimePreview;
    private TimeZoneTextField timeZoneField;
    @NotNull
    private static final MouseShortcut ALT_CLICK_SHORTCUT = new MouseShortcut(1, 512, 1);
    @NotNull
    private static final MouseShortcut CLICK_SHORTCUT = new MouseShortcut(1, 0, 1);

    public DatabaseSettingsDataViews() {
        String string = IdeBundle.message((String)"configurable.DatabaseSettingsConfigurable.DataViews.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "preferences.database.dataViews", "database.data.views");
        this.refreshZonedTimePreview = DatabaseSettingsDataViews::refreshZonedTimePreview$lambda$0;
        this.refreshZonedDateTimePreview = DatabaseSettingsDataViews::refreshZonedDateTimePreview$lambda$0;
    }

    private final boolean getUseCustomFont() {
        AppearanceComponents appearanceComponents = this.appearanceComponents;
        return appearanceComponents != null && (appearanceComponents = appearanceComponents.getUseCustomFontCell()) != null && (appearanceComponents = (JBCheckBox)appearanceComponents.getComponent()) != null ? appearanceComponents.isSelected() : false;
    }

    public void apply() {
        super.apply();
        AppearanceComponents appearanceComponents = this.appearanceComponents;
        if (appearanceComponents != null && (appearanceComponents = appearanceComponents.getCustomFontOptionsPanel()) != null) {
            appearanceComponents.apply(this.getUseCustomFont());
        }
        DatabaseSettings.fireSettingsChanged();
        DataGridAppearanceSettingsImpl.fireSettingsChanged();
    }

    public boolean isModified() {
        AppearanceComponents appearanceComponents;
        return super.isModified() || ((appearanceComponents = this.appearanceComponents) != null && (appearanceComponents = appearanceComponents.getCustomFontOptionsPanel()) != null ? appearanceComponents.isModified(this.getUseCustomFont()) : false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.isResetting = true;
            super.reset();
            AppearanceComponents appearanceComponents = this.appearanceComponents;
            if (appearanceComponents != null && (appearanceComponents = appearanceComponents.getCustomFontOptionsPanel()) != null) {
                appearanceComponents.reset();
            }
        }
        finally {
            this.isResetting = false;
        }
    }

    @NotNull
    public DialogPanel createPanel() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        Ref.ObjectRef pagingDisplayMode = new Ref.ObjectRef();
        DialogPanel panel2 = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0(settings, this, pagingDisplayMode, arg_0));
        return panel2;
    }

    private final void appendFormatControls(Panel $this$appendFormatControls, String labelKey, KMutableProperty0<Boolean> enabledProperty, KMutableProperty0<String> patternProperty, KMutableProperty0<Function0<Unit>> previewRefresherProperty, Function2<? super Cell<? extends JBTextField>, ? super Cell<? extends JEditorPane>, Unit> refresh2) {
        block6: {
            Cell cell;
            Cell cell2;
            Cell cell3;
            Ref.ObjectRef useCustomFormatCheckBox = new Ref.ObjectRef();
            Ref.ObjectRef formatField = new Ref.ObjectRef();
            Ref.ObjectRef previewField = new Ref.ObjectRef();
            Panel.row$default((Panel)$this$appendFormatControls, null, arg_0 -> DatabaseSettingsDataViews.appendFormatControls$lambda$0(useCustomFormatCheckBox, labelKey, enabledProperty, this, formatField, arg_0), (int)1, null);
            RowsRange rowsRange = $this$appendFormatControls.indent(arg_0 -> DatabaseSettingsDataViews.appendFormatControls$lambda$1(formatField, previewField, patternProperty, enabledProperty, this, refresh2, arg_0));
            if (useCustomFormatCheckBox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomFormatCheckBox");
                cell3 = null;
            } else {
                cell3 = (Cell)useCustomFormatCheckBox.element;
            }
            rowsRange.enabledIf(ButtonKt.getSelected((Cell)cell3));
            if (formatField.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"formatField");
                cell2 = null;
            } else {
                cell2 = (Cell)formatField.element;
            }
            if (previewField.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"previewField");
                cell = null;
            } else {
                cell = (Cell)previewField.element;
            }
            refresh2.invoke((Object)cell2, (Object)cell);
            KMutableProperty0<Function0<Unit>> kMutableProperty0 = previewRefresherProperty;
            if (kMutableProperty0 == null) break block6;
            kMutableProperty0.set(() -> DatabaseSettingsDataViews.appendFormatControls$lambda$2(refresh2, formatField, previewField));
        }
    }

    static /* synthetic */ void appendFormatControls$default(DatabaseSettingsDataViews databaseSettingsDataViews, Panel panel2, String string, KMutableProperty0 kMutableProperty0, KMutableProperty0 kMutableProperty02, KMutableProperty0 kMutableProperty03, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            kMutableProperty03 = null;
        }
        databaseSettingsDataViews.appendFormatControls(panel2, string, (KMutableProperty0<Boolean>)kMutableProperty0, (KMutableProperty0<String>)kMutableProperty02, (KMutableProperty0<Function0<Unit>>)kMutableProperty03, (Function2<? super Cell<? extends JBTextField>, ? super Cell<? extends JEditorPane>, Unit>)function2);
    }

    private final void appendNumberFormatControls(Panel $this$appendNumberFormatControls, String labelKey, KMutableProperty0<Boolean> enabledProperty, KMutableProperty0<String> patternProperty, Cell<? extends JBTextField> decimalSeparatorField, Cell<? extends JBCheckBox> useGroupingCheckBox, Cell<? extends JBTextField> groupSeparatorField, KMutableProperty0<Function0<Unit>> previewRefresherProperty, Function0<? extends Number> sample) {
        this.appendFormatControls($this$appendNumberFormatControls, labelKey, enabledProperty, patternProperty, previewRefresherProperty, (Function2<? super Cell<? extends JBTextField>, ? super Cell<? extends JEditorPane>, Unit>)((Function2)(arg_0, arg_1) -> DatabaseSettingsDataViews.appendNumberFormatControls$lambda$0(this, decimalSeparatorField, useGroupingCheckBox, groupSeparatorField, sample, arg_0, arg_1)));
    }

    static /* synthetic */ void appendNumberFormatControls$default(DatabaseSettingsDataViews databaseSettingsDataViews, Panel panel2, String string, KMutableProperty0 kMutableProperty0, KMutableProperty0 kMutableProperty02, Cell cell, Cell cell2, Cell cell3, KMutableProperty0 kMutableProperty03, Function0 function0, int n, Object object) {
        if ((n & 0x40) != 0) {
            kMutableProperty03 = null;
        }
        databaseSettingsDataViews.appendNumberFormatControls(panel2, string, (KMutableProperty0<Boolean>)kMutableProperty0, (KMutableProperty0<String>)kMutableProperty02, (Cell<? extends JBTextField>)cell, (Cell<? extends JBCheckBox>)cell2, (Cell<? extends JBTextField>)cell3, (KMutableProperty0<Function0<Unit>>)kMutableProperty03, (Function0<? extends Number>)function0);
    }

    private final void appendDateTimeFormatControls(Panel $this$appendDateTimeFormatControls, String labelKey, KMutableProperty0<Boolean> enabledProperty, KMutableProperty0<String> patternProperty, KMutableProperty0<Function0<Unit>> previewRefresherProperty, Function0<? extends TemporalAccessor> sample) {
        this.appendFormatControls($this$appendDateTimeFormatControls, labelKey, enabledProperty, patternProperty, previewRefresherProperty, (Function2<? super Cell<? extends JBTextField>, ? super Cell<? extends JEditorPane>, Unit>)((Function2)(arg_0, arg_1) -> DatabaseSettingsDataViews.appendDateTimeFormatControls$lambda$0(this, sample, arg_0, arg_1)));
    }

    static /* synthetic */ void appendDateTimeFormatControls$default(DatabaseSettingsDataViews databaseSettingsDataViews, Panel panel2, String string, KMutableProperty0 kMutableProperty0, KMutableProperty0 kMutableProperty02, KMutableProperty0 kMutableProperty03, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            kMutableProperty03 = null;
        }
        databaseSettingsDataViews.appendDateTimeFormatControls(panel2, string, (KMutableProperty0<Boolean>)kMutableProperty0, (KMutableProperty0<String>)kMutableProperty02, (KMutableProperty0<Function0<Unit>>)kMutableProperty03, (Function0<? extends TemporalAccessor>)function0);
    }

    private final void appendTimeZoneFormatControls(Panel $this$appendTimeZoneFormatControls, DatabaseSettings settings) {
        String string = DatabaseBundle.message((String)"time.format.time.zone", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$appendTimeZoneFormatControls.row(string, arg_0 -> DatabaseSettingsDataViews.appendTimeZoneFormatControls$lambda$0(this, settings, arg_0));
    }

    private final Cell<JBTextField> positiveIntTextField(Row $this$positiveIntTextField) {
        return Row.intTextField$default((Row)$this$positiveIntTextField, (IntRange)new IntRange(1, Integer.MAX_VALUE), null, (int)2, null);
    }

    private final String validateDatePattern(String pattern) {
        String string;
        try {
            new SimpleDateFormat(pattern);
            string = null;
        }
        catch (IllegalArgumentException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            string = IdeBundle.message((String)"date.format.error.invalid.pattern", (Object[])objectArray);
        }
        return string;
    }

    private final String validateTimeZone(String zoneId) {
        String string;
        if (StringsKt.isBlank((CharSequence)zoneId)) {
            return null;
        }
        if (TimeFunKt.zoneIdOrNull((String)zoneId) == null) {
            Object[] objectArray = new Object[]{zoneId};
            string = DatabaseBundle.message((String)"time.format.error.invalid.time.zone", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    private final ZoneId getCurrentTimeZone() {
        ZoneId zoneId;
        if (this.timeZoneField == null) {
            return null;
        }
        TimeZoneTextField timeZoneTextField = this.timeZoneField;
        if (timeZoneTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timeZoneField");
            timeZoneTextField = null;
        }
        if (timeZoneTextField.isEnabled()) {
            TimeZoneTextField timeZoneTextField2 = this.timeZoneField;
            if (timeZoneTextField2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timeZoneField");
                timeZoneTextField2 = null;
            }
            String string = timeZoneTextField2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            zoneId = TimeFunKt.zoneIdOrNull((String)string);
        } else {
            zoneId = null;
        }
        return zoneId;
    }

    private final OffsetTime newZonedTime() {
        OffsetTime offsetTime;
        ZoneId zoneId;
        ZoneId zoneId2 = zoneId = this.getCurrentTimeZone();
        if (zoneId2 != null) {
            OffsetTime offsetTime2 = OffsetTime.now(zoneId2);
            offsetTime = offsetTime2;
            Intrinsics.checkNotNullExpressionValue((Object)offsetTime2, (String)"now(...)");
        } else {
            OffsetTime offsetTime3 = OffsetTime.now();
            offsetTime = offsetTime3;
            Intrinsics.checkNotNullExpressionValue((Object)offsetTime3, (String)"now(...)");
        }
        return offsetTime;
    }

    private final OffsetDateTime newZonedDateTime() {
        OffsetDateTime offsetDateTime;
        ZoneId zoneId;
        ZoneId zoneId2 = zoneId = this.getCurrentTimeZone();
        if (zoneId2 != null) {
            OffsetDateTime offsetDateTime2 = OffsetDateTime.now(zoneId2);
            offsetDateTime = offsetDateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"now(...)");
        } else {
            OffsetDateTime offsetDateTime3 = OffsetDateTime.now();
            offsetDateTime = offsetDateTime3;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime3, (String)"now(...)");
        }
        return offsetDateTime;
    }

    private final void updateNumberFormatCommentField(Cell<? extends JBTextField> formatField, Cell<? extends JEditorPane> previewField, Cell<? extends JBTextField> decimalSeparatorField, Cell<? extends JBCheckBox> useGroupingCheckBox, Cell<? extends JBTextField> groupSeparatorField, Function0<? extends Number> sample) {
        String string;
        boolean $i$f$updateNumberFormatCommentField = false;
        try {
            DecimalFormat format = new DecimalFormat();
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            format.setGroupingUsed(((JBCheckBox)useGroupingCheckBox.getComponent()).isSelected());
            String string2 = ((JBTextField)groupSeparatorField.getComponent()).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            Character c2 = StringsKt.firstOrNull((CharSequence)string2);
            symbols.setGroupingSeparator(c2 != null ? c2.charValue() : (char)' ');
            String string3 = ((JBTextField)decimalSeparatorField.getComponent()).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            Character c3 = StringsKt.firstOrNull((CharSequence)string3);
            symbols.setDecimalSeparator(c3 != null ? c3.charValue() : (char)'.');
            format.setDecimalFormatSymbols(symbols);
            format.applyLocalizedPattern(((JBTextField)formatField.getComponent()).getText());
            string = format.format(sample.invoke());
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            string = IdeBundle.message((String)"date.format.error.invalid.pattern", (Object[])objectArray);
        }
        String text = string;
        String string4 = StringUtil.escapeXmlEntities((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"escapeXmlEntities(...)");
        TextFieldKt.text(previewField, (String)string4);
    }

    private final void updateDateTimeFormatCommentField(Cell<? extends JBTextField> formatField, Cell<? extends JEditorPane> previewField, Function0<? extends TemporalAccessor> sample) {
        String string;
        boolean $i$f$updateDateTimeFormatCommentField = false;
        try {
            string = new DateTimeFormatterBuilder().appendPattern(((JBTextField)formatField.getComponent()).getText()).toFormatter().format((TemporalAccessor)sample.invoke());
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            string = IdeBundle.message((String)"date.format.error.invalid.pattern", (Object[])objectArray);
        }
        String text = string;
        String string2 = StringUtil.escapeXmlEntities((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(...)");
        TextFieldKt.text(previewField, (String)string2);
    }

    private final void refreshZonedPreviews() {
        this.refreshZonedTimePreview.invoke();
        this.refreshZonedDateTimePreview.invoke();
    }

    private static final Unit refreshZonedTimePreview$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit refreshZonedDateTimePreview$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$0(DatabaseSettings $settings, DatabaseSettingsDataViews this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.limit.page.size.to", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        Cell limitPageSizeTo2 = ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isLimitPageSize();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setLimitPageSize(p0);
            }
        })).gap(RightGap.SMALL);
        TextFieldKt.bindIntText(this$0.positiveIntTextField($this$row), (Function0)((Function0)new Function0<Integer>((Object)$settings){

            public final Integer invoke() {
                return ((DatabaseSettings)this.receiver).getPageSize();
            }
        }), (Function1)((Function1)new Function1<Integer, Unit>((Object)$settings){

            public final void invoke(int p0) {
                ((DatabaseSettings)this.receiver).setPageSize(p0);
            }
        })).enabledIf(ButtonKt.getSelected((Cell)limitPageSizeTo2));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$1(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JBTextField> cell = this$0.positiveIntTextField($this$row);
        Intrinsics.checkNotNull((Object)$settings);
        TextFieldKt.bindIntText(cell, (Function0)((Function0)new Function0<Integer>((Object)$settings){

            public final Integer invoke() {
                return ((DatabaseSettings)this.receiver).getPrefetchSize();
            }
        }), (Function1)((Function1)new Function1<Integer, Unit>((Object)$settings){

            public final void invoke(int p0) {
                ((DatabaseSettings)this.receiver).setPrefetchSize(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$2(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JBTextField> cell = this$0.positiveIntTextField($this$row);
        Intrinsics.checkNotNull((Object)$settings);
        TextFieldKt.bindIntText(cell, (Function0)((Function0)new Function0<Integer>((Object)$settings){

            public final Integer invoke() {
                return ((DatabaseSettings)this.receiver).getFiltersHistorySize();
            }
        }), (Function1)((Function1)new Function1<Integer, Unit>((Object)$settings){

            public final void invoke(int p0) {
                ((DatabaseSettings)this.receiver).setFiltersHistorySize(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$3(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JBTextField> cell = this$0.positiveIntTextField($this$row);
        Intrinsics.checkNotNull((Object)$settings);
        TextFieldKt.bindIntText(cell, (Function0)((Function0)new Function0<Integer>((Object)$settings){

            public final Integer invoke() {
                return ((DatabaseSettings)this.receiver).getBytesLimitPerValue();
            }
        }), (Function1)((Function1)new Function1<Integer, Unit>((Object)$settings){

            public final void invoke(int p0) {
                ((DatabaseSettings)this.receiver).setBytesLimitPerValue(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$4(DatabaseSettings $settings, DatabaseSettingsDataViews this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.show.first", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        Cell showFirst2 = ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isLoadSlowDocumentation();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setLoadSlowDocumentation(p0);
            }
        })).gap(RightGap.SMALL);
        TextFieldKt.bindIntText(this$0.positiveIntTextField($this$row), (Function0)((Function0)new Function0<Integer>((Object)$settings){

            public final Integer invoke() {
                return ((DatabaseSettings)this.receiver).getPreviewRows();
            }
        }), (Function1)((Function1)new Function1<Integer, Unit>((Object)$settings){

            public final void invoke(int p0) {
                ((DatabaseSettings)this.receiver).setPreviewRows(p0);
            }
        })).gap(RightGap.SMALL).enabledIf(ButtonKt.getSelected((Cell)showFirst2));
        String string2 = DatabaseBundle.message((String)"settings.data.rows.in.documentation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.label(string2);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$1$0(LcrRow $this$listCellRenderer) {
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        DataGridSettings.PagingDisplayMode pagingDisplayMode = (DataGridSettings.PagingDisplayMode)$this$listCellRenderer.getValue();
        String string = switch (pagingDisplayMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[pagingDisplayMode.ordinal()]) {
            case 1 -> DatabaseBundle.message((String)"settings.grid.floating.paging.position.grid.bottom.floating", (Object[])new Object[0]);
            case 2 -> DatabaseBundle.message((String)"settings.grid.floating.paging.position.grid.left.floating", (Object[])new Object[0]);
            case 3 -> DatabaseBundle.message((String)"settings.grid.floating.paging.position.grid.right.floating", (Object[])new Object[0]);
            case 4 -> DatabaseBundle.message((String)"settings.grid.floating.paging.position.data.editor.toolbar", (Object[])new Object[0]);
            case -1 -> "";
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)string);
        LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)string, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$1$1(DatabaseSettings $settings, DataGridSettings.PagingDisplayMode it) {
        if (it != null) {
            $settings.setPagingDisplayMode(it);
        }
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$1$2$0(DatabaseSettings $settings) {
        return !$settings.isDisableGridFloatingToolbar();
    }

    private static final Unit createPanel$lambda$0$1$2$1(DatabaseSettings $settings, boolean f) {
        $settings.setDisableGridFloatingToolbar(!f);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$0(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.enable.paging.in.in.editor.results.by.default", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isEnablePagingInInEditorResultsByDefault();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setEnablePagingInInEditorResultsByDefault(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$1(Ref.ObjectRef $pagingDisplayMode, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new DataGridSettings.PagingDisplayMode[]{DataGridSettings.PagingDisplayMode.GRID_CENTER_FLOATING, DataGridSettings.PagingDisplayMode.GRID_LEFT_FLOATING, DataGridSettings.PagingDisplayMode.GRID_RIGHT_FLOATING, DataGridSettings.PagingDisplayMode.DATA_EDITOR_TOOLBAR};
        Cell cell = $this$row.comboBox((Collection)CollectionsKt.listOf((Object[])objectArray), BuilderKt.listCellRenderer(DatabaseSettingsDataViews::createPanel$lambda$0$1$1$0));
        Intrinsics.checkNotNull((Object)$settings);
        $pagingDisplayMode.element = ComboBoxKt.bindItem((Cell)cell, (Function0)((Function0)new Function0<DataGridSettings.PagingDisplayMode>((Object)$settings){

            public final DataGridSettings.PagingDisplayMode invoke() {
                return ((DatabaseSettings)this.receiver).getPagingDisplayMode();
            }
        }), arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$1$1$1($settings, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$2(Ref.ObjectRef $showQuickActionPopupToolbar, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.disable.grid.floating.toolbar", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $showQuickActionPopupToolbar.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> DatabaseSettingsDataViews.createPanel$lambda$0$1$2$0($settings), arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$1$2$1($settings, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$3(DatabaseSettings $settings, Ref.ObjectRef $showQuickActionPopupToolbar, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("");
        String string = DatabaseBundle.message((String)"settings.enable.grid.floating.toolbar.customization", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        Cell cell3 = ButtonKt.bindSelected((Cell)cell2, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isFloatingToolbarCustomizable();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setFloatingToolbarCustomizable(p0);
            }
        }));
        if ($showQuickActionPopupToolbar.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"showQuickActionPopupToolbar");
            cell = null;
        } else {
            cell = (Cell)$showQuickActionPopupToolbar.element;
        }
        cell3.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$1$0(ActionEvent e) {
        block0: {
            Settings s;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DataManager dataManager = DataManager.getInstance();
            Object object = e.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ui.components.ActionLink");
            DataContext dataContext = dataManager.getDataContext((Component)((ActionLink)object));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Settings settings = s = (Settings)Settings.KEY.getData(dataContext);
            if (settings == null) break block0;
            settings.select(s.find("database.data.views.appearance"));
        }
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$0$2$2$0(DataGridSettings.AutoTransposeMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return switch (WhenMappings.$EnumSwitchMapping$1[mode.ordinal()]) {
            case 1 -> DatabaseBundle.message((String)"settings.automatically.transpose.tables.never", (Object[])new Object[0]);
            case 2 -> DatabaseBundle.message((String)"settings.automatically.transpose.tables.if.one.row", (Object[])new Object[0]);
            case 3 -> DatabaseBundle.message((String)"settings.automatically.transpose.tables.always", (Object[])new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit createPanel$lambda$0$2$2$1(DatabaseSettings $settings, DataGridSettings.AutoTransposeMode it) {
        if (it != null) {
            $settings.setAutoTransposeMode(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$3$0(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.detect.binary.values", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        String string2 = DataGridBundle.message((String)"action.Console.TableResult.DisplayType.Text.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell cell = $this$row.checkBox(string2);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isDetectTextInBinaryColumns();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setDetectTextInBinaryColumns(p0);
            }
        }));
        String string3 = DataGridBundle.message((String)"action.Console.TableResult.DisplayType.UUID.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string3), (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isDetectUUIDInBinaryColumns();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setDetectUUIDInBinaryColumns(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$2$7$1$0(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s.length() != 1;
    }

    private static final boolean createPanel$lambda$0$2$7$3$0(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s.length() > 1;
    }

    private static final Unit createPanel$lambda$0$2$7$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"number.format.number.patterns", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.browserLink(string, "https://docs.oracle.com/javase/7/docs/api/java/text/DecimalFormat.html");
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$7$1(Ref.ObjectRef $decimalSeparatorField, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.number.decimal.separator", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        Cell cell = $this$row.textField();
        Intrinsics.checkNotNull((Object)$settings);
        Cell cell2 = TextFieldKt.bindText((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).decimalSeparator;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).decimalSeparator = (String)value;
            }
        }));
        DialogValidation.WithParameter[] withParameterArray = new DialogValidation.WithParameter[1];
        String string2 = DatabaseBundle.message((String)"settings.number.decimal.separator.validation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        withParameterArray[0] = ValidationUtilKt.validationErrorIf((String)string2, DatabaseSettingsDataViews::createPanel$lambda$0$2$7$1$0);
        $decimalSeparatorField.element = TextFieldKt.textValidation((Cell)cell2, (DialogValidation.WithParameter[])withParameterArray);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$7$2(Ref.ObjectRef $useGroupingCheckBox, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.number.grouping.separator", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        $useGroupingCheckBox.element = ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).numberGroupingEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).numberGroupingEnabled = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$7$3(Ref.ObjectRef $groupSeparatorField, DatabaseSettings $settings, Ref.ObjectRef $useGroupingCheckBox, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell2 = $this$row.textField();
        Intrinsics.checkNotNull((Object)$settings);
        Cell cell3 = TextFieldKt.bindText((Cell)cell2, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).numberGroupingSeparator;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).numberGroupingSeparator = (String)value;
            }
        }));
        DialogValidation.WithParameter[] withParameterArray = new DialogValidation.WithParameter[1];
        String string = DatabaseBundle.message((String)"settings.number.grouping.separator.validation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        withParameterArray[0] = ValidationUtilKt.validationErrorIf((String)string, DatabaseSettingsDataViews::createPanel$lambda$0$2$7$3$0);
        Cell cell4 = TextFieldKt.textValidation((Cell)cell3, (DialogValidation.WithParameter[])withParameterArray);
        if ($useGroupingCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useGroupingCheckBox");
            cell = null;
        } else {
            cell = (Cell)$useGroupingCheckBox.element;
        }
        $groupSeparatorField.element = cell4.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$7$4(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.number.infinity", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        Cell cell = $this$row.textField();
        Intrinsics.checkNotNull((Object)$settings);
        TextFieldKt.bindText((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).infinity;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).infinity = (String)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$7$5(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.number.nan", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        Cell cell = $this$row.textField();
        Intrinsics.checkNotNull((Object)$settings);
        TextFieldKt.bindText((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).nan;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).nan = (String)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Number createPanel$lambda$0$2$7$6() {
        return 1.23456789123456E8;
    }

    private static final Unit createPanel$lambda$0$2$8$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"date.format.date.patterns", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.browserLink(string, "https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html");
        return Unit.INSTANCE;
    }

    private static final TemporalAccessor createPanel$lambda$0$2$8$1() {
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now(...)");
        return localDateTime;
    }

    private static final TemporalAccessor createPanel$lambda$0$2$8$2(DatabaseSettingsDataViews this$0) {
        return this$0.newZonedDateTime();
    }

    private static final TemporalAccessor createPanel$lambda$0$2$8$3() {
        LocalTime localTime = LocalTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"now(...)");
        return localTime;
    }

    private static final TemporalAccessor createPanel$lambda$0$2$8$4(DatabaseSettingsDataViews this$0) {
        return this$0.newZonedTime();
    }

    private static final TemporalAccessor createPanel$lambda$0$2$8$5() {
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
        return localDate;
    }

    private static final boolean createPanel$lambda$0$2$0(DatabaseSettingsDataViews this$0) {
        return this$0.isResetting;
    }

    private static final Unit createPanel$lambda$0$2$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.settings.were.moved", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        String string2 = DatabaseBundle.message((String)"settings.data.views.appearance", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.link(string2, DatabaseSettingsDataViews::createPanel$lambda$0$2$1$0);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$2(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.automatically.transpose.tables", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        Object[] objectArray = new DataGridSettings.AutoTransposeMode[]{DataGridSettings.AutoTransposeMode.NEVER, DataGridSettings.AutoTransposeMode.ONE_ROW, DataGridSettings.AutoTransposeMode.ALWAYS};
        Cell cell = $this$row.comboBox((Collection)CollectionsKt.listOf((Object[])objectArray), BuilderKt.textListCellRenderer((String)"", DatabaseSettingsDataViews::createPanel$lambda$0$2$2$0));
        Intrinsics.checkNotNull((Object)$settings);
        ComboBoxKt.bindItem((Cell)cell, (Function0)((Function0)new Function0<DataGridSettings.AutoTransposeMode>((Object)$settings){

            public final DataGridSettings.AutoTransposeMode invoke() {
                return ((DatabaseSettings)this.receiver).getAutoTransposeMode();
            }
        }), arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$2$1($settings, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$3(DatabaseSettings $settings, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$3$0($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$4(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.enable.local.filter.by.default", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isEnableLocalFilterByDefault();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setEnableLocalFilterByDefault(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$5(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.enable.immediate.completion.in.grid.text.cells", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isEnableImmediateCompletionInGridCells();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setEnableImmediateCompletionInGridCells(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$6(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.data.show.geo.as.binary", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isShowGeoAsBinary();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setShowGeoAsBinary(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$7(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, Panel $this$group) {
        Cell cell;
        Cell cell2;
        Cell cell3;
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Ref.ObjectRef decimalSeparatorField = new Ref.ObjectRef();
        Ref.ObjectRef useGroupingCheckBox = new Ref.ObjectRef();
        Ref.ObjectRef groupSeparatorField = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$group, null, DatabaseSettingsDataViews::createPanel$lambda$0$2$7$0, (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$7$1(decimalSeparatorField, $settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$7$2(useGroupingCheckBox, $settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$7$3(groupSeparatorField, $settings, useGroupingCheckBox, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$7$4($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$7$5($settings, arg_0), (int)1, null);
        Intrinsics.checkNotNull((Object)$settings);
        KMutableProperty0 kMutableProperty0 = (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).numberPatternEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).numberPatternEnabled = (Boolean)value;
            }
        };
        KMutableProperty0 kMutableProperty02 = (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).numberPattern;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).numberPattern = (String)value;
            }
        };
        if (decimalSeparatorField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"decimalSeparatorField");
            cell3 = null;
        } else {
            cell3 = (Cell)decimalSeparatorField.element;
        }
        if (useGroupingCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useGroupingCheckBox");
            cell2 = null;
        } else {
            cell2 = (Cell)useGroupingCheckBox.element;
        }
        if (groupSeparatorField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"groupSeparatorField");
            cell = null;
        } else {
            cell = (Cell)groupSeparatorField.element;
        }
        DatabaseSettingsDataViews.appendNumberFormatControls$default(this$0, $this$group, "number.format.use.custom.pattern", kMutableProperty0, kMutableProperty02, cell3, cell2, cell, null, DatabaseSettingsDataViews::createPanel$lambda$0$2$7$6, 64, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$8(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, DatabaseSettingsDataViews::createPanel$lambda$0$2$8$0, (int)1, null);
        Intrinsics.checkNotNull((Object)$settings);
        DatabaseSettingsDataViews.appendDateTimeFormatControls$default(this$0, $this$group, "time.format.use.custom.datetime", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).dateTimePatternEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).dateTimePatternEnabled = (Boolean)value;
            }
        }, (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).dateTimePattern;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).dateTimePattern = (String)value;
            }
        }, null, DatabaseSettingsDataViews::createPanel$lambda$0$2$8$1, 8, null);
        this$0.appendDateTimeFormatControls($this$group, "time.format.use.custom.zoned.datetime", (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).zonedDateTimePatternEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).zonedDateTimePatternEnabled = (Boolean)value;
            }
        }), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).zonedDateTimePattern;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).zonedDateTimePattern = (String)value;
            }
        }), (KMutableProperty0<Function0<Unit>>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return DatabaseSettingsDataViews.access$getRefreshZonedDateTimePreview$p((DatabaseSettingsDataViews)((Object)this.receiver));
            }

            public void set(Object value) {
                DatabaseSettingsDataViews.access$setRefreshZonedDateTimePreview$p((DatabaseSettingsDataViews)((Object)this.receiver), (Function0)value);
            }
        }), (Function0<? extends TemporalAccessor>)((Function0)() -> DatabaseSettingsDataViews.createPanel$lambda$0$2$8$2(this$0)));
        DatabaseSettingsDataViews.appendDateTimeFormatControls$default(this$0, $this$group, "time.format.use.custom.time", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).timePatternEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).timePatternEnabled = (Boolean)value;
            }
        }, (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).timePattern;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).timePattern = (String)value;
            }
        }, null, DatabaseSettingsDataViews::createPanel$lambda$0$2$8$3, 8, null);
        this$0.appendDateTimeFormatControls($this$group, "time.format.use.custom.zoned.time", (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).zonedTimePatternEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).zonedTimePatternEnabled = (Boolean)value;
            }
        }), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).zonedTimePattern;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).zonedTimePattern = (String)value;
            }
        }), (KMutableProperty0<Function0<Unit>>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return DatabaseSettingsDataViews.access$getRefreshZonedTimePreview$p((DatabaseSettingsDataViews)((Object)this.receiver));
            }

            public void set(Object value) {
                DatabaseSettingsDataViews.access$setRefreshZonedTimePreview$p((DatabaseSettingsDataViews)((Object)this.receiver), (Function0)value);
            }
        }), (Function0<? extends TemporalAccessor>)((Function0)() -> DatabaseSettingsDataViews.createPanel$lambda$0$2$8$4(this$0)));
        DatabaseSettingsDataViews.appendDateTimeFormatControls$default(this$0, $this$group, "time.format.use.custom.date", (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).datePatternEnabled;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).datePatternEnabled = (Boolean)value;
            }
        }, (KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((DatabaseSettings)this.receiver).datePattern;
            }

            public void set(Object value) {
                ((DatabaseSettings)this.receiver).datePattern = (String)value;
            }
        }, null, DatabaseSettingsDataViews::createPanel$lambda$0$2$8$5, 8, null);
        this$0.refreshZonedPreviews();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$3$0(Ref.ObjectRef $sortTables, Row $this$row) {
        Cell cell;
        Cell cell2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.automatically.sort.tables.asc", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell3 = $this$row.radioButton(string, (Object)true);
        if ($sortTables.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortTables");
            cell2 = null;
        } else {
            cell2 = (Cell)$sortTables.element;
        }
        cell3.enabledIf(ButtonKt.getSelected((Cell)cell2));
        String string2 = DatabaseBundle.message((String)"settings.automatically.sort.tables.desc", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell cell4 = $this$row.radioButton(string2, (Object)false);
        if ($sortTables.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortTables");
            cell = null;
        } else {
            cell = (Cell)$sortTables.element;
        }
        cell4.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$4$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = KeymapUtil.getMouseShortcutText((MouseShortcut)ALT_CLICK_SHORTCUT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMouseShortcutText(...)");
        $this$row.radioButton(string, (Object)true);
        String string2 = KeymapUtil.getMouseShortcutText((MouseShortcut)CLICK_SHORTCUT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMouseShortcutText(...)");
        $this$row.radioButton(string2, (Object)false);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0(Ref.ObjectRef $sortViaOrderBy, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.sort.via.order.by", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        $sortViaOrderBy.element = ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isSortViaOrderBy();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setSortViaOrderBy(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$1(Ref.ObjectRef $sortTables, DatabaseSettings $settings, Ref.ObjectRef $sortViaOrderBy, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.automatically.sort.tables", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        Cell cell3 = ButtonKt.bindSelected((Cell)cell2, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isSortTables();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setSortTables(p0);
            }
        }));
        if ($sortViaOrderBy.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortViaOrderBy");
            cell = null;
        } else {
            cell = (Cell)$sortViaOrderBy.element;
        }
        $sortTables.element = cell3.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$2(Ref.ObjectRef $sortTables, boolean it) {
        if (!it) {
            Cell cell;
            if ($sortTables.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sortTables");
                cell = null;
            } else {
                cell = (Cell)$sortTables.element;
            }
            ButtonKt.selected((Cell)cell, (boolean)false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$3(Ref.ObjectRef $sortTables, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$3$3$0($sortTables, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$4(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, DatabaseSettingsDataViews::createPanel$lambda$0$3$4$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$0(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.submit.changes.immediately", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isSubmitImmediately();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setSubmitImmediately(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$1(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.enable.edit.sql.joins", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isEnableEditSqlJoins();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setEnableEditSqlJoins(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4$2(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.enable.show.preview.sql.joins", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isEnableShowPreviewForSqlJoins();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setEnableShowPreviewForSqlJoins(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5$0$0(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.data.urls.allow.click.on.https.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isOpeningOfHttpsLinksAllowed();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setIsOpeningOfHttpsLinksAllowed(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5$0$1(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.data.urls.allow.click.on.http.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isOpeningOfHttpLinksAllowed();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setIsOpeningOfHttpLinksAllowed(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5$0$2(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.data.urls.allow.click.on.local.file.url", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isOpeningOfLocalFileUrlsAllowed();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setIsOpeningOfLocalFileUrlsAllowed(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5$0(DatabaseSettings $settings, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$5$0$0($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$5$0$1($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$5$0$2($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5$1(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.data.urls.open.as.http", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isWebUrlWithoutProtocolAssumedHttp();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setIsWebUrlWithoutProtocolAssumedHttp(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(DatabaseSettings $settings, DatabaseSettingsDataViews this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$0$0($settings, this$0, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        String string = DatabaseBundle.message((String)"settings.result.set.pre.fetch.size", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$0$1(this$0, $settings, arg_0)).layout(RowLayout.PARENT_GRID);
        String string2 = DatabaseBundle.message((String)"settings.filter.history.size", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$group.row(string2, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$0$2(this$0, $settings, arg_0)).layout(RowLayout.PARENT_GRID);
        String string3 = DataGridBundle.message((String)"settings.maximum.number.of.bytes.per.value", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$group.row(string3, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$0$3(this$0, $settings, arg_0)).layout(RowLayout.PARENT_GRID);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$0$4($settings, this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(DatabaseSettings $settings, Ref.ObjectRef $pagingDisplayMode, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$1$0($settings, arg_0), (int)1, null);
        String string = DatabaseBundle.message((String)"settings.grid.floating.paging.position", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$group.row(string, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$1$1($pagingDisplayMode, $settings, arg_0));
        Ref.ObjectRef showQuickActionPopupToolbar = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$1$2(showQuickActionPopupToolbar, $settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$1$3($settings, showQuickActionPopupToolbar, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        if (PlatformUtils.isDataGrip()) {
            DataGridAppearanceSettings dataGridAppearanceSettings = DataGridAppearanceSettings.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)dataGridAppearanceSettings, (String)"getSettings(...)");
            this$0.appearanceComponents = DataGridAppearanceConfigurableKt.produceAppearanceSettings$default((Panel)$this$group, (DataGridAppearanceSettings)dataGridAppearanceSettings, () -> DatabaseSettingsDataViews.createPanel$lambda$0$2$0(this$0), null, (int)4, null);
        } else {
            Panel.row$default((Panel)$this$group, null, DatabaseSettingsDataViews::createPanel$lambda$0$2$1, (int)1, null);
        }
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$2($settings, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$3($settings, arg_0), (int)3, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$4($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$5($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$6($settings, arg_0), (int)1, null);
        Intrinsics.checkNotNull((Object)$settings);
        this$0.appendTimeZoneFormatControls($this$group, $settings);
        Panel.group$default((Panel)$this$group, (String)DatabaseBundle.message((String)"settings.number.formats", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$7(this$0, $settings, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$group, (String)DatabaseBundle.message((String)"settings.date.time.formats", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2$8(this$0, $settings, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(DatabaseSettings $settings, Panel $this$group) {
        Function0 getter$iv;
        ButtonsGroup $this$bind$iv;
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Ref.ObjectRef sortViaOrderBy = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$3$0(sortViaOrderBy, $settings, arg_0), (int)1, null);
        Ref.ObjectRef sortTables = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$3$1(sortTables, $settings, sortViaOrderBy, arg_0), (int)1, null);
        if (sortViaOrderBy.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sortViaOrderBy");
            cell = null;
        } else {
            cell = (Cell)sortViaOrderBy.element;
        }
        ButtonKt.getSelected((Cell)cell).addListener(arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$3$2(sortTables, arg_0));
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)true, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$3$3(sortTables, arg_0), (int)1, null);
        Intrinsics.checkNotNull((Object)$settings);
        Function0 function0 = (Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isTableOrderingAsc();
            }
        };
        Function1 setter$iv = (Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setTableOrderingAsc(p0);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Boolean.class);
        $this$bind$iv = Panel.buttonsGroup$default((Panel)$this$group, (String)DatabaseBundle.message((String)"settings.add.column.to.order.by", (Object[])new Object[0]), (boolean)false, DatabaseSettingsDataViews::createPanel$lambda$0$3$4, (int)2, null);
        getter$iv = (Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((DatabaseSettings)this.receiver).isAddToSortViaAltClick();
            }
        };
        setter$iv = (Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((DatabaseSettings)this.receiver).setAddToSortViaAltClick(p0);
            }
        };
        $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Boolean.class);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4(DatabaseSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$4$0($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$4$1($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$4$2($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5(DatabaseSettings $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.buttonsGroup$default((Panel)$this$group, (String)DatabaseBundle.message((String)"settings.data.urls.allow.click.section.title", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$5$0($settings, arg_0), (int)2, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$5$1($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0(DatabaseSettings $settings, DatabaseSettingsDataViews this$0, Ref.ObjectRef $pagingDisplayMode, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.limitations", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$0($settings, this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.controls.customization", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$1($settings, $pagingDisplayMode, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.data.presentation", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$2(this$0, $settings, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.data.sorting", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$3($settings, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.data.modification", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$4($settings, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)DatabaseBundle.message((String)"settings.data.urls.click", (Object[])new Object[0]), (boolean)false, arg_0 -> DatabaseSettingsDataViews.createPanel$lambda$0$5($settings, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final boolean appendFormatControls$lambda$0$0(KMutableProperty0 $enabledProperty) {
        return (Boolean)$enabledProperty.get();
    }

    private static final Unit appendFormatControls$lambda$0$1(DatabaseSettingsDataViews this$0, Ref.ObjectRef $formatField, KMutableProperty0 $enabledProperty, boolean value) {
        Cell cell;
        if ($formatField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"formatField");
            cell = null;
        } else {
            cell = (Cell)$formatField.element;
        }
        String string = ((JBTextField)cell.getComponent()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this$0.validateDatePattern(string);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            throw new ConfigurationException(it);
        }
        $enabledProperty.set((Object)value);
        return Unit.INSTANCE;
    }

    private static final String appendFormatControls$lambda$1$0$0(KMutableProperty0 $patternProperty) {
        return (String)$patternProperty.get();
    }

    private static final Unit appendFormatControls$lambda$1$0$1(KMutableProperty0 $enabledProperty, DatabaseSettingsDataViews this$0, KMutableProperty0 $patternProperty, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((Boolean)$enabledProperty.get()).booleanValue()) {
            String string = this$0.validateDatePattern(value);
            if (string != null) {
                String it = string;
                boolean bl = false;
                throw new ConfigurationException(it);
            }
            $patternProperty.set((Object)value);
        }
        return Unit.INSTANCE;
    }

    private static final ValidationInfo appendFormatControls$lambda$1$0$2(DatabaseSettingsDataViews this$0, ValidationInfoBuilder $this$validationOnInput, JBTextField field) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string = field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this$0.validateDatePattern(string);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            validationInfo = $this$validationOnInput.error(it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit appendFormatControls$lambda$1$0$3(Function2 $refresh, Ref.ObjectRef $formatField, Ref.ObjectRef $previewField, JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter((Function2<? super Cell<? extends JBTextField>, ? super Cell<? extends JEditorPane>, Unit>)$refresh, (Ref.ObjectRef<Cell<JBTextField>>)$formatField, (Ref.ObjectRef<Cell<JEditorPane>>)$previewField){
            final /* synthetic */ Function2<Cell<? extends JBTextField>, Cell<? extends JEditorPane>, Unit> $refresh;
            final /* synthetic */ Ref.ObjectRef<Cell<JBTextField>> $formatField;
            final /* synthetic */ Ref.ObjectRef<Cell<JEditorPane>> $previewField;
            {
                this.$refresh = $refresh;
                this.$formatField = $formatField;
                this.$previewField = $previewField;
            }

            protected void textChanged(DocumentEvent e) {
                Cell cell;
                Cell cell2;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.$formatField.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"formatField");
                    cell2 = null;
                } else {
                    cell2 = (Cell)this.$formatField.element;
                }
                if (this.$previewField.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"previewField");
                    cell = null;
                } else {
                    cell = (Cell)this.$previewField.element;
                }
                this.$refresh.invoke((Object)cell2, (Object)cell);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit appendFormatControls$lambda$1$0(Ref.ObjectRef $formatField, Ref.ObjectRef $previewField, KMutableProperty0 $patternProperty, KMutableProperty0 $enabledProperty, DatabaseSettingsDataViews this$0, Function2 $refresh, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $formatField.element = TextFieldKt.columns((Cell)TextFieldKt.bindText((Cell)$this$row.textField(), () -> DatabaseSettingsDataViews.appendFormatControls$lambda$1$0$0($patternProperty), arg_0 -> DatabaseSettingsDataViews.appendFormatControls$lambda$1$0$1($enabledProperty, this$0, $patternProperty, arg_0)), (int)16).validationOnInput((arg_0, arg_1) -> DatabaseSettingsDataViews.appendFormatControls$lambda$1$0$2(this$0, arg_0, arg_1)).applyToComponent(arg_0 -> DatabaseSettingsDataViews.appendFormatControls$lambda$1$0$3($refresh, $formatField, $previewField, arg_0));
        $previewField.element = Row.comment$default((Row)$this$row, (String)"", (int)Integer.MAX_VALUE, null, (int)4, null);
        return Unit.INSTANCE;
    }

    private static final Unit appendFormatControls$lambda$0(Ref.ObjectRef $useCustomFormatCheckBox, String $labelKey, KMutableProperty0 $enabledProperty, DatabaseSettingsDataViews this$0, Ref.ObjectRef $formatField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)$labelKey, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $useCustomFormatCheckBox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), () -> DatabaseSettingsDataViews.appendFormatControls$lambda$0$0($enabledProperty), arg_0 -> DatabaseSettingsDataViews.appendFormatControls$lambda$0$1(this$0, $formatField, $enabledProperty, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit appendFormatControls$lambda$1(Ref.ObjectRef $formatField, Ref.ObjectRef $previewField, KMutableProperty0 $patternProperty, KMutableProperty0 $enabledProperty, DatabaseSettingsDataViews this$0, Function2 $refresh, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> DatabaseSettingsDataViews.appendFormatControls$lambda$1$0($formatField, $previewField, $patternProperty, $enabledProperty, this$0, $refresh, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit appendFormatControls$lambda$2(Function2 $refresh, Ref.ObjectRef $formatField, Ref.ObjectRef $previewField) {
        Cell cell;
        Cell cell2;
        if ($formatField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"formatField");
            cell2 = null;
        } else {
            cell2 = (Cell)$formatField.element;
        }
        if ($previewField.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewField");
            cell = null;
        } else {
            cell = (Cell)$previewField.element;
        }
        $refresh.invoke((Object)cell2, (Object)cell);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit appendNumberFormatControls$lambda$0(DatabaseSettingsDataViews this$0, Cell $decimalSeparatorField, Cell $useGroupingCheckBox, Cell $groupSeparatorField, Function0 $sample, Cell formatField, Cell previewField) {
        void previewField$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)formatField, (String)"formatField");
        Intrinsics.checkNotNullParameter((Object)previewField, (String)"previewField");
        DatabaseSettingsDataViews databaseSettingsDataViews = this$0;
        Cell cell = formatField;
        Cell cell2 = previewField;
        Cell cell3 = $decimalSeparatorField;
        Cell cell4 = $useGroupingCheckBox;
        Cell groupSeparatorField$iv = $groupSeparatorField;
        boolean $i$f$updateNumberFormatCommentField = false;
        try {
            void formatField$iv;
            void decimalSeparatorField$iv;
            void useGroupingCheckBox$iv;
            DecimalFormat format$iv = new DecimalFormat();
            DecimalFormatSymbols symbols$iv = format$iv.getDecimalFormatSymbols();
            format$iv.setGroupingUsed(((JBCheckBox)useGroupingCheckBox$iv.getComponent()).isSelected());
            String string2 = ((JBTextField)groupSeparatorField$iv.getComponent()).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            Character c2 = StringsKt.firstOrNull((CharSequence)string2);
            symbols$iv.setGroupingSeparator(c2 != null ? c2.charValue() : (char)' ');
            String string3 = ((JBTextField)decimalSeparatorField$iv.getComponent()).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            Character c3 = StringsKt.firstOrNull((CharSequence)string3);
            symbols$iv.setDecimalSeparator(c3 != null ? c3.charValue() : (char)'.');
            format$iv.setDecimalFormatSymbols(symbols$iv);
            format$iv.applyLocalizedPattern(((JBTextField)formatField$iv.getComponent()).getText());
            string = format$iv.format($sample.invoke());
        }
        catch (Exception e$iv) {
            Object[] objectArray = new Object[]{e$iv.getMessage()};
            string = IdeBundle.message((String)"date.format.error.invalid.pattern", (Object[])objectArray);
        }
        String text$iv = string;
        String string4 = StringUtil.escapeXmlEntities((String)text$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"escapeXmlEntities(...)");
        TextFieldKt.text((Cell)previewField$iv, (String)string4);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit appendDateTimeFormatControls$lambda$0(DatabaseSettingsDataViews this$0, Function0 $sample, Cell formatField, Cell previewField) {
        String string;
        Intrinsics.checkNotNullParameter((Object)formatField, (String)"formatField");
        Intrinsics.checkNotNullParameter((Object)previewField, (String)"previewField");
        DatabaseSettingsDataViews databaseSettingsDataViews = this$0;
        Cell cell = formatField;
        Cell previewField$iv = previewField;
        boolean $i$f$updateDateTimeFormatCommentField = false;
        try {
            void formatField$iv;
            string = new DateTimeFormatterBuilder().appendPattern(((JBTextField)formatField$iv.getComponent()).getText()).toFormatter().format((TemporalAccessor)$sample.invoke());
        }
        catch (Exception e$iv) {
            Object[] objectArray = new Object[]{e$iv.getMessage()};
            string = IdeBundle.message((String)"date.format.error.invalid.pattern", (Object[])objectArray);
        }
        String text$iv = string;
        String string2 = StringUtil.escapeXmlEntities((String)text$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(...)");
        TextFieldKt.text((Cell)previewField$iv, (String)string2);
        return Unit.INSTANCE;
    }

    private static final String appendTimeZoneFormatControls$lambda$0$0(DatabaseSettings $settings) {
        return $settings.formattingTimeZone;
    }

    private static final Unit appendTimeZoneFormatControls$lambda$0$1(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, String value) {
        Intrinsics.checkNotNull((Object)value);
        String string = this$0.validateTimeZone(value);
        if (string != null) {
            String it = string;
            boolean bl = false;
            throw new ConfigurationException(it);
        }
        $settings.formattingTimeZone = value;
        return Unit.INSTANCE;
    }

    private static final ValidationInfo appendTimeZoneFormatControls$lambda$0$2(DatabaseSettingsDataViews this$0, ValidationInfoBuilder $this$validationOnInput, TimeZoneTextField field) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        String string = field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this$0.validateTimeZone(string);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            validationInfo = $this$validationOnInput.error(it);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit appendTimeZoneFormatControls$lambda$0$3(DatabaseSettingsDataViews this$0, TimeZoneTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyToComponent), (String)"$this$applyToComponent");
        TimeZoneTextField timeZoneTextField = this$0.timeZoneField;
        if (timeZoneTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timeZoneField");
            timeZoneTextField = null;
        }
        timeZoneTextField.getDocument().addDocumentListener(new DocumentListener(this$0){
            final /* synthetic */ DatabaseSettingsDataViews this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DatabaseSettingsDataViews.access$refreshZonedPreviews(this.this$0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit appendTimeZoneFormatControls$lambda$0(DatabaseSettingsDataViews this$0, DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TimeZoneTextField timeZoneTextField = TimeZoneTextField.create(ProjectManager.getInstance().getDefaultProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)timeZoneTextField), (String)"create(...)");
        this$0.timeZoneField = timeZoneTextField;
        TimeZoneTextField timeZoneTextField2 = this$0.timeZoneField;
        if (timeZoneTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timeZoneField");
            timeZoneTextField2 = null;
        }
        $this$row.cell((JComponent)((Object)timeZoneTextField2)).bind((Function1)appendTimeZoneFormatControls.1.1.INSTANCE, (Function2)appendTimeZoneFormatControls.1.2.INSTANCE, MutablePropertyKt.MutableProperty(() -> DatabaseSettingsDataViews.appendTimeZoneFormatControls$lambda$0$0($settings), arg_0 -> DatabaseSettingsDataViews.appendTimeZoneFormatControls$lambda$0$1(this$0, $settings, arg_0))).validationOnInput((arg_0, arg_1) -> DatabaseSettingsDataViews.appendTimeZoneFormatControls$lambda$0$2(this$0, arg_0, arg_1)).applyToComponent(arg_0 -> DatabaseSettingsDataViews.appendTimeZoneFormatControls$lambda$0$3(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function0 access$getRefreshZonedDateTimePreview$p(DatabaseSettingsDataViews $this) {
        return $this.refreshZonedDateTimePreview;
    }

    public static final /* synthetic */ void access$setRefreshZonedDateTimePreview$p(DatabaseSettingsDataViews $this, Function0 function0) {
        $this.refreshZonedDateTimePreview = function0;
    }

    public static final /* synthetic */ Function0 access$getRefreshZonedTimePreview$p(DatabaseSettingsDataViews $this) {
        return $this.refreshZonedTimePreview;
    }

    public static final /* synthetic */ void access$setRefreshZonedTimePreview$p(DatabaseSettingsDataViews $this, Function0 function0) {
        $this.refreshZonedTimePreview = function0;
    }

    public static final /* synthetic */ void access$refreshZonedPreviews(DatabaseSettingsDataViews $this) {
        $this.refreshZonedPreviews();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/settings/DatabaseSettingsDataViews$Companion;", "", "<init>", "()V", "ALT_CLICK_SHORTCUT", "Lcom/intellij/openapi/actionSystem/MouseShortcut;", "CLICK_SHORTCUT", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DataGridSettings.PagingDisplayMode.values().length];
            try {
                nArray[DataGridSettings.PagingDisplayMode.GRID_CENTER_FLOATING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataGridSettings.PagingDisplayMode.GRID_LEFT_FLOATING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataGridSettings.PagingDisplayMode.GRID_RIGHT_FLOATING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataGridSettings.PagingDisplayMode.DATA_EDITOR_TOOLBAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DataGridSettings.AutoTransposeMode.values().length];
            try {
                nArray[DataGridSettings.AutoTransposeMode.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataGridSettings.AutoTransposeMode.ONE_ROW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataGridSettings.AutoTransposeMode.ALWAYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

