/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.util.DbUltimateActionsListener;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationsEventLogGroup;
import com.intellij.openapi.actionSystem.DataContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/statistic/DbFusUltimateActionsListener;", "Lcom/intellij/database/util/DbUltimateActionsListener;", "<init>", "()V", "onTooltipShown", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "onSubscriptionButtonClicked", "createEventData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "displayId", "", "intellij.database.impl"})
public final class DbFusUltimateActionsListener
implements DbUltimateActionsListener {
    @Override
    public void onTooltipShown(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        List<EventPair<?>> data = this.createEventData(dataContext, "database.ultimate.tooltip.shown");
        data.add(NotificationsEventLogGroup.DISPLAY_TYPE.with((Object)NotificationDisplayType.BALLOON));
        data.add(NotificationsEventLogGroup.SEVERITY.with((Object)NotificationCollector.NotificationSeverity.INFORMATION));
        data.add(NotificationsEventLogGroup.IS_EXPANDABLE.with((Object)false));
        NotificationsEventLogGroup.SHOWN.log(DatabaseContextFun.getProject(dataContext), data);
    }

    @Override
    public void onSubscriptionButtonClicked(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        List<EventPair<?>> data = this.createEventData(dataContext, "database.ultimate.button.clicked");
        data.add(NotificationsEventLogGroup.NOTIFICATION_PLACE.with((Object)NotificationCollector.NotificationPlace.BALLOON));
        NotificationsEventLogGroup.ACTION_INVOKED.log(DatabaseContextFun.getProject(dataContext), data);
    }

    private final List<EventPair<?>> createEventData(DataContext dataContext, String displayId) {
        List list = NotificationCollector.createNotificationData((String)"Database Ultimate features", (String)(System.currentTimeMillis() + "." + dataContext.hashCode()), (String)displayId);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createNotificationData(...)");
        return list;
    }
}

