/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtilCore;
import icons.DatabaseIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001#B0\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0015\u0010\u0004\u001a\u00110\u0003\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u000b\u0010 \u001a\u00070\u0003\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u001dH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u00110\u0003\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006$"}, d2={"Lcom/intellij/database/util/DbObjectCategory;", "", "id", "", "key", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.DatabaseBundle", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getId", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "DATA_SOURCES", "NAMESPACES", "TABLES", "SCRIPTING", "TYPES", "SYNONYMS", "ROLES", "COLUMNS", "INDICES", "CONSTRAINTS", "SERVERS", "OTHER", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "isTranslated", "Companion", "intellij.database.impl"})
public abstract class DbObjectCategory
extends Enum<DbObjectCategory> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final String key;
    @NotNull
    private final Icon icon;
    public static final /* enum */ DbObjectCategory DATA_SOURCES;
    public static final /* enum */ DbObjectCategory NAMESPACES;
    public static final /* enum */ DbObjectCategory TABLES;
    public static final /* enum */ DbObjectCategory SCRIPTING;
    public static final /* enum */ DbObjectCategory TYPES;
    public static final /* enum */ DbObjectCategory SYNONYMS;
    public static final /* enum */ DbObjectCategory ROLES;
    public static final /* enum */ DbObjectCategory COLUMNS;
    public static final /* enum */ DbObjectCategory INDICES;
    public static final /* enum */ DbObjectCategory CONSTRAINTS;
    public static final /* enum */ DbObjectCategory SERVERS;
    public static final /* enum */ DbObjectCategory OTHER;
    private static final /* synthetic */ DbObjectCategory[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private DbObjectCategory(String id, String key, Icon icon) {
        this.id = id;
        this.key = key;
        this.icon = icon;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    public abstract boolean contains(@NotNull ObjectKind var1);

    @NotNull
    public final String getDisplayName() {
        String string = DatabaseBundle.message((String)this.key, (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @TestOnly
    public final boolean isTranslated() {
        return DatabaseBundle.INSTANCE.messageOrNull(this.key, new Object[0]) != null;
    }

    public static DbObjectCategory[] values() {
        return (DbObjectCategory[])$VALUES.clone();
    }

    public static DbObjectCategory valueOf(String value) {
        return Enum.valueOf(DbObjectCategory.class, value);
    }

    @NotNull
    public static EnumEntries<DbObjectCategory> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ DbObjectCategory(String $enum$name, int $enum$ordinal, String id, String key, Icon icon, DefaultConstructorMarker $constructor_marker) {
        this(id, key, icon);
    }

    static {
        DATA_SOURCES = new DATA_SOURCES("DATA_SOURCES", 0);
        NAMESPACES = new NAMESPACES("NAMESPACES", 1);
        TABLES = new TABLES("TABLES", 2);
        SCRIPTING = new SCRIPTING("SCRIPTING", 3);
        TYPES = new TYPES("TYPES", 4);
        SYNONYMS = new SYNONYMS("SYNONYMS", 5);
        ROLES = new ROLES("ROLES", 6);
        COLUMNS = new COLUMNS("COLUMNS", 7);
        INDICES = new INDICES("INDICES", 8);
        CONSTRAINTS = new CONSTRAINTS("CONSTRAINTS", 9);
        SERVERS = new SERVERS("SERVERS", 10);
        OTHER = new OTHER("OTHER", 11);
        $VALUES = dbObjectCategoryArray = new DbObjectCategory[]{DbObjectCategory.DATA_SOURCES, DbObjectCategory.NAMESPACES, DbObjectCategory.TABLES, DbObjectCategory.SCRIPTING, DbObjectCategory.TYPES, DbObjectCategory.SYNONYMS, DbObjectCategory.ROLES, DbObjectCategory.COLUMNS, DbObjectCategory.INDICES, DbObjectCategory.CONSTRAINTS, DbObjectCategory.SERVERS, DbObjectCategory.OTHER};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.COLUMNS", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class COLUMNS
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        COLUMNS() {
            void var1_1;
            Icon icon = DatabaseIcons.Col;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Col");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.COLUMN) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.OBJECT_ATTRIBUTE);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.CONSTRAINTS", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class CONSTRAINTS
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        CONSTRAINTS() {
            void var1_1;
            Icon icon = DatabaseIcons.BlueKey;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BlueKey");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.CHECK) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.DEFAULT) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.KEY) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.FOREIGN_KEY);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/util/DbObjectCategory$Companion;", "", "<init>", "()V", "detect", "Lcom/intellij/database/util/DbObjectCategory;", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbObjectCategory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectCategory.kt\ncom/intellij/database/util/DbObjectCategory$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DbObjectCategory detect(@NotNull ObjectKind kind) {
            DbObjectCategory dbObjectCategory;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                Iterable iterable = (Iterable)DbObjectCategory.getEntries();
                for (Object t : iterable) {
                    DbObjectCategory it = (DbObjectCategory)((Object)t);
                    boolean bl = false;
                    if (!(it != OTHER && it.contains(kind))) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((dbObjectCategory = (DbObjectCategory)v0) == null) {
                dbObjectCategory = OTHER;
            }
            return dbObjectCategory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.DATA_SOURCES", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class DATA_SOURCES
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        DATA_SOURCES() {
            void var1_1;
            Icon icon = DatabaseIcons.Dbms;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Dbms");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROOT);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.INDICES", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class INDICES
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        INDICES() {
            void var1_1;
            Icon icon = DatabaseIcons.Index;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Index");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.INDEX) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.PROJECTION);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.NAMESPACES", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class NAMESPACES
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        NAMESPACES() {
            void var1_1;
            Icon icon = DatabaseIcons.Database;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Database");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return DbImplUtilCore.isNamespace((ObjectKind)kind);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.OTHER", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class OTHER
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        OTHER() {
            void var1_1;
            Icon icon = DatabaseIcons.ObjectGroup;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ObjectGroup");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Companion.detect(kind) == this;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.ROLES", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class ROLES
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        ROLES() {
            void var1_1;
            Icon icon = DatabaseIcons.Role;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Role");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROLE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.USER) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.GROUP) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.LOGIN) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.USER_MAPPING);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.SCRIPTING", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class SCRIPTING
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        SCRIPTING() {
            void var1_1;
            Icon icon = DatabaseIcons.Scripting_script;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Scripting_script");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return DbImplUtilCore.isRoutine((ObjectKind)kind) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCRIPT) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MACRO) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.EXCEPTION) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ASSEMBLY) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.OPERATOR) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.FOREIGN_FUNCTION) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.METHOD) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.CONSTANT) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.PARTITION_FUNCTION) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.BODY) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.PACKAGE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VARIABLE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.CAST);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.SERVERS", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class SERVERS
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        SERVERS() {
            void var1_1;
            Icon icon = DatabaseIcons.Foreign_server;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Foreign_server");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SERVER) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.DB_LINK) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.LINKED_SERVER) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.CONNECTION) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.DATASHARE);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.SYNONYMS", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class SYNONYMS
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        SYNONYMS() {
            void var1_1;
            Icon icon = DatabaseIcons.Synonym;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Synonym");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SYNONYM);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.TABLES", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class TABLES
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        TABLES() {
            void var1_1;
            Icon icon = DatabaseIcons.Table;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Table");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return DbImplUtilCore.isDataTable((ObjectKind)kind) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.CLUSTER);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"com/intellij/database/util/DbObjectCategory.TYPES", "Lcom/intellij/database/util/DbObjectCategory;", "contains", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.impl"})
    static final class TYPES
    extends DbObjectCategory {
        /*
         * WARNING - void declaration
         */
        TYPES() {
            void var1_1;
            Icon icon = DatabaseIcons.CollectionType;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CollectionType");
        }

        @Override
        public boolean contains(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ALIAS_TYPE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.COLLECTION_TYPE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.OBJECT_TYPE) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE_TYPE);
        }
    }
}

