/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.cloudExplorer.CloudConnectionUI;
import com.intellij.database.cloudExplorer.CloudDataSourceProvider;
import com.intellij.database.view.ui.CloudConfigurable;
import com.intellij.database.view.ui.CloudConfigurationPanelKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/ui/CloudConfigurationPanel;", "", "configurable", "Lcom/intellij/database/view/ui/CloudConfigurable;", "<init>", "(Lcom/intellij/database/view/ui/CloudConfigurable;)V", "cloudConnectionUI", "Lcom/intellij/database/cloudExplorer/CloudConnectionUI;", "getComponent", "Ljavax/swing/JComponent;", "saveFields", "", "connectionData", "Lcom/intellij/database/cloudExplorer/CloudConnectionData;", "reset", "onTestConnectionFinished", "intellij.database.impl"})
public final class CloudConfigurationPanel {
    @NotNull
    private final CloudConnectionUI cloudConnectionUI;

    public CloudConfigurationPanel(@NotNull CloudConfigurable configurable) {
        Intrinsics.checkNotNullParameter((Object)((Object)configurable), (String)"configurable");
        CloudConnectionData connectionData = configurable.getTempTarget();
        Project project = configurable.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CloudConnectionUI ui = CloudDataSourceProvider.Companion.createUI(project, connectionData, (Disposable)configurable, configurable.getCoroutineScope());
        if (ui == null) {
            CloudConfigurationPanelKt.access$getLOG$p().error("Cannot create configuration UI (pluginId=" + connectionData.getCloudProviderId() + ")");
            throw new IllegalStateException("Cannot create configuration UI");
        }
        this.cloudConnectionUI = ui;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.cloudConnectionUI.getComponent();
    }

    public final void saveFields(@NotNull CloudConnectionData connectionData) {
        Intrinsics.checkNotNullParameter((Object)connectionData, (String)"connectionData");
        this.cloudConnectionUI.saveFields(connectionData);
    }

    public final void reset(@NotNull CloudConnectionData connectionData) {
        Intrinsics.checkNotNullParameter((Object)connectionData, (String)"connectionData");
        this.cloudConnectionUI.reset(connectionData);
    }

    public final void onTestConnectionFinished() {
        this.cloudConnectionUI.onTestConnectionFinished();
    }
}

