/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.injectors;

import com.intellij.javaee.el.util.ElTemplateParser;
import com.intellij.javaee.utils.persistence.data.QLInjectorContext;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.injection.MultiHostRegistrarPlaceholderHelper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.el.SpringELLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f\u0018\u00010\u00110\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spring/data/injectors/SpringDataQLInjectorBase;", "Lcom/intellij/lang/injection/MultiHostInjector;", "<init>", "()V", "isSuitableForInjection", "", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "getLanguageToInject", "Lcom/intellij/lang/Language;", "isAvailable", "context", "Lcom/intellij/psi/PsiElement;", "processInjection", "", "elementsToInjectIn", "", "Ljava/lang/Class;", "getLanguagesToInject", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "getSuffixString", "", "text", "qlRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringDataQLInjectorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringDataQLInjectorBase.kt\ncom/intellij/spring/data/injectors/SpringDataQLInjectorBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1586#2:78\n1661#2,3:79\n*S KotlinDebug\n*F\n+ 1 SpringDataQLInjectorBase.kt\ncom/intellij/spring/data/injectors/SpringDataQLInjectorBase\n*L\n52#1:78\n52#1:79,3\n*E\n"})
public abstract class SpringDataQLInjectorBase
implements MultiHostInjector {
    protected abstract boolean isSuitableForInjection(@NotNull PsiLanguageInjectionHost var1);

    @NotNull
    protected abstract Language getLanguageToInject(@NotNull PsiLanguageInjectionHost var1);

    protected boolean isAvailable(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return QLInjectorContext.isInjectionTarget((PsiElement)context) && SpringDataUtil.hasSpringDataSupport(context.getProject());
    }

    protected void processInjection(@NotNull PsiLanguageInjectionHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List list = QLInjectorContext.elementsToInjectIn();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"elementsToInjectIn(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isAvailable(context)) {
            return;
        }
        UStringConcatenationsFacade uStringConcatenationsFacade = UStringConcatenationsFacade.Companion.getConcatenationsFacade(context);
        if (uStringConcatenationsFacade == null) {
            return;
        }
        UStringConcatenationsFacade concatenationsFacade = uStringConcatenationsFacade;
        if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
            return;
        }
        Sequence hosts = concatenationsFacade.getPsiLanguageInjectionHosts();
        PsiLanguageInjectionHost theFirstHost = (PsiLanguageInjectionHost)SequencesKt.firstOrNull((Sequence)concatenationsFacade.getPsiLanguageInjectionHosts());
        if (theFirstHost != null && this.isSuitableForInjection(theFirstHost)) {
            Map spElTextRangeMap = new LinkedHashMap();
            MultiHostRegistrarPlaceholderHelper hostRegistrar = new MultiHostRegistrarPlaceholderHelper(registrar).startInjecting(this.getLanguageToInject(theFirstHost)).addGlobalPlaceholders((Iterable)concatenationsFacade.getPlaceholders());
            for (PsiLanguageInjectionHost entry : SequencesKt.asIterable((Sequence)hosts)) {
                void $this$mapTo$iv$iv;
                String text = entry.getText();
                List spElTextRanges = ElTemplateParser.parse((String)text);
                if (!spElTextRanges.isEmpty()) {
                    spElTextRangeMap.put(entry, spElTextRanges);
                }
                Intrinsics.checkNotNull((Object)spElTextRanges);
                Iterable $this$map$iv = spElTextRanges;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void range;
                    TextRange textRange = (TextRange)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)text);
                    Intrinsics.checkNotNull((Object)range);
                    collection.add(new Pair((Object)range, (Object)this.getSuffixString(text, (TextRange)range)));
                }
                List spEls = (List)destination$iv$iv;
                hostRegistrar.addHostPlaces(entry, spEls);
            }
            hostRegistrar.doneInjecting();
            for (Map.Entry entry : spElTextRangeMap.entrySet()) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)entry.getKey();
                List value = (List)entry.getValue();
                for (TextRange range : value) {
                    registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, host, range).doneInjecting();
                }
            }
            this.processInjection(theFirstHost);
        }
    }

    private final String getSuffixString(String text, TextRange qlRange) {
        int posBefore = qlRange.getStartOffset() - 1;
        if (posBefore < 0 || posBefore >= text.length()) {
            return "SpEl";
        }
        return text.charAt(posBefore) == '?' ? "0" : "SpEl";
    }
}

