/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.logical;

import com.intellij.ide.structureView.logical.LogicalStructureElementsProvider;
import com.intellij.jpa.jpb.model.repository.RepositorySearch;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.data.logical.SpringRepositoryMethodLogicalModel;
import com.intellij.spring.data.logical.SpringRepositoryMethodType;
import com.intellij.spring.data.logical.SpringRepositoryMethodsGroup;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/data/logical/SpringRepositoryMethodsProvider;", "Lcom/intellij/ide/structureView/logical/LogicalStructureElementsProvider;", "Lcom/intellij/spring/model/logical/SpringBeanLogicalModel;", "Lcom/intellij/spring/data/logical/SpringRepositoryMethodsGroup;", "<init>", "()V", "isApplicable", "", "parent", "getElements", "", "intellij.spring.data"})
@SourceDebugExtension(value={"SMAP\nSpringRepositoryMethodsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringRepositoryMethodsProvider.kt\ncom/intellij/spring/data/logical/SpringRepositoryMethodsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1915#2,2:131\n296#2,2:133\n296#2,2:135\n*S KotlinDebug\n*F\n+ 1 SpringRepositoryMethodsProvider.kt\ncom/intellij/spring/data/logical/SpringRepositoryMethodsProvider\n*L\n33#1:131,2\n42#1:133,2\n49#1:135,2\n*E\n"})
public final class SpringRepositoryMethodsProvider
implements LogicalStructureElementsProvider<SpringBeanLogicalModel, SpringRepositoryMethodsGroup> {
    public boolean isApplicable(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getSpringBean() instanceof SpringRepository || parent.getSpringBean() instanceof SpringRepositoryDefinition;
    }

    @NotNull
    public List<SpringRepositoryMethodsGroup> getElements(@NotNull SpringBeanLogicalModel parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        CommonSpringBean commonSpringBean = parent.getSpringBean();
        SpringStereotypeElement springStereotypeElement = commonSpringBean instanceof SpringStereotypeElement ? (SpringStereotypeElement)commonSpringBean : null;
        if (springStereotypeElement == null) {
            return CollectionsKt.emptyList();
        }
        SpringStereotypeElement repository = springStereotypeElement;
        if (!(repository instanceof SpringRepository) && !(repository instanceof SpringRepositoryDefinition)) {
            return CollectionsKt.emptyList();
        }
        LinkedHashMap result = new LinkedHashMap();
        Iterable $this$forEach$iv = (Iterable)SpringRepositoryMethodType.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpringRepositoryMethodType it = (SpringRepositoryMethodType)((Object)element$iv);
            boolean bl = false;
            ((Map)result).put(it, new SpringRepositoryMethodsGroup(it));
        }
        PsiClass psiClass = repository.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiElement(...)");
        PsiClass repoClass = psiClass;
        boolean isSpringDataRepository = repository instanceof SpringRepositoryDefinition || RepositorySearch.Companion.isRepository(repoClass);
        Set methodsNames = new LinkedHashSet();
        PsiMethod[] psiMethodArray = repoClass.getAllMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getAllMethods(...)");
        for (PsiMethod psiMethod : psiMethodArray) {
            SpringRepositoryMethodType type;
            String name;
            PsiClass psiClass2 = psiMethod.getContainingClass();
            if (Intrinsics.areEqual((Object)(psiClass2 != null ? psiClass2.getQualifiedName() : null), (Object)"java.lang.Object")) continue;
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod.getName(), (String)"getName(...)");
            boolean isModifying = psiMethod.hasAnnotation("org.springframework.data.jpa.repository.Modifying");
            if (isSpringDataRepository) {
                Object v6;
                block12: {
                    Iterable $this$firstOrNull$iv = (Iterable)SpringRepositoryMethodType.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SpringRepositoryMethodType it = (SpringRepositoryMethodType)((Object)element$iv);
                        boolean bl = false;
                        Function3<String, Boolean, PsiMethod, Boolean> function3 = it.getCondition();
                        Boolean bl2 = isModifying;
                        Intrinsics.checkNotNull((Object)psiMethod);
                        if (!((Boolean)function3.invoke((Object)name, (Object)bl2, (Object)psiMethod)).booleanValue()) continue;
                        v6 = element$iv;
                        break block12;
                    }
                    v6 = null;
                }
                if ((v7 = (SpringRepositoryMethodType)v6) == null) {
                    continue;
                }
            } else {
                v7 = type = SpringRepositoryMethodType.CUSTOM;
            }
            if (methodsNames.contains(name)) {
                SpringRepositoryMethodLogicalModel overridingMethods;
                Object object = (SpringRepositoryMethodsGroup)result.get((Object)type);
                if (object != null && (object = ((SpringRepositoryMethodsGroup)object).getElements()) != null) {
                    Object v10;
                    block13: {
                        Iterable $this$firstOrNull$iv = (Iterable)object;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PsiClass superClass;
                            PsiClass childClass;
                            SpringRepositoryMethodLogicalModel it = (SpringRepositoryMethodLogicalModel)element$iv;
                            boolean bl = false;
                            PsiMethod otherMethod = it.getNavigationElement();
                            boolean bl3 = psiMethod.getParameterList().getParametersCount() != otherMethod.getParameterList().getParametersCount() ? false : (psiMethod.getContainingClass() == null ? false : (otherMethod.getContainingClass() == null ? false : (childClass.isInheritor(superClass, true) ? true : Intrinsics.areEqual((Object)otherMethod.getName(), (Object)name) && MethodSignatureUtil.areSignaturesEqual((MethodSignature)otherMethod.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)psiMethod.getSignature(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)childClass, (PsiSubstitutor)PsiSubstitutor.EMPTY))))));
                            if (!bl3) continue;
                            v10 = element$iv;
                            break block13;
                        }
                        v10 = null;
                    }
                    v11 = v10;
                } else {
                    v11 = overridingMethods = null;
                }
                if (overridingMethods != null) continue;
            }
            methodsNames.add(name);
            SpringRepositoryMethodsGroup springRepositoryMethodsGroup = (SpringRepositoryMethodsGroup)result.get((Object)type);
            if (springRepositoryMethodsGroup == null) continue;
            PsiClass psiClass3 = repository.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"getPsiElement(...)");
            Intrinsics.checkNotNull((Object)psiMethod);
            springRepositoryMethodsGroup.add$intellij_spring_data(new SpringRepositoryMethodLogicalModel(psiClass3, psiMethod, type, !Intrinsics.areEqual((Object)psiMethod.getContainingClass(), (Object)repoClass)));
        }
        result.entrySet().removeIf(arg_0 -> SpringRepositoryMethodsProvider.getElements$lambda$4(SpringRepositoryMethodsProvider::getElements$lambda$3, arg_0));
        Collection collection = result.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final boolean getElements$lambda$3(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((SpringRepositoryMethodsGroup)it.getValue()).getElements().isEmpty();
    }

    private static final boolean getElements$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

