/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CassDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public CassDialect() {
        super((TypeHelper)new TypeHelper.CassTypeHelper());
    }

    @NotNull
    public String getDisplayName() {
        return "Cassandra";
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.CASSANDRA;
        if (dbms == null) {
            CassDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            CassDialect.$$$reportNull$$$0(1);
        }
        if (identifier == null) {
            CassDialect.$$$reportNull$$$0(2);
        }
        if (qualifier == null) {
            CassDialect.$$$reportNull$$$0(3);
        }
        DasObject db = CassDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            CassDialect.$$$reportNull$$$0(4);
        }
        return ddlBuilder;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            CassDialect.$$$reportNull$$$0(5);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            CassDialect.$$$reportNull$$$0(6);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        TextInfo info;
        if (binaryData == null) {
            CassDialect.$$$reportNull$$$0(7);
        }
        String string = (info = TextInfo.tryDetectString((byte[])binaryData)) != null ? "textAsBlob(" + DbImplUtilCore.StringLiteralDecorator.PLAIN.decorate(info.text, this.getDbms()) + ")" : "0x" + ObjectFormatterUtil.toHexString((byte[])binaryData);
        if (string == null) {
            CassDialect.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public JdbcHelper.LikeSupport getLikeSupport(@Nullable Version version) {
        JdbcHelper.LikeSupport likeSupport = version != null && version.isOrGreater(new int[]{3, 4}) ? JdbcHelper.LikeSupport.SELECTS_ONLY : JdbcHelper.LikeSupport.NONE;
        if (likeSupport == null) {
            CassDialect.$$$reportNull$$$0(9);
        }
        return likeSupport;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection) throws SQLException {
        String s;
        if (connection == null) {
            CassDialect.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmpty((String)(s = (String)JdbcNativeUtil.computeRemote(() -> connection.getRemoteConnection().getSchema()))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnectionCore connection) throws Exception {
        RemoteDatabaseMetaData metaData;
        if (connection == null) {
            CassDialect.$$$reportNull$$$0(11);
        }
        if ((metaData = connection.getRemoteMetaData()) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CassDialect.$$$reportNull$$$0(12);
            }
            return list;
        }
        String query = connection.getVersion().isOrGreater(new int[]{3}) ? "select keyspace_name from system_schema.keyspaces" : "select keyspace_name from system.schema_keyspaces";
        List list = (List)DbImplUtilCore.executeAndGetResult((DatabaseConnectionCore)connection, (String)query, (ThrowableConvertor)DbImplUtilCore.RS_AS_STRING_LIST);
        if (list == null) {
            CassDialect.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 6, 7, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/cassandra/CassDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/cassandra/CassDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLikeSupport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 6, 7, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

