/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.bigquery.BigQueryTokens;
import com.intellij.sql.dialects.bigquery.BigQueryValidationDelegate;
import com.intellij.sql.dialects.bigquery.psi.BigQueryAggregatePipeExpression;
import com.intellij.sql.dialects.bigquery.psi.BigQueryAsExpressionImpl;
import com.intellij.sql.dialects.bigquery.psi.BigQueryExtendPipeExpression;
import com.intellij.sql.dialects.bigquery.psi.BigQueryParenthesizedExpression;
import com.intellij.sql.dialects.bigquery.psi.BigQueryRenamePipeExpression;
import com.intellij.sql.dialects.bigquery.psi.BigQueryWherePipeExpression;
import com.intellij.sql.dialects.bigquery.refactoring.BigQueryExtractFunctionHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BigQueryDialect
extends SqlLanguageDialectBase {
    public static final BigQueryDialect INSTANCE = new BigQueryDialect();

    private BigQueryDialect() {
        super("BigQuery");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(BigQueryTokens.class);
        if (tokensHelper == null) {
            BigQueryDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.BIGQUERY;
        if (dbms == null) {
            BigQueryDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            BigQueryDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            BigQueryDialect.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            BigQueryDialect.$$$reportNull$$$0(4);
        }
        if (processor.isExpected(ObjectKind.VARIABLE)) {
            for (ReservedEntity var : LazyData.systemVars) {
                if (!SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)var.name, (boolean)resolve) || processor.executeTarget((DasSymbol)var, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve, processor);
    }

    public boolean isResolveTargetNotAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            BigQueryDialect.$$$reportNull$$$0(5);
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.TABLE)) {
            BigQueryAsExpressionImpl as;
            PsiElement psi = DasSymbolUtil.getSinglePsiSource((DasSymbol)symbol);
            return psi instanceof BigQueryAsExpressionImpl && (as = (BigQueryAsExpressionImpl)psi).isUnnestExpression();
        }
        return super.isResolveTargetNotAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            BigQueryDialect.$$$reportNull$$$0(6);
        }
        if (type == ObjectKind.VIRTUAL_TABLE && expectedTypes.contains(ObjectKind.TABLE)) {
            return true;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            BigQueryAsExpressionImpl as;
            PsiElement psi = DasSymbolUtil.getSinglePsiSource((DasSymbol)symbol);
            if (psi == null) {
                return false;
            }
            if (psi instanceof BigQueryAsExpressionImpl && (as = (BigQueryAsExpressionImpl)psi).isUnnestExpression()) {
                return true;
            }
            PsiElement parent = psi.getParent();
            return parent instanceof BigQueryParenthesizedExpression || parent instanceof BigQueryExtendPipeExpression || parent instanceof BigQueryRenamePipeExpression || parent instanceof BigQueryAggregatePipeExpression || parent instanceof SqlGroupByClause && parent.getParent() instanceof BigQueryAggregatePipeExpression;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"INT64", (String)"INT64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"FLOAT64", (String)"FLOAT64", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"NUMERIC", (String)"NUMERIC", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"ARRAY", (String)"ARRAY", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"BYTES", (String)"BYTES", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"STRING", (String)"STRING", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"GEOGRAPHY", (String)"GEOGRAPHY", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"BIGNUMERIC", (String)"BIGNUMERIC", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"JSON", (String)"JSON", (SqlLanguageDialectEx)this);
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        Collection res = super.getParentDbTypes(result, type);
        if (type == ObjectKind.COLUMN) {
            res.add(ObjectKind.COLUMN);
        }
        if (type == ObjectKind.TABLE) {
            res.add(ObjectKind.TABLE);
        }
        return (T)res;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != ObjectKind.PACKAGE && type != ObjectKind.CONNECTION && super.shallResolve(o, type);
    }

    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        return new TreePattern(SqlImportUtil.createDataSources((ObjectName[])dsNames, (TreePatternNode.Group[])new TreePatternNode.Group[]{TreePatternUtils.create(Arrays.asList(ObjectName.plain((String)"main"), ObjectName.plain((String)"temp")), (ObjectKind)ObjectKind.SCHEMA, (TreePatternNode.Group[])new TreePatternNode.Group[0])}));
    }

    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            BigQueryDialect.$$$reportNull$$$0(7);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath((TreePattern)pattern, (ObjectName[])dsNames, Arrays.asList(ObjectName.plain((String)"main"), ObjectName.plain((String)"temp")), (boolean)true, (ObjectKind[])new ObjectKind[]{SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA});
        if (treePattern == null) {
            BigQueryDialect.$$$reportNull$$$0(8);
        }
        return treePattern;
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false})})});
    }

    public boolean allowsAggregateCalls(@NotNull PsiElement e) {
        if (e == null) {
            BigQueryDialect.$$$reportNull$$$0(9);
        }
        return e instanceof BigQueryWherePipeExpression || e instanceof BigQueryAggregatePipeExpression || super.allowsAggregateCalls(e);
    }

    @NotNull
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        BigQueryExtractFunctionHelper bigQueryExtractFunctionHelper = BigQueryExtractFunctionHelper.INSTANCE;
        if (bigQueryExtractFunctionHelper == null) {
            BigQueryDialect.$$$reportNull$$$0(10);
        }
        return bigQueryExtractFunctionHelper;
    }

    @NotNull
    public SqlValidatingHighlightVisitor.Delegate createValidationDelegate(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            BigQueryDialect.$$$reportNull$$$0(11);
        }
        return new BigQueryValidationDelegate((SqlLanguageDialectEx)this, holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/bigquery/BigQueryDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/bigquery/BigQueryDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractFunctionHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetNotAccepted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allowsAggregateCalls";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createValidationDelegate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 9, 11 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        private static final Set<String> ourSystemVarsWithTypes = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
        static final List<ReservedEntity> systemVars = ContainerUtil.map(ourSystemVarsWithTypes, name2 -> {
            int colon = name2.indexOf(58);
            String n = colon == -1 ? name2 : name2.substring(0, colon);
            String type = colon == -1 ? null : name2.substring(colon + 1);
            return type == null ? new ReservedEntity(Dbms.BIGQUERY, n, ObjectKind.VARIABLE) : new ReservedEntity.Typed(Dbms.BIGQUERY, n, ObjectKind.VARIABLE, DasUnresolvedTypeReference.of((DataType)DataTypeFactory.of((String)type)));
        });
        static final Set<String> ourSystemVars = ContainerUtil.map2Set(systemVars, var -> var.name);
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ);
        static final TokenSet ourClosingTokens = SqlTokens.STATEMENT_SEPARATORS;

        LazyData() {
        }
    }
}

