/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.h2.H2DdlParsing;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.h2.H2DmlParsing;
import com.intellij.sql.dialects.h2.H2ExpressionParsing;
import com.intellij.sql.dialects.h2.H2GeneratedParser;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public final class H2Parser
extends SqlParser {
    public H2Parser() {
        super((SqlLanguageDialectEx)H2Dialect.INSTANCE);
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return H2GeneratedParser.statement(builder, level);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return H2GeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return H2DmlParsing.top_query_expression(builder, level);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return H2GeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = H2ExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, H2ExpressionParsing::evaluable_expression);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? H2DdlParsing.type_element_ext(builder, level) : H2DdlParsing.type_element(builder, level);
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        H2GeneratedParser.analytic_clause(builder, level);
        return true;
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, H2ExpressionParsing::parenthesized_query_or_values, H2DmlParsing::top_query_expression, H2Parser::parseTopQueryExpressionTail, H2ExpressionParsing::row_element_list, (b, l) -> H2ExpressionParsing.root_expr_0(b, l, -1) && H2ExpressionParsing.row_element_list_separator(b, l) && H2ExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, H2DmlParsing::parenthesized_aliased_join_expression, H2DmlParsing::top_query_expression, H2Parser::parseTopQueryExpressionTail, H2DmlParsing::comma_join_expression, (b, l) -> H2DmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return H2GeneratedParser.table_opt_column_opt_list(builder, level);
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        H2DmlParsing.query_expression_0(builder, level, -1);
        return H2DmlParsing.left_inner_table_op_tail(builder, level);
    }
}

