/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import com.jetbrains.rd.platform.codeWithMe.blockmap.ChunkInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.CopyChunksFromFileTask;
import com.jetbrains.rd.platform.codeWithMe.blockmap.CreateFileTask;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DesiredVersion;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMap;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirMergerKt;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DownloadFile;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.NetFileTask;
import com.jetbrains.rd.platform.codeWithMe.blockmap.ReleaseGetter;
import com.jetbrains.rd.platform.codeWithMe.blockmap.misc.CompressorKt;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ4\u0010\u0010\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00110\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirMerger;", "", "localDirs", "", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMap;", "desiredVersion", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DesiredVersion;", "outputPath", "NET_PARALLELISM", "", "WRITE_PARALLELISM", "<init>", "(Ljava/util/Map;Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DesiredVersion;Ljava/lang/String;II)V", "merge", "", "getSizes", "Lkotlin/Pair;", "bytesFileTask", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DownloadFile;", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nDirMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirMerger.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/DirMerger\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,160:1\n196#2:161\n196#2:162\n1220#3,2:163\n1249#3,4:165\n1586#3:169\n1661#3,3:170\n1915#3,2:173\n1915#3,2:186\n1586#3:188\n1661#3,3:189\n1915#3,2:192\n540#4:175\n525#4,6:176\n129#5:182\n158#5,3:183\n*S KotlinDebug\n*F\n+ 1 DirMerger.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/DirMerger\n*L\n54#1:161\n74#1:162\n75#1:163,2\n75#1:165,4\n82#1:169\n82#1:170,3\n84#1:173,2\n95#1:186,2\n103#1:188\n103#1:189,3\n105#1:192,2\n91#1:175\n91#1:176,6\n93#1:182\n93#1:183,3\n*E\n"})
public final class DirMerger {
    @NotNull
    private final Map<String, DirBlockMap> localDirs;
    @NotNull
    private final DesiredVersion desiredVersion;
    @NotNull
    private final String outputPath;
    private final int NET_PARALLELISM;
    private final int WRITE_PARALLELISM;

    public DirMerger(@NotNull Map<String, DirBlockMap> localDirs, @NotNull DesiredVersion desiredVersion, @NotNull String outputPath, int NET_PARALLELISM, int WRITE_PARALLELISM) {
        Intrinsics.checkNotNullParameter(localDirs, (String)"localDirs");
        Intrinsics.checkNotNullParameter((Object)desiredVersion, (String)"desiredVersion");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.localDirs = localDirs;
        this.desiredVersion = desiredVersion;
        this.outputPath = outputPath;
        this.NET_PARALLELISM = NET_PARALLELISM;
        this.WRITE_PARALLELISM = WRITE_PARALLELISM;
    }

    public /* synthetic */ DirMerger(Map map, DesiredVersion desiredVersion, String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n = 3;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 5;
        }
        this(map, desiredVersion, string, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final void merge() {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object element$iv2;
        void $this$forEach$iv2;
        Object item$iv$iv;
        Iterator $this$mapTo$iv$iv2;
        Object it;
        Object object;
        Iterable $this$associateByTo$iv$iv;
        void $this$decodeFromByteArray$iv;
        String[] stringArray;
        void $this$decodeFromByteArray$iv2;
        long start = System.currentTimeMillis();
        ForkJoinPool netPool = new ForkJoinPool(this.NET_PARALLELISM);
        ReleaseGetter releaseGetter = new ReleaseGetter(this.desiredVersion);
        DownloadFile bytesFileTask = new DownloadFile("BYTES_INDEX", releaseGetter);
        netPool.submit(bytesFileTask);
        DownloadFile blockMapTask = new DownloadFile("COMPRESSED_BLOCK_MAP_INDEX", releaseGetter);
        netPool.submit(blockMapTask);
        DownloadFile compressedChunksIndexTask = new DownloadFile("COMPRESSED_CHUNKS_INDEX", releaseGetter);
        netPool.submit(compressedChunksIndexTask);
        HashMap<String, Map<String, ChunkInfo>> localBlockMaps = DirMergerKt.createLocalBlockMaps(this.localDirs);
        Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> pair = this.getSizes(bytesFileTask);
        Pair blockMapSize = (Pair)pair.component1();
        Pair chunksSize = (Pair)pair.component2();
        byte[] newBlockMapBytes = (byte[])blockMapTask.get();
        if (newBlockMapBytes.length != ((Number)blockMapSize.getSecond()).intValue()) {
            throw new RuntimeException("Failed to get whole newBlockMap");
        }
        byte[] tmp = new byte[((Number)blockMapSize.getFirst()).intValue()];
        Intrinsics.checkNotNull((Object)newBlockMapBytes);
        CompressorKt.decompress(newBlockMapBytes, tmp);
        BinaryFormat binaryFormat = (BinaryFormat)ProtoBuf.Default;
        Object bytes$iv = tmp;
        boolean $i$f$decodeFromByteArray = false;
        $this$decodeFromByteArray$iv2.getSerializersModule();
        DirBlockMap newBlockMap = (DirBlockMap)$this$decodeFromByteArray$iv2.decodeFromByteArray((DeserializationStrategy)DirBlockMap.Companion.serializer(), (byte[])bytes$iv);
        Map remoteChunks = new LinkedHashMap();
        bytes$iv = newBlockMap.getFileInfos().iterator();
        while (bytes$iv.hasNext()) {
            FileInfo fileInfo = (FileInfo)bytes$iv.next();
            stringArray = new String[]{fileInfo.getName()};
            File targetFile = Paths.get(this.outputPath, stringArray).toFile();
            if (!targetFile.exists()) {
                File file = targetFile.getParentFile();
                if (file != null) {
                    file.mkdirs();
                }
                targetFile.createNewFile();
            }
            remoteChunks.put(fileInfo, DirMergerKt.findRemoteChunks(newBlockMap, fileInfo, (Map<String, ? extends Map<String, ChunkInfo>>)localBlockMaps));
        }
        byte[] compressedChunksBytes = (byte[])compressedChunksIndexTask.get();
        if (compressedChunksBytes.length != ((Number)chunksSize.getSecond()).intValue()) {
            throw new RuntimeException("Failed to get whole compressedChunksBytes");
        }
        byte[] tmp1 = new byte[((Number)chunksSize.getFirst()).intValue()];
        Intrinsics.checkNotNull((Object)compressedChunksBytes);
        CompressorKt.decompress(compressedChunksBytes, tmp1);
        stringArray = (String[])ProtoBuf.Default;
        byte[] bytes$iv2 = tmp1;
        boolean $i$f$decodeFromByteArray2 = false;
        $this$decodeFromByteArray$iv.getSerializersModule();
        List tmpCmp = (List)$this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)new ArrayListSerializer(Chunk.Companion.serializer()), bytes$iv2);
        Iterable $this$associateBy$iv = tmpCmp;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Chunk chunk = (Chunk)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(((Chunk)it).getHash(), element$iv$iv);
        }
        Map compressedChunks = destination$iv$iv;
        System.out.println((Object)("Pre merge time " + (float)(System.currentTimeMillis() - start) / 1000.0f + "s"));
        start = System.currentTimeMillis();
        ForkJoinPool createPool = new ForkJoinPool(this.WRITE_PARALLELISM * 2);
        Iterable $this$map$iv = newBlockMap.getFileInfos();
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (FileInfo)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(createPool.submit(new CreateFileTask((FileInfo)it, this.outputPath)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            ForkJoinTask it2 = (ForkJoinTask)element$iv2;
            boolean bl = false;
            it2.join();
        }
        System.out.println((Object)("Create time " + (float)(System.currentTimeMillis() - start) / 1000.0f + "s"));
        start = System.currentTimeMillis();
        Object $this$filter$iv = remoteChunks;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.entrySet().iterator();
        while (bl.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = bl.next();
            boolean bl2 = false;
            boolean bl3 = !((Collection)it.getValue()).isEmpty();
            if (!bl3) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        bl = $this$mapTo$iv$iv2.entrySet().iterator();
        while (bl.hasNext()) {
            it = item$iv$iv = bl.next();
            object = destination$iv$iv;
            boolean bl4 = false;
            FileInfo fileInfo = (FileInfo)it.getKey();
            List chunks = (List)it.getValue();
            object.add(netPool.submit(new NetFileTask(fileInfo, chunks, compressedChunks, releaseGetter, this.outputPath)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            ForkJoinTask it3 = (ForkJoinTask)element$iv2;
            boolean bl5 = false;
            it3.join();
        }
        System.out.println((Object)("Download time " + (float)(System.currentTimeMillis() - start) / 1000.0f + "s"));
        start = System.currentTimeMillis();
        ForkJoinPool localPool = new ForkJoinPool(this.WRITE_PARALLELISM);
        Iterable $this$map$iv2 = newBlockMap.getFileInfos();
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void fileInfo;
            FileInfo bl4 = (FileInfo)item$iv$iv2;
            object = destination$iv$iv2;
            boolean bl6 = false;
            object.add(localPool.submit(new CopyChunksFromFileTask(this.localDirs, newBlockMap, (Map<String, ? extends Map<String, ChunkInfo>>)localBlockMaps, (FileInfo)fileInfo, this.outputPath)));
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            ForkJoinTask it4 = (ForkJoinTask)element$iv3;
            boolean bl7 = false;
            it4.join();
        }
        System.out.println((Object)("Copy time " + (float)(System.currentTimeMillis() - start) / 1000.0f + "s"));
    }

    private final Pair<Pair<Integer, Integer>, Pair<Integer, Integer>> getSizes(DownloadFile bytesFileTask) {
        Object v = bytesFileTask.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        byte[] byArray = (byte[])v;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Object object = charset;
        String str = new String(byArray, (Charset)object);
        object = new char[1];
        object[0] = 59;
        List tokens = StringsKt.split$default((CharSequence)str, (char[])object, (boolean)false, (int)0, (int)6, null);
        if (tokens.size() != 5) {
            throw new RuntimeException("Should be 5");
        }
        String firstPart = tokens.get(0) + ";" + tokens.get(1) + ";" + tokens.get(2) + ";" + tokens.get(3);
        Base64.Encoder encoder = Base64.getEncoder();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = firstPart;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        String hashedFirstPart = encoder.encodeToString(messageDigest.digest(byArray2));
        if (!Intrinsics.areEqual((Object)hashedFirstPart, tokens.get(4))) {
            throw new RuntimeException("Failed to get sizes");
        }
        return TuplesKt.to((Object)TuplesKt.to((Object)Integer.parseInt((String)tokens.get(0)), (Object)Integer.parseInt((String)tokens.get(1))), (Object)TuplesKt.to((Object)Integer.parseInt((String)tokens.get(2)), (Object)Integer.parseInt((String)tokens.get(3))));
    }
}

