/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.settingsSync.core.FileState;
import com.intellij.settingsSync.core.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import com.intellij.settingsSync.core.SettingsSyncState;
import com.intellij.settingsSync.core.SettingsSyncStateHolder;
import com.intellij.settingsSync.core.plugins.SettingsSyncPluginsState;
import com.intellij.util.xmlb.XmlSerializer;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 *2\u00020\u0001:\u0003()*BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003JU\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0014\u0010#\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010%\u001a\u00020&H\u00d6\u0081\u0004J\n\u0010'\u001a\u00020\u000bH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006+"}, d2={"Lcom/intellij/settingsSync/core/SettingsSnapshot;", "", "metaInfo", "Lcom/intellij/settingsSync/core/SettingsSnapshot$MetaInfo;", "fileStates", "", "Lcom/intellij/settingsSync/core/FileState;", "plugins", "Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;", "settingsFromProviders", "", "", "additionalFiles", "<init>", "(Lcom/intellij/settingsSync/core/SettingsSnapshot$MetaInfo;Ljava/util/Set;Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;Ljava/util/Map;Ljava/util/Set;)V", "getMetaInfo", "()Lcom/intellij/settingsSync/core/SettingsSnapshot$MetaInfo;", "getFileStates", "()Ljava/util/Set;", "getPlugins", "()Lcom/intellij/settingsSync/core/plugins/SettingsSyncPluginsState;", "getSettingsFromProviders", "()Ljava/util/Map;", "getAdditionalFiles", "isEmpty", "", "isDeleted", "getState", "Lcom/intellij/settingsSync/core/SettingsSyncState;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "MetaInfo", "AppInfo", "Companion", "intellij.settingsSync.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSettingsSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSnapshot.kt\ncom/intellij/settingsSync/core/SettingsSnapshot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n296#2,2:102\n296#2,2:104\n13#3:106\n*S KotlinDebug\n*F\n+ 1 SettingsSnapshot.kt\ncom/intellij/settingsSync/core/SettingsSnapshot\n*L\n63#1:102,2\n72#1:104,2\n80#1:106\n*E\n"})
public final class SettingsSnapshot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetaInfo metaInfo;
    @NotNull
    private final Set<FileState> fileStates;
    @Nullable
    private final SettingsSyncPluginsState plugins;
    @NotNull
    private final Map<String, Object> settingsFromProviders;
    @NotNull
    private final Set<FileState> additionalFiles;

    public SettingsSnapshot(@NotNull MetaInfo metaInfo, @NotNull Set<? extends FileState> fileStates, @Nullable SettingsSyncPluginsState plugins, @NotNull Map<String, ? extends Object> settingsFromProviders, @NotNull Set<? extends FileState> additionalFiles) {
        Intrinsics.checkNotNullParameter((Object)metaInfo, (String)"metaInfo");
        Intrinsics.checkNotNullParameter(fileStates, (String)"fileStates");
        Intrinsics.checkNotNullParameter(settingsFromProviders, (String)"settingsFromProviders");
        Intrinsics.checkNotNullParameter(additionalFiles, (String)"additionalFiles");
        this.metaInfo = metaInfo;
        this.fileStates = fileStates;
        this.plugins = plugins;
        this.settingsFromProviders = settingsFromProviders;
        this.additionalFiles = additionalFiles;
    }

    @NotNull
    public final MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @NotNull
    public final Set<FileState> getFileStates() {
        return this.fileStates;
    }

    @Nullable
    public final SettingsSyncPluginsState getPlugins() {
        return this.plugins;
    }

    @NotNull
    public final Map<String, Object> getSettingsFromProviders() {
        return this.settingsFromProviders;
    }

    @NotNull
    public final Set<FileState> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public final boolean isEmpty() {
        return this.fileStates.isEmpty() && (this.plugins == null || this.plugins.getPlugins().isEmpty()) && this.settingsFromProviders.isEmpty() && this.additionalFiles.isEmpty();
    }

    public final boolean isDeleted() {
        return this.metaInfo.isDeleted();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SettingsSyncState getState() {
        Object v0;
        block7: {
            Iterable $this$firstOrNull$iv = this.fileStates;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileState it = (FileState)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)"options/settingsSync.xml")) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        FileState fileState = v0;
        if (fileState == null) {
            return new SettingsSyncStateHolder(null, 1, null);
        }
        FileState fileState2 = fileState;
        if (!(fileState2 instanceof FileState.Modified)) {
            return new SettingsSyncStateHolder(null, 1, null);
        }
        try {
            Object v3;
            block8: {
                void $this$firstOrNull$iv;
                List list = JDOMUtil.load((byte[])((FileState.Modified)fileState2).getContent()).getChildren("component");
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                Iterable $i$f$firstOrNull = list;
                boolean $i$f$firstOrNull2 = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Element it = (Element)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), (Object)"SettingsSyncSettings")) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            Element element = v3;
            if (element == null) {
                return new SettingsSyncStateHolder(null, 1, null);
            }
            Element componentElement = element;
            Object object = XmlSerializer.deserialize((Element)componentElement, SettingsSyncSettings.State.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deserialize(...)");
            SettingsSyncSettings.State state = (SettingsSyncSettings.State)object;
            return new SettingsSyncStateHolder(state);
        }
        catch (Throwable e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SettingsSyncSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unable to deserialize content of settingsSync.xml into object", e);
            return new SettingsSyncStateHolder(null, 1, null);
        }
    }

    @NotNull
    public final MetaInfo component1() {
        return this.metaInfo;
    }

    @NotNull
    public final Set<FileState> component2() {
        return this.fileStates;
    }

    @Nullable
    public final SettingsSyncPluginsState component3() {
        return this.plugins;
    }

    @NotNull
    public final Map<String, Object> component4() {
        return this.settingsFromProviders;
    }

    @NotNull
    public final Set<FileState> component5() {
        return this.additionalFiles;
    }

    @NotNull
    public final SettingsSnapshot copy(@NotNull MetaInfo metaInfo, @NotNull Set<? extends FileState> fileStates, @Nullable SettingsSyncPluginsState plugins, @NotNull Map<String, ? extends Object> settingsFromProviders, @NotNull Set<? extends FileState> additionalFiles) {
        Intrinsics.checkNotNullParameter((Object)metaInfo, (String)"metaInfo");
        Intrinsics.checkNotNullParameter(fileStates, (String)"fileStates");
        Intrinsics.checkNotNullParameter(settingsFromProviders, (String)"settingsFromProviders");
        Intrinsics.checkNotNullParameter(additionalFiles, (String)"additionalFiles");
        return new SettingsSnapshot(metaInfo, fileStates, plugins, settingsFromProviders, additionalFiles);
    }

    public static /* synthetic */ SettingsSnapshot copy$default(SettingsSnapshot settingsSnapshot, MetaInfo metaInfo, Set set, SettingsSyncPluginsState settingsSyncPluginsState, Map map, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            metaInfo = settingsSnapshot.metaInfo;
        }
        if ((n & 2) != 0) {
            set = settingsSnapshot.fileStates;
        }
        if ((n & 4) != 0) {
            settingsSyncPluginsState = settingsSnapshot.plugins;
        }
        if ((n & 8) != 0) {
            map = settingsSnapshot.settingsFromProviders;
        }
        if ((n & 0x10) != 0) {
            set2 = settingsSnapshot.additionalFiles;
        }
        return settingsSnapshot.copy(metaInfo, set, settingsSyncPluginsState, map, set2);
    }

    @NotNull
    public String toString() {
        return "SettingsSnapshot(metaInfo=" + this.metaInfo + ", fileStates=" + this.fileStates + ", plugins=" + this.plugins + ", settingsFromProviders=" + this.settingsFromProviders + ", additionalFiles=" + this.additionalFiles + ")";
    }

    public int hashCode() {
        int result2 = this.metaInfo.hashCode();
        result2 = result2 * 31 + ((Object)this.fileStates).hashCode();
        result2 = result2 * 31 + (this.plugins == null ? 0 : this.plugins.hashCode());
        result2 = result2 * 31 + ((Object)this.settingsFromProviders).hashCode();
        result2 = result2 * 31 + ((Object)this.additionalFiles).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SettingsSnapshot)) {
            return false;
        }
        SettingsSnapshot settingsSnapshot = (SettingsSnapshot)other;
        if (!Intrinsics.areEqual((Object)this.metaInfo, (Object)settingsSnapshot.metaInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fileStates, settingsSnapshot.fileStates)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.plugins, (Object)settingsSnapshot.plugins)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.settingsFromProviders, settingsSnapshot.settingsFromProviders)) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalFiles, settingsSnapshot.additionalFiles);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003JI\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004J\n\u0010\"\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/settingsSync/core/SettingsSnapshot$AppInfo;", "", "applicationId", "Ljava/util/UUID;", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "fullApplicationName", "", "userName", "hostName", "configFolder", "<init>", "(Ljava/util/UUID;Lcom/intellij/openapi/util/BuildNumber;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/util/UUID;", "getBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "getFullApplicationName", "()Ljava/lang/String;", "getUserName", "getHostName", "getConfigFolder", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.settingsSync.core"})
    public static final class AppInfo {
        @NotNull
        private final UUID applicationId;
        @Nullable
        private final BuildNumber buildNumber;
        @Nullable
        private final String fullApplicationName;
        @NotNull
        private final String userName;
        @NotNull
        private final String hostName;
        @NotNull
        private final String configFolder;

        public AppInfo(@NotNull UUID applicationId, @Nullable BuildNumber buildNumber, @Nullable String fullApplicationName, @NotNull String userName, @NotNull String hostName, @NotNull String configFolder) {
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
            Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
            Intrinsics.checkNotNullParameter((Object)configFolder, (String)"configFolder");
            this.applicationId = applicationId;
            this.buildNumber = buildNumber;
            this.fullApplicationName = fullApplicationName;
            this.userName = userName;
            this.hostName = hostName;
            this.configFolder = configFolder;
        }

        @NotNull
        public final UUID getApplicationId() {
            return this.applicationId;
        }

        @Nullable
        public final BuildNumber getBuildNumber() {
            return this.buildNumber;
        }

        @Nullable
        public final String getFullApplicationName() {
            return this.fullApplicationName;
        }

        @NotNull
        public final String getUserName() {
            return this.userName;
        }

        @NotNull
        public final String getHostName() {
            return this.hostName;
        }

        @NotNull
        public final String getConfigFolder() {
            return this.configFolder;
        }

        @NotNull
        public final UUID component1() {
            return this.applicationId;
        }

        @Nullable
        public final BuildNumber component2() {
            return this.buildNumber;
        }

        @Nullable
        public final String component3() {
            return this.fullApplicationName;
        }

        @NotNull
        public final String component4() {
            return this.userName;
        }

        @NotNull
        public final String component5() {
            return this.hostName;
        }

        @NotNull
        public final String component6() {
            return this.configFolder;
        }

        @NotNull
        public final AppInfo copy(@NotNull UUID applicationId, @Nullable BuildNumber buildNumber, @Nullable String fullApplicationName, @NotNull String userName, @NotNull String hostName, @NotNull String configFolder) {
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
            Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
            Intrinsics.checkNotNullParameter((Object)configFolder, (String)"configFolder");
            return new AppInfo(applicationId, buildNumber, fullApplicationName, userName, hostName, configFolder);
        }

        public static /* synthetic */ AppInfo copy$default(AppInfo appInfo, UUID uUID, BuildNumber buildNumber, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = appInfo.applicationId;
            }
            if ((n & 2) != 0) {
                buildNumber = appInfo.buildNumber;
            }
            if ((n & 4) != 0) {
                string = appInfo.fullApplicationName;
            }
            if ((n & 8) != 0) {
                string2 = appInfo.userName;
            }
            if ((n & 0x10) != 0) {
                string3 = appInfo.hostName;
            }
            if ((n & 0x20) != 0) {
                string4 = appInfo.configFolder;
            }
            return appInfo.copy(uUID, buildNumber, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "AppInfo(applicationId=" + this.applicationId + ", buildNumber=" + this.buildNumber + ", fullApplicationName=" + this.fullApplicationName + ", userName=" + this.userName + ", hostName=" + this.hostName + ", configFolder=" + this.configFolder + ")";
        }

        public int hashCode() {
            int result2 = this.applicationId.hashCode();
            result2 = result2 * 31 + (this.buildNumber == null ? 0 : this.buildNumber.hashCode());
            result2 = result2 * 31 + (this.fullApplicationName == null ? 0 : this.fullApplicationName.hashCode());
            result2 = result2 * 31 + this.userName.hashCode();
            result2 = result2 * 31 + this.hostName.hashCode();
            result2 = result2 * 31 + this.configFolder.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AppInfo)) {
                return false;
            }
            AppInfo appInfo = (AppInfo)other;
            if (!Intrinsics.areEqual((Object)this.applicationId, (Object)appInfo.applicationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.buildNumber, (Object)appInfo.buildNumber)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fullApplicationName, (Object)appInfo.fullApplicationName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userName, (Object)appInfo.userName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hostName, (Object)appInfo.hostName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configFolder, (Object)appInfo.configFolder);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/core/SettingsSnapshot$Companion;", "", "<init>", "()V", "extractFromZip", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "zipFile", "Ljava/nio/file/Path;", "intellij.settingsSync.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SettingsSnapshot extractFromZip(@NotNull Path zipFile) {
            Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
            return SettingsSnapshotZipSerializer.INSTANCE.extractFromZip(zipFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/settingsSync/core/SettingsSnapshot$MetaInfo;", "", "dateCreated", "Ljava/time/Instant;", "appInfo", "Lcom/intellij/settingsSync/core/SettingsSnapshot$AppInfo;", "isDeleted", "", "<init>", "(Ljava/time/Instant;Lcom/intellij/settingsSync/core/SettingsSnapshot$AppInfo;Z)V", "getDateCreated", "()Ljava/time/Instant;", "getAppInfo", "()Lcom/intellij/settingsSync/core/SettingsSnapshot$AppInfo;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.settingsSync.core"})
    public static final class MetaInfo {
        @NotNull
        private final Instant dateCreated;
        @Nullable
        private final AppInfo appInfo;
        private final boolean isDeleted;

        public MetaInfo(@NotNull Instant dateCreated, @Nullable AppInfo appInfo, boolean isDeleted) {
            Intrinsics.checkNotNullParameter((Object)dateCreated, (String)"dateCreated");
            this.dateCreated = dateCreated;
            this.appInfo = appInfo;
            this.isDeleted = isDeleted;
        }

        public /* synthetic */ MetaInfo(Instant instant, AppInfo appInfo, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(instant, appInfo, bl);
        }

        @NotNull
        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        @Nullable
        public final AppInfo getAppInfo() {
            return this.appInfo;
        }

        public final boolean isDeleted() {
            return this.isDeleted;
        }

        @NotNull
        public final Instant component1() {
            return this.dateCreated;
        }

        @Nullable
        public final AppInfo component2() {
            return this.appInfo;
        }

        public final boolean component3() {
            return this.isDeleted;
        }

        @NotNull
        public final MetaInfo copy(@NotNull Instant dateCreated, @Nullable AppInfo appInfo, boolean isDeleted) {
            Intrinsics.checkNotNullParameter((Object)dateCreated, (String)"dateCreated");
            return new MetaInfo(dateCreated, appInfo, isDeleted);
        }

        public static /* synthetic */ MetaInfo copy$default(MetaInfo metaInfo, Instant instant, AppInfo appInfo, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                instant = metaInfo.dateCreated;
            }
            if ((n & 2) != 0) {
                appInfo = metaInfo.appInfo;
            }
            if ((n & 4) != 0) {
                bl = metaInfo.isDeleted;
            }
            return metaInfo.copy(instant, appInfo, bl);
        }

        @NotNull
        public String toString() {
            return "MetaInfo(dateCreated=" + this.dateCreated + ", appInfo=" + this.appInfo + ", isDeleted=" + this.isDeleted + ")";
        }

        public int hashCode() {
            int result2 = this.dateCreated.hashCode();
            result2 = result2 * 31 + (this.appInfo == null ? 0 : this.appInfo.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isDeleted);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MetaInfo)) {
                return false;
            }
            MetaInfo metaInfo = (MetaInfo)other;
            if (!Intrinsics.areEqual((Object)this.dateCreated, (Object)metaInfo.dateCreated)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.appInfo, (Object)metaInfo.appInfo)) {
                return false;
            }
            return this.isDeleted == metaInfo.isDeleted;
        }
    }
}

