/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.LogEventDeserializer;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordSizeEstimator;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaperKt;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "", "recorder", "", "product", "device", "records", "", "Lcom/intellij/internal/statistic/eventLog/LogEventRecord;", "internal", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Z)V", "getRecorder", "()Ljava/lang/String;", "getProduct", "getDevice", "getRecords", "()Ljava/util/List;", "getInternal", "()Z", "equals", "other", "hashCode", "", "Companion", "intellij.platform.statistics.uploader"})
public final class LogEventRecordRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorder;
    @NotNull
    private final String product;
    @NotNull
    private final String device;
    @NotNull
    private final List<LogEventRecord> records;
    private final boolean internal;
    private static final int RECORD_SIZE = 1000000;

    public LogEventRecordRequest(@NotNull String recorder, @NotNull String product, @NotNull String device, @NotNull List<LogEventRecord> records, boolean internal) {
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter(records, (String)"records");
        this.recorder = recorder;
        this.product = product;
        this.device = device;
        this.records = records;
        this.internal = internal;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    @NotNull
    public final String getProduct() {
        return this.product;
    }

    @NotNull
    public final String getDevice() {
        return this.device;
    }

    @NotNull
    public final List<LogEventRecord> getRecords() {
        return this.records;
    }

    public final boolean getInternal() {
        return this.internal;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEventRecordRequest");
        LogEventRecordRequest cfr_ignored_0 = (LogEventRecordRequest)object2;
        if (!Intrinsics.areEqual((Object)this.recorder, (Object)((LogEventRecordRequest)other).recorder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.product, (Object)((LogEventRecordRequest)other).product)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.device, (Object)((LogEventRecordRequest)other).device)) {
            return false;
        }
        if (this.internal != ((LogEventRecordRequest)other).internal) {
            return false;
        }
        return Intrinsics.areEqual(this.records, ((LogEventRecordRequest)other).records);
    }

    public int hashCode() {
        int result = this.recorder.hashCode();
        result = 31 * result + this.product.hashCode();
        result = 31 * result + this.device.hashCode();
        result = 31 * result + Boolean.hashCode(this.internal);
        result = 31 * result + ((Object)this.records).hashCode();
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JR\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0011JZ\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0011J\\\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0011H\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest$Companion;", "", "<init>", "()V", "RECORD_SIZE", "", "create", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "file", "Ljava/io/File;", "recorder", "", "product", "deviceId", "filter", "Lcom/intellij/internal/statistic/eventLog/filters/LogEventFilter;", "internal", "", "logger", "Lcom/intellij/internal/statistic/eventLog/DataCollectorDebugLogger;", "machineId", "Lcom/intellij/internal/statistic/eventLog/MachineId;", "escapeData", "user", "maxRecordSize", "fillNextBatch", "reader", "Ljava/io/BufferedReader;", "firstLine", "events", "", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "deserializer", "Lcom/intellij/internal/statistic/eventLog/LogEventDeserializer;", "estimator", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordSizeEstimator;", "fillMachineId", "", "event", "intellij.platform.statistics.uploader"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LogEventRecordRequest create(@NotNull File file, @NotNull String recorder, @NotNull String product, @NotNull String deviceId, @NotNull LogEventFilter filter, boolean internal, @NotNull DataCollectorDebugLogger logger, @NotNull MachineId machineId, boolean escapeData) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
            Intrinsics.checkNotNullParameter((Object)product, (String)"product");
            Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
            try {
                return this.create(file, recorder, product, deviceId, 1000000, filter, internal, logger, machineId, escapeData);
            }
            catch (Exception e) {
                logger.warn("Failed reading event log file", e);
                return null;
            }
        }

        public static /* synthetic */ LogEventRecordRequest create$default(Companion companion, File file, String string, String string2, String string3, LogEventFilter logEventFilter, boolean bl, DataCollectorDebugLogger dataCollectorDebugLogger, MachineId machineId, boolean bl2, int n, Object object) {
            if ((n & 0x100) != 0) {
                bl2 = true;
            }
            return companion.create(file, string, string2, string3, logEventFilter, bl, dataCollectorDebugLogger, machineId, bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final LogEventRecordRequest create(@NotNull File file, @NotNull String recorder, @NotNull String product, @NotNull String user, int maxRecordSize, @NotNull LogEventFilter filter, boolean internal, @NotNull DataCollectorDebugLogger logger, @NotNull MachineId machineId, boolean escapeData) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
            Intrinsics.checkNotNullParameter((Object)product, (String)"product");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
            try {
                LogEventDeserializer deserializer = new LogEventDeserializer(logger);
                ArrayList<LogEventRecord> records = new ArrayList<LogEventRecord>();
                Closeable closeable = new BufferedReader(new FileReader(file.getPath()));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    LogEventRecordSizeEstimator sizeEstimator = new LogEventRecordSizeEstimator(product, user);
                    ArrayList events = new ArrayList();
                    String line = Companion.fillNextBatch(reader, reader.readLine(), events, deserializer, sizeEstimator, maxRecordSize, filter, machineId, escapeData);
                    while (!events.isEmpty()) {
                        records.add(new LogEventRecord(events));
                        events = new ArrayList();
                        line = Companion.fillNextBatch(reader, line, events, deserializer, sizeEstimator, maxRecordSize, filter, machineId, escapeData);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return new LogEventRecordRequest(recorder, product, user, (List<LogEventRecord>)records, internal);
            }
            catch (StreamReadException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                logger.warn(string, e);
            }
            catch (DatabindException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                logger.warn(string, e);
            }
            catch (IOException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                logger.warn(string, e);
            }
            return null;
        }

        public static /* synthetic */ LogEventRecordRequest create$default(Companion companion, File file, String string, String string2, String string3, int n, LogEventFilter logEventFilter, boolean bl, DataCollectorDebugLogger dataCollectorDebugLogger, MachineId machineId, boolean bl2, int n2, Object object) {
            if ((n2 & 0x200) != 0) {
                bl2 = true;
            }
            return companion.create(file, string, string2, string3, n, logEventFilter, bl, dataCollectorDebugLogger, machineId, bl2);
        }

        private final String fillNextBatch(BufferedReader reader, String firstLine, List<LogEvent> events, LogEventDeserializer deserializer, LogEventRecordSizeEstimator estimator, int maxRecordSize, LogEventFilter filter, MachineId machineId, boolean escapeData) {
            int recordSize = 0;
            String line = firstLine;
            while (line != null && recordSize + estimator.estimate(line) < maxRecordSize) {
                LogEvent event = deserializer.fromString(line);
                if (event != null && filter.accepts(event)) {
                    recordSize += estimator.estimate(line);
                    this.fillMachineId(event, machineId);
                    events.add(escapeData ? StatisticsEventEscaperKt.escape((LogEvent)event) : StatisticsEventEscaperKt.escapeExceptData((LogEvent)event));
                }
                line = reader.readLine();
            }
            return line;
        }

        static /* synthetic */ String fillNextBatch$default(Companion companion, BufferedReader bufferedReader, String string, List list, LogEventDeserializer logEventDeserializer, LogEventRecordSizeEstimator logEventRecordSizeEstimator, int n, LogEventFilter logEventFilter, MachineId machineId, boolean bl, int n2, Object object) {
            if ((n2 & 0x100) != 0) {
                bl = true;
            }
            return companion.fillNextBatch(bufferedReader, string, list, logEventDeserializer, logEventRecordSizeEstimator, n, logEventFilter, machineId, bl);
        }

        public final void fillMachineId(@NotNull LogEvent event, @NotNull MachineId machineId) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)machineId, (String)"machineId");
            LogEventAction eventAction = event.getEvent();
            String machineIdValue = machineId.getId();
            int idRevision = machineId.getRevision();
            eventAction.getData().put("system_machine_id", machineIdValue);
            if (idRevision != 0 && !Intrinsics.areEqual((Object)machineId, (Object)MachineId.UNKNOWN) && !Intrinsics.areEqual((Object)machineId, (Object)MachineId.DISABLED)) {
                eventAction.getData().put("system_id_revision", idRevision);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

