/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.i18n;

import com.intellij.docker.agent.i18n.EnglishOrdinalFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"applyOrdinalFormat", "Ljava/text/MessageFormat;", "getOrdinalFormat", "Ljava/text/NumberFormat;", "locale", "Ljava/util/Locale;", "formatEnglish", "", "num", "", "intellij.clouds.docker.agent"})
public final class OrdinalFormatKt {
    @NotNull
    public static final MessageFormat applyOrdinalFormat(@NotNull MessageFormat $this$applyOrdinalFormat) {
        MessageFormat messageFormat;
        Intrinsics.checkNotNullParameter((Object)$this$applyOrdinalFormat, (String)"<this>");
        MessageFormat $this$applyOrdinalFormat_u24lambda_u240 = messageFormat = $this$applyOrdinalFormat;
        boolean bl = false;
        Format[] formats = $this$applyOrdinalFormat_u24lambda_u240.getFormats();
        NumberFormat ordinal = null;
        int n = formats.length;
        for (int i = 0; i < n; ++i) {
            Format element = formats[i];
            if (!(element instanceof DecimalFormat) || !Intrinsics.areEqual((Object)"ordinal", (Object)((DecimalFormat)element).getPositivePrefix())) continue;
            if (ordinal == null) {
                ordinal = OrdinalFormatKt.getOrdinalFormat($this$applyOrdinalFormat_u24lambda_u240.getLocale());
            }
            $this$applyOrdinalFormat_u24lambda_u240.setFormat(i, ordinal);
        }
        return messageFormat;
    }

    private static final NumberFormat getOrdinalFormat(Locale locale) {
        String language;
        if (locale != null && (Intrinsics.areEqual((Object)"en", (Object)(language = locale.getLanguage())) || language != null && ((CharSequence)language).length() == 0)) {
            return new EnglishOrdinalFormat();
        }
        return new DecimalFormat();
    }

    @NotNull
    public static final String formatEnglish(long num) {
        long mod = Math.abs(num) % (long)100;
        if (mod < 11L || mod > 13L) {
            if ((mod %= (long)10) == 1L) {
                return num + "st";
            }
            if (mod == 2L) {
                return num + "nd";
            }
            if (mod == 3L) {
                return num + "rd";
            }
        }
        return num + "th";
    }
}

