/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.RunConfigActionBase;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ConfigureNewRunConfig;", "Lcom/intellij/docker/RunConfigActionBase;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "mySourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "mySourceType", "Lcom/intellij/docker/deploymentSource/DockerSingletonDeploymentSourceType;", "myDocker", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/docker/deploymentSource/DockerSingletonDeploymentSourceType;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "execute", "", "customize", "runConfigWrapper", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerRunConfigActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigActions.kt\ncom/intellij/docker/ConfigureNewRunConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public class ConfigureNewRunConfig
extends RunConfigActionBase {
    @Nullable
    private final VirtualFile mySourceFile;
    @NotNull
    private final DockerSingletonDeploymentSourceType mySourceType;
    @Nullable
    private final RemoteServer<DockerCloudConfiguration> myDocker;

    public ConfigureNewRunConfig(@NotNull DockerRunConfigurationCreator helper, @Nullable VirtualFile mySourceFile, @NotNull DockerSingletonDeploymentSourceType mySourceType, @Nullable RemoteServer<DockerCloudConfiguration> myDocker) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)((Object)mySourceType), (String)"mySourceType");
        super(helper);
        this.mySourceFile = mySourceFile;
        this.mySourceType = mySourceType;
        this.myDocker = myDocker;
        this.getTemplatePresentation().setText(DockerBundle.messagePointer((String)"DockerRunLineMarkerProviderBase.ConfigureNewRunConfig.text", (Object[])new Object[0]));
    }

    @Override
    public void execute() {
        boolean bl;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.getHelper().createConfiguration(this.mySourceType, this.mySourceFile, this.myDocker);
        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"createConfiguration(...)");
        RunnerAndConfigurationSettings runConfig = runnerAndConfigurationSettings;
        DockerRunConfig.Wrapper dockerRunConfig = DockerRunConfig.Wrapper.Companion.wrapIfDocker(runConfig);
        boolean bl2 = bl = dockerRunConfig != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "for " + runConfig;
            throw new AssertionError((Object)string);
        }
        DockerRunConfig.Wrapper wrapper = dockerRunConfig;
        Intrinsics.checkNotNull((Object)wrapper);
        this.customize(wrapper);
        this.getHelper().openForEditingAndExecute(runConfig, DockerBundle.message((String)"DockerRunLineMarkerProviderBase.ConfigureNewRunConfig.dialogTitle", (Object[])new Object[0]));
    }

    protected void customize(@NotNull DockerRunConfig.Wrapper runConfigWrapper) {
        Intrinsics.checkNotNullParameter((Object)runConfigWrapper, (String)"runConfigWrapper");
    }
}

