/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.registry.node;

import com.intellij.docker.agent.registry.model.DockerRegistry;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.registry.node.presentation.DockerRegistryTagInterface;
import com.intellij.docker.view.details.DockerLogsPanel;
import com.intellij.docker.view.registry.node.DockerRegistryNodeBase;
import com.intellij.docker.view.registry.node.DockerRegistryNodeWithLogging;
import com.intellij.docker.view.registry.node.DockerRegistryServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.rpc.ComponentDirectTransferId;
import com.intellij.ide.rpc.ComponentDirectTransferIdKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\f\u0012\u0004\u0012\u00020\u00000\u0001j\u0002`\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0096\u0082\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000#2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020\u0000H\u0016J\u0014\u0010'\u001a\u00020(2\b\u0010\u0017\u001a\u0004\u0018\u00010)H\u0096\u0082\u0004J\n\u0010*\u001a\u00020\u0016H\u0096\u0080\u0004J\b\u0010+\u001a\u00020\u0012H\u0016J\b\u0010,\u001a\u00020\u0012H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020(H\u0016J\b\u00103\u001a\u000204H\u0007J\b\u00105\u001a\u000201H\u0007R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0018\u001a\u00020\u00198WX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010-\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/docker/view/registry/node/DockerRegistryTagNode;", "Lcom/intellij/execution/services/ServiceViewContributor;", "Lcom/intellij/docker/view/registry/node/TagContributor;", "Lcom/intellij/docker/view/registry/node/DockerRegistryNodeBase;", "Lcom/intellij/docker/view/registry/node/DockerRegistryNodeWithLogging;", "Lcom/intellij/docker/registry/node/presentation/DockerRegistryTagInterface;", "Lcom/intellij/openapi/util/CheckedDisposable;", "configuration", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "tag", "Lcom/intellij/docker/agent/registry/model/DockerRegistry$Tag;", "<init>", "(Lcom/intellij/docker/registry/DockerRegistryConfiguration;Lcom/intellij/docker/agent/registry/model/DockerRegistry$Tag;)V", "getConfiguration", "()Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "getTag", "()Lcom/intellij/docker/agent/registry/model/DockerRegistry$Tag;", "label", "", "getLabel", "()Ljava/lang/String;", "compareTo", "", "other", "panel", "Lcom/intellij/docker/view/details/DockerLogsPanel;", "getPanel", "()Lcom/intellij/docker/view/details/DockerLogsPanel;", "panel$delegate", "Lkotlin/Lazy;", "getNodeViewDescriptor", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getServices", "", "getViewDescriptor", "getServiceDescriptor", "service", "equals", "", "", "hashCode", "getRegistryId", "getNodeId", "myIsDisposed", "contentDisposable", "Lcom/intellij/openapi/Disposable;", "dispose", "", "isDisposed", "createContentBinding", "Lcom/intellij/ide/rpc/ComponentDirectTransferId;", "disposeContentBinding", "intellij.clouds.docker"})
@ApiStatus.Experimental
public final class DockerRegistryTagNode
extends DockerRegistryNodeBase
implements ServiceViewContributor<DockerRegistryTagNode>,
DockerRegistryNodeWithLogging,
DockerRegistryTagInterface,
CheckedDisposable {
    @NotNull
    private final DockerRegistryConfiguration configuration;
    @NotNull
    private final DockerRegistry.Tag tag;
    @NotNull
    private final String label;
    @NotNull
    private final Lazy panel$delegate;
    private boolean myIsDisposed;
    @Nullable
    private Disposable contentDisposable;

    public DockerRegistryTagNode(@NotNull DockerRegistryConfiguration configuration, @NotNull DockerRegistry.Tag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.configuration = configuration;
        this.tag = tag;
        this.label = this.tag.getLabel();
        this.panel$delegate = LazyKt.lazy(DockerRegistryTagNode::panel_delegate$lambda$0);
    }

    @Override
    @NotNull
    public DockerRegistryConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final DockerRegistry.Tag getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(@NotNull DockerRegistryNodeBase other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return NaturalComparator.INSTANCE.compare(this.getLabel(), other.getLabel());
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public DockerLogsPanel getPanel() {
        Lazy lazy = this.panel$delegate;
        return (DockerLogsPanel)lazy.getValue();
    }

    @Override
    @NotNull
    public ServiceViewDescriptor getNodeViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PresentationData presentation = new PresentationData(this.getLabel(), null, AllIcons.Nodes.Tag, null);
        return new DockerRegistryServiceViewDescriptor(this, presentation){
            final /* synthetic */ DockerRegistryTagNode this$0;
            final /* synthetic */ PresentationData $presentation;
            {
                this.this$0 = $receiver;
                this.$presentation = $presentation;
            }

            public JPanel getContentComponent() {
                return this.this$0.getPanel().getMainPanel();
            }

            public PresentationData getPresentation() {
                return this.$presentation;
            }
        };
    }

    @NotNull
    public List<DockerRegistryTagNode> getServices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ServiceViewDescriptor)new SimpleServiceViewDescriptor("Tag", null);
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull DockerRegistryTagNode service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return (ServiceViewDescriptor)new SimpleServiceViewDescriptor("", null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DockerRegistryTagNode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.getConfiguration()), (Object)((Object)((DockerRegistryTagNode)other).getConfiguration()))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)((DockerRegistryTagNode)other).tag)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getLabel(), (Object)((DockerRegistryTagNode)other).getLabel());
    }

    public int hashCode() {
        int result2 = this.getConfiguration().hashCode();
        result2 = 31 * result2 + this.tag.hashCode();
        result2 = 31 * result2 + this.getLabel().hashCode();
        return result2;
    }

    @NotNull
    public String getRegistryId() {
        return this.tag.getRepository().getNamespace().getRegistry().getId();
    }

    @NotNull
    public String getNodeId() {
        return this.tag.getId();
    }

    public void dispose() {
        this.myIsDisposed = true;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @RequiresEdt
    @NotNull
    public final ComponentDirectTransferId createContentBinding() {
        Disposable disposable;
        this.disposeContentBinding();
        JPanel component = this.getPanel().getMainPanel();
        Disposable disposable2 = Disposer.newDisposable((Disposable)((Disposable)this));
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        this.contentDisposable = disposable = disposable2;
        return ComponentDirectTransferIdKt.setupTransfer((JComponent)component, (Disposable)disposable);
    }

    @RequiresEdt
    public final void disposeContentBinding() {
        block0: {
            Disposable disposable = this.contentDisposable;
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
            this.contentDisposable = null;
        }
    }

    private static final DockerLogsPanel panel_delegate$lambda$0() {
        return new DockerLogsPanel();
    }
}

