/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.ui.NameMapping;
import com.intellij.swagger.core.ui.NameSuggester;
import com.intellij.swagger.core.ui.ReferenceData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\r2\u000b\u0010\u0014\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0015H\u0002J(\u0010\u0016\u001a\f0\u0004\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/swagger/core/ui/NameSuggester;", "", "knownNames", "", "", "topLevelFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/util/Collection;Lcom/intellij/openapi/vfs/VirtualFile;)V", "allKnownNames", "", "nameMappings", "", "Lcom/intellij/swagger/core/ui/ReferenceData;", "Lcom/intellij/swagger/core/ui/NameMapping;", "createNameMapping", "referenceData", "createNameMapping$intellij_swagger_core", "doCreateNameMapping", "suggestUniqueName", "originalObjectOrFileName", "Lcom/intellij/openapi/util/NlsSafe;", "getOriginalDefinitionName", "Lorg/jetbrains/annotations/NotNull;", "pathSegments", "", "getNameForReference", "getNameForReference$intellij_swagger_core", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nNameSuggester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameSuggester.kt\ncom/intellij/swagger/core/ui/NameSuggester\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,57:1\n128#2,2:58\n*S KotlinDebug\n*F\n+ 1 NameSuggester.kt\ncom/intellij/swagger/core/ui/NameSuggester\n*L\n35#1:58,2\n*E\n"})
public final class NameSuggester {
    @NotNull
    private final VirtualFile topLevelFile;
    @NotNull
    private final Set<String> allKnownNames;
    @NotNull
    private final Map<ReferenceData, NameMapping> nameMappings;

    public NameSuggester(@NotNull Collection<String> knownNames, @NotNull VirtualFile topLevelFile) {
        Intrinsics.checkNotNullParameter(knownNames, (String)"knownNames");
        Intrinsics.checkNotNullParameter((Object)topLevelFile, (String)"topLevelFile");
        this.topLevelFile = topLevelFile;
        this.allKnownNames = CollectionsKt.toMutableSet((Iterable)knownNames);
        this.nameMappings = new LinkedHashMap();
    }

    @NotNull
    public final NameMapping createNameMapping$intellij_swagger_core(@NotNull ReferenceData referenceData) {
        Intrinsics.checkNotNullParameter((Object)referenceData, (String)"referenceData");
        NameMapping existingMapping = this.nameMappings.get(referenceData);
        if (existingMapping != null) {
            return existingMapping;
        }
        NameMapping nameMapping = this.doCreateNameMapping(referenceData);
        this.nameMappings.put(referenceData, nameMapping);
        return nameMapping;
    }

    private final NameMapping doCreateNameMapping(ReferenceData referenceData) {
        String[] stringArray = new String[]{"/"};
        List pathSegments = StringsKt.split$default((CharSequence)referenceData.getTargetPath(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String originalObjectOrFileName = this.getOriginalDefinitionName(pathSegments, referenceData);
        String uniqueName = this.suggestUniqueName(referenceData, originalObjectOrFileName);
        NameMapping nameMapping = new NameMapping(referenceData.getTargetPath(), pathSegments, originalObjectOrFileName, uniqueName);
        return nameMapping;
    }

    /*
     * WARNING - void declaration
     */
    private final String suggestUniqueName(ReferenceData referenceData, String originalObjectOrFileName) {
        String string;
        if (Intrinsics.areEqual((Object)referenceData.getTargetFile(), (Object)this.topLevelFile)) {
            string = originalObjectOrFileName;
        } else {
            Object element$iv2;
            block3: {
                void $this$first$iv;
                Sequence sequence = SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object)originalObjectOrFileName), (Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)1, (Function1)suggestUniqueName.1.INSTANCE), arg_0 -> NameSuggester.suggestUniqueName$lambda$0(originalObjectOrFileName, arg_0)));
                Set<String> set = this.allKnownNames;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    String p0 = (String)element$iv2;
                    boolean bl = false;
                    if (!set.add(p0)) continue;
                    break block3;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            string = (String)element$iv2;
        }
        return string;
    }

    private final String getOriginalDefinitionName(List<String> pathSegments, ReferenceData referenceData) {
        CharSequence charSequence = (CharSequence)CollectionsKt.lastOrNull(pathSegments);
        String string = charSequence == null || charSequence.length() == 0 ? FileUtil.getNameWithoutExtension((String)referenceData.getTargetFile().getName()) : (String)CollectionsKt.last(pathSegments);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Nullable
    public final NameMapping getNameForReference$intellij_swagger_core(@Nullable ReferenceData referenceData) {
        return this.nameMappings.get(referenceData);
    }

    private static final String suggestUniqueName$lambda$0(String $originalObjectOrFileName, int it) {
        return $originalObjectOrFileName + "_" + it;
    }
}

