/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.utils;

import com.intellij.swagger.core.visualEditing.utils.SwInterval;
import com.intellij.swagger.core.visualEditing.utils.SwIntervalTreeKt;
import com.intellij.swagger.core.visualEditing.utils.SwTreeSearchData;
import com.intellij.util.containers.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u001e\u0010\u001a\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00000\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0002J\n\u0010\u001f\u001a\u00020 H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;", "", "range", "Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;", "<init>", "(Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;)V", "getRange", "()Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;", "subtrees", "", "insert", "", "root", "newNode", "findSmallestSubtreeWithOffset", "Lcom/intellij/swagger/core/visualEditing/utils/SwTreeSearchData;", "offset", "", "smallestSubtreeStartOffset", "()Ljava/lang/Integer;", "findSmallestSubtreeFor", "findPositionToInsert", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition;", "wrapChildren", "position", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition$WrapExistingChild;", "wrapSubtree", "wrappedNodes", "", "wrapInto", "addSubtree", "toString", "", "SwTreeInsertPosition", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwIntervalTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwIntervalTree.kt\ncom/intellij/swagger/core/visualEditing/utils/SwIntervalTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n296#2,2:159\n1786#2,3:161\n777#2:164\n873#2,2:165\n*S KotlinDebug\n*F\n+ 1 SwIntervalTree.kt\ncom/intellij/swagger/core/visualEditing/utils/SwIntervalTree\n*L\n74#1:159,2\n78#1:161,3\n81#1:164\n81#1:165,2\n*E\n"})
public class SwIntervalTree {
    @NotNull
    private final SwInterval range;
    @NotNull
    private final List<SwIntervalTree> subtrees;

    public SwIntervalTree(@NotNull SwInterval range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.range = range;
        this.subtrees = (List)new SortedList(SwIntervalTreeKt.getASCENDING_TREE_COMPARATOR_BY_START_OFFSET());
    }

    @NotNull
    public final SwInterval getRange() {
        return this.range;
    }

    protected final void insert(@NotNull SwIntervalTree root, @NotNull SwInterval newNode) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
        SwTreeInsertPosition position = this.findPositionToInsert(root, newNode);
        if (position instanceof SwTreeInsertPosition.AddChildTo) {
            this.addSubtree(((SwTreeInsertPosition.AddChildTo)position).getParent(), newNode);
        } else if (position instanceof SwTreeInsertPosition.WrapExistingChild) {
            this.wrapChildren((SwTreeInsertPosition.WrapExistingChild)position, newNode);
        }
    }

    @NotNull
    protected final SwTreeSearchData findSmallestSubtreeWithOffset(int offset) {
        SwIntervalTree smallestContainingNode;
        SwIntervalTree swIntervalTree = smallestContainingNode = this.findSmallestSubtreeFor(this, offset);
        Integer firstSubtreeStartOrNull = swIntervalTree != null ? swIntervalTree.smallestSubtreeStartOffset() : null;
        SwIntervalTree swIntervalTree2 = smallestContainingNode;
        return new SwTreeSearchData(swIntervalTree2 != null ? swIntervalTree2.range : null, firstSubtreeStartOrNull);
    }

    private final Integer smallestSubtreeStartOffset() {
        Object object = (SwIntervalTree)CollectionsKt.firstOrNull(this.subtrees);
        return object != null && (object = ((SwIntervalTree)object).range) != null ? Integer.valueOf(((SwInterval)object).getStart()) : null;
    }

    private final SwIntervalTree findSmallestSubtreeFor(SwIntervalTree root, int offset) {
        if (!root.range.contains(offset)) {
            return null;
        }
        int targetSubtreeIndex = CollectionsKt.binarySearch$default(root.subtrees, (int)0, (int)0, arg_0 -> SwIntervalTree.findSmallestSubtreeFor$lambda$0(offset, arg_0), (int)3, null);
        return targetSubtreeIndex >= 0 ? this.findSmallestSubtreeFor(root.subtrees.get(targetSubtreeIndex), offset) : root;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final SwTreeInsertPosition findPositionToInsert(SwIntervalTree root, SwInterval newNode) {
        block12: {
            block11: {
                if (newNode.isSameAs(root.range)) {
                    return SwTreeInsertPosition.Skip.INSTANCE;
                }
                if (root.range.isInsideMaybeOverlap(newNode)) {
                    return new SwTreeInsertPosition.WrapExistingChild(null, SetsKt.setOf((Object)root));
                }
                $this$firstOrNull$iv = root.subtrees;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    subtree = (SwIntervalTree)element$iv;
                    $i$a$-firstOrNull-SwIntervalTree$findPositionToInsert$targetSubtree$1 = false;
                    if (!newNode.isInsideMaybeOverlap(subtree.range)) continue;
                    v0 = element$iv;
                    break block11;
                }
                v0 = null;
            }
            v1 = targetSubtree = (SwIntervalTree)v0;
            if (v1 != null) {
                return this.findPositionToInsert(v1, newNode);
            }
            if (!newNode.isInsideMaybeOverlap(root.range)) ** GOTO lbl-1000
            $this$all$iv = root.subtrees;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v2 = true;
            } else {
                for (Iterable element$iv : $this$all$iv) {
                    subtree = (SwIntervalTree)element$iv /* !! */ ;
                    $i$a$-all-SwIntervalTree$findPositionToInsert$outsideOfAllSubtrees$1 = false;
                    if (newNode.isStrictlyOutside(subtree.range)) continue;
                    v2 = false;
                    break block12;
                }
                v2 = true;
            }
        }
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = outsideOfAllSubtrees = false;
        }
        if (outsideOfAllSubtrees) {
            return new SwTreeInsertPosition.AddChildTo(root);
        }
        $this$filter$iv = root.subtrees;
        $i$f$filter = false;
        element$iv /* !! */  = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            subtree = (SwIntervalTree)element$iv$iv;
            $i$a$-filter-SwIntervalTree$findPositionToInsert$subtreesToWrap$1 = false;
            if (!subtree.range.isInsideMaybeOverlap(newNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        subtreesToWrap = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return ((Collection)subtreesToWrap).isEmpty() == false != false ? (SwTreeInsertPosition)new SwTreeInsertPosition.WrapExistingChild(root, subtreesToWrap) : (SwTreeInsertPosition)SwTreeInsertPosition.Skip.INSTANCE;
    }

    private final void wrapChildren(SwTreeInsertPosition.WrapExistingChild position, SwInterval newNode) {
        block1: {
            Object object;
            SwIntervalTree newChild = this.wrapSubtree((Collection<? extends SwIntervalTree>)position.getOldChildren(), newNode);
            Object object2 = position.getOldParent();
            if (object2 != null && (object2 = ((SwIntervalTree)object2).subtrees) != null) {
                object2.removeAll((Collection)position.getOldChildren());
            }
            if ((object = position.getOldParent()) == null || (object = ((SwIntervalTree)object).subtrees) == null) break block1;
            object.add(newChild);
        }
    }

    private final SwIntervalTree wrapSubtree(Collection<? extends SwIntervalTree> wrappedNodes, SwInterval wrapInto) {
        SwIntervalTree swIntervalTree;
        SwIntervalTree $this$wrapSubtree_u24lambda_u240 = swIntervalTree = new SwIntervalTree(wrapInto);
        boolean bl = false;
        if (!wrappedNodes.isEmpty()) {
            $this$wrapSubtree_u24lambda_u240.subtrees.addAll(wrappedNodes);
        }
        return swIntervalTree;
    }

    private final SwIntervalTree addSubtree(SwIntervalTree root, SwInterval newNode) {
        SwIntervalTree swIntervalTree;
        SwIntervalTree $this$addSubtree_u24lambda_u240 = swIntervalTree = root;
        boolean bl = false;
        $this$addSubtree_u24lambda_u240.subtrees.add(new SwIntervalTree(newNode));
        return swIntervalTree;
    }

    @NotNull
    public String toString() {
        return "Tree '" + super.toString() + "': from=" + this.range.getStart() + ", to=" + this.range.getEnd() + "; children count: " + this.subtrees.size();
    }

    private static final int findSmallestSubtreeFor$lambda$0(int $offset, SwIntervalTree node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.range.getStart() > $offset ? 1 : (node.range.getEnd() < $offset ? -1 : 0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition;", "", "<init>", "()V", "Skip", "WrapExistingChild", "AddChildTo", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition$AddChildTo;", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition$Skip;", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition$WrapExistingChild;", "intellij.swagger.core"})
    private static abstract sealed class SwTreeInsertPosition {
        private SwTreeInsertPosition() {
        }

        public /* synthetic */ SwTreeInsertPosition(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition$AddChildTo;", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition;", "parent", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;", "<init>", "(Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;)V", "getParent", "()Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;", "intellij.swagger.core"})
        public static final class AddChildTo
        extends SwTreeInsertPosition {
            @NotNull
            private final SwIntervalTree parent;

            public AddChildTo(@NotNull SwIntervalTree parent) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                super(null);
                this.parent = parent;
            }

            @NotNull
            public final SwIntervalTree getParent() {
                return this.parent;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0083\u0004J\n\u0010\b\u001a\u00020\tH\u00d6\u0081\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition$Skip;", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.swagger.core"})
        public static final class Skip
        extends SwTreeInsertPosition {
            @NotNull
            public static final Skip INSTANCE = new Skip();

            private Skip() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Skip";
            }

            public int hashCode() {
                return -1515395370;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Skip)) {
                    return false;
                }
                Skip cfr_ignored_0 = (Skip)other;
                return true;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition$WrapExistingChild;", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree$SwTreeInsertPosition;", "oldParent", "Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;", "oldChildren", "", "<init>", "(Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;Ljava/util/Set;)V", "getOldParent", "()Lcom/intellij/swagger/core/visualEditing/utils/SwIntervalTree;", "getOldChildren", "()Ljava/util/Set;", "intellij.swagger.core"})
        public static final class WrapExistingChild
        extends SwTreeInsertPosition {
            @Nullable
            private final SwIntervalTree oldParent;
            @NotNull
            private final Set<SwIntervalTree> oldChildren;

            public WrapExistingChild(@Nullable SwIntervalTree oldParent, @NotNull Set<? extends SwIntervalTree> oldChildren) {
                Intrinsics.checkNotNullParameter(oldChildren, (String)"oldChildren");
                super(null);
                this.oldParent = oldParent;
                this.oldChildren = oldChildren;
            }

            @Nullable
            public final SwIntervalTree getOldParent() {
                return this.oldParent;
            }

            @NotNull
            public final Set<SwIntervalTree> getOldChildren() {
                return this.oldChildren;
            }
        }
    }
}

