/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.utils;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.swagger.core.visualEditing.SwVisualEditingActionsService;
import com.intellij.swagger.core.visualEditing.utils.SwInterval;
import com.intellij.swagger.core.visualEditing.utils.SwIntervalTreeBlockingHolder;
import com.intellij.swagger.core.visualEditing.utils.SwTreeSearchData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a8\u0006\r"}, d2={"rememberHighlightedRanges", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "highlightedRanges", "", "Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;", "findSmallestSubtreeFor", "Lcom/intellij/swagger/core/visualEditing/utils/SwTreeSearchData;", "line", "", "intellij.swagger.core"})
public final class SwIntervalTreeUtilsKt {
    public static final void rememberHighlightedRanges(@NotNull Document document, @NotNull Project project, @NotNull List<SwInterval> highlightedRanges) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(highlightedRanges, (String)"highlightedRanges");
        SwVisualEditingActionsService actionsService = SwVisualEditingActionsService.Companion.getInstance(project);
        actionsService.getOrCreateIntervalTree(document).insertUnderLock(highlightedRanges);
        actionsService.disposeOutdatedTrees(document);
    }

    @Nullable
    public static final SwTreeSearchData findSmallestSubtreeFor(@NotNull Document document, @NotNull Project project, int line) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwIntervalTreeBlockingHolder swIntervalTreeBlockingHolder = SwVisualEditingActionsService.Companion.getInstance(project).getUpToDateIntervalTreeOrNull(document);
        return swIntervalTreeBlockingHolder != null ? swIntervalTreeBlockingHolder.findSmallestSubtreeDataUnderLock(line) : null;
    }
}

