/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.backend.split.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.LanguageSubstitutionDocumentExtension;
import com.jetbrains.rdserver.document.BackendProjectAwareDocumentExtensionsProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/backend/split/lang/LanguageSubstitutionDocumentExtensionsProvider;", "Lcom/jetbrains/rdserver/document/BackendProjectAwareDocumentExtensionsProvider;", "<init>", "()V", "getExtensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.backend.split"})
public final class LanguageSubstitutionDocumentExtensionsProvider
implements BackendProjectAwareDocumentExtensionsProvider {
    @Override
    @NotNull
    public List<DocumentExtension> getExtensions(@NotNull ClientAppSession session, @NotNull Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile file2 = virtualFile;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Language language2 = language;
        if (Intrinsics.areEqual((Object)LanguageUtil.getFileTypeLanguage((FileType)fileType2), (Object)language2)) {
            return CollectionsKt.emptyList();
        }
        String string = language2.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return CollectionsKt.listOf((Object)new LanguageSubstitutionDocumentExtension(string));
    }
}

