/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver;

import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.codeWithMe.model.ConsoleViewContentTypeModel;
import com.jetbrains.codeWithMe.model.OutputMessage;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a$\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "extractObservableConsoleView", "Lcom/intellij/execution/ui/ObservableConsoleView;", "consoleView", "Lcom/intellij/execution/ui/ExecutionConsole;", "adviseOnTargetOutput", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "output", "Lcom/jetbrains/rd/util/reactive/ISignal;", "Lcom/jetbrains/codeWithMe/model/OutputMessage;", "adviseOnUserInput", "userInput", "", "intellij.platform.backend.split"})
public final class ConsoleViewUtilsKt {
    @NotNull
    private static final Logger logger;

    private static final ObservableConsoleView extractObservableConsoleView(ExecutionConsole consoleView) {
        ObservableConsoleView observableConsoleView;
        ExecutionConsole executionConsole = consoleView;
        if (executionConsole instanceof DuplexConsoleView) {
            ConsoleView consoleView2 = ((DuplexConsoleView)consoleView).getPrimaryConsoleView();
            Intrinsics.checkNotNullExpressionValue((Object)consoleView2, (String)"getPrimaryConsoleView(...)");
            observableConsoleView = ConsoleViewUtilsKt.extractObservableConsoleView((ExecutionConsole)consoleView2);
        } else if (executionConsole instanceof ConsoleViewWrapperBase) {
            ConsoleView consoleView3 = ((ConsoleViewWrapperBase)consoleView).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)consoleView3, (String)"getDelegate(...)");
            observableConsoleView = ConsoleViewUtilsKt.extractObservableConsoleView((ExecutionConsole)consoleView3);
        } else {
            observableConsoleView = executionConsole instanceof ObservableConsoleView ? (ObservableConsoleView)consoleView : null;
        }
        return observableConsoleView;
    }

    public static final void adviseOnTargetOutput(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull ExecutionConsole consoleView, @NotNull ISignal<OutputMessage> output2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter(output2, (String)"output");
        ObservableConsoleView console = ConsoleViewUtilsKt.extractObservableConsoleView(consoleView);
        if (console == null) {
            logger.error("session.consoleView is not an ObservableConsoleView, console class is " + consoleView.getClass());
            return;
        }
        ClientPermissionManager permissionManager = ClientPermissionManager.Companion.getInstance(session);
        console.addChangeListener(new ObservableConsoleView.ChangeListener(permissionManager, output2){
            final /* synthetic */ ClientPermissionManager $permissionManager;
            final /* synthetic */ ISignal<OutputMessage> $output;
            {
                this.$permissionManager = $permissionManager;
                this.$output = $output;
            }

            public void textAdded(String text, ConsoleViewContentType type) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                if (this.$permissionManager.getRunAccess() == RunAccessLevel.Disabled) {
                    return;
                }
                TextAttributesKey textAttributesKey = type.getAttributesKey();
                ConsoleViewContentTypeModel contentTypeModel = new ConsoleViewContentTypeModel(textAttributesKey != null ? textAttributesKey.getExternalName() : null);
                this.$output.fire((Object)new OutputMessage(text, contentTypeModel));
            }
        }, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    public static final void adviseOnUserInput(@NotNull Lifetime lifetime, @NotNull ExecutionConsole consoleView, @NotNull ISignal<String> userInput) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter(userInput, (String)"userInput");
        userInput.advise(lifetime, arg_0 -> ConsoleViewUtilsKt.adviseOnUserInput$lambda$0(consoleView, arg_0));
    }

    private static final Unit adviseOnUserInput$lambda$0(ExecutionConsole $consoleView, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if ($consoleView instanceof ConsoleViewImpl) {
            ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)$consoleView;
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.USER_INPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"USER_INPUT");
            consoleViewImpl.print(text, consoleViewContentType);
            TypedAction typedAction = TypedAction.getInstance();
            Editor editor = ((ConsoleViewImpl)$consoleView).getEditor();
            Intrinsics.checkNotNull((Object)editor);
            typedAction.actionPerformed(editor, '\n', DataContext.EMPTY_CONTEXT);
        } else {
            Intrinsics.checkNotNull((Object)$consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.ui.ConsoleView");
            ((ConsoleView)$consoleView).print(text + "\n", ConsoleViewContentType.USER_INPUT);
        }
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.jetbrains.rdserver.ConsoleViewUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ConsoleViewUtilsKt.logger = logger;
    }
}

