/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.connection;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorage;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorageEntry;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.ClientTerminatedInfo;
import com.jetbrains.codeWithMe.model.CodeWithMeConnectionExtModel;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.startup.ConnectionManagerProvider;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/connection/ClientTerminatedListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/codeWithMe/model/CodeWithMeConnectionExtModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nClientTerminatedListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientTerminatedListener.kt\ncom/jetbrains/rdserver/connection/ClientTerminatedListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,40:1\n23#2:41\n*S KotlinDebug\n*F\n+ 1 ClientTerminatedListener.kt\ncom/jetbrains/rdserver/connection/ClientTerminatedListener\n*L\n17#1:41\n*E\n"})
public final class ClientTerminatedListener
implements RootExtListener<CodeWithMeConnectionExtModel> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger logger;

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull CodeWithMeConnectionExtModel model2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        model2.getClientTerminated().advise(lifetime, ClientTerminatedListener::extensionCreated$lambda$0);
    }

    private static final Unit extensionCreated$lambda$0(ClientTerminatedInfo clientInfo) {
        Intrinsics.checkNotNullParameter((Object)clientInfo, (String)"clientInfo");
        logger.info("Client with id: " + clientInfo.getClientId() + " closed a project and terminate wire. Handle on a Server side.");
        String clientIdValue = clientInfo.getClientId();
        ClientId clientId = new ClientId(clientIdValue);
        RdServerConnectionManager connectionManager = ConnectionManagerProvider.Companion.getConnectionManager((ClientSession)ClientSessionsUtil.session((Application)ApplicationKt.getApplication(), (ClientId)clientId));
        WireStorage wireStorage = connectionManager.getWireStorage();
        WireStorageEntry wireEntry = wireStorage.getWireOrNull(clientId);
        if (wireEntry == null) {
            logger.warn("Unable to find wire for client with id: '" + clientInfo.getClientId() + "' that terminated the project on a client side.");
            return Unit.INSTANCE;
        }
        wireStorage.terminateWireIfExists(clientId);
        return Unit.INSTANCE;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ClientTerminatedListener.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/connection/ClientTerminatedListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

