/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EdtInvocationManager;
import com.jetbrains.rd.ide.model.HighlightingSettingsModel;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.platform.daemon.ModelUtilKt;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupModelBinder;
import com.jetbrains.rdserver.daemon.BackendMarkupModelBinderKt;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendProtocolMarkupModelExtensionHandler;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J!\u0010\r\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupModelBinder;", "Lcom/jetbrains/rdserver/daemon/BackendProtocolMarkupModelExtensionHandler;", "<init>", "()V", "consume", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "extensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "bind", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "bind$intellij_platform_backend_split", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendMarkupModelBinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendMarkupModelBinder.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupModelBinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n*L\n1#1,147:1\n1915#2,2:148\n11#3,12:150\n11#3,12:162\n11#3,12:174\n*S KotlinDebug\n*F\n+ 1 BackendMarkupModelBinder.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupModelBinder\n*L\n89#1:148,2\n102#1:150,12\n116#1:162,12\n136#1:174,12\n*E\n"})
public final class BackendMarkupModelBinder
implements BackendProtocolMarkupModelExtensionHandler {
    @Override
    public void consume(@NotNull Lifetime lifetime, @NotNull List<? extends MarkupModelExtension> extensions, @NotNull BackendMarkupModelContributor contributor) {
        MarkupModelEx markupModelEx;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (contributor instanceof BackendEditorMarkupModelContributor) {
            MarkupModel markupModel = ((BackendEditorMarkupModelContributor)contributor).getEditor().getMarkupModel();
            Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
            markupModelEx = (MarkupModelEx)markupModel;
        } else {
            markupModelEx = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)contributor.getDocument(), (Project)contributor.getProject(), (boolean)true);
            if (markupModelEx == null) {
                return;
            }
        }
        MarkupModelEx markupModel = markupModelEx;
        if (BackendMarkupModelBinderKt.access$getLOG$p().isDebugEnabled()) {
            BackendMarkupModelBinderKt.access$getLOG$p().debug("Binding BackendMarkupModelBinder " + contributor.getDocument());
        }
        this.bind$intellij_platform_backend_split(contributor, lifetime, markupModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void bind$intellij_platform_backend_split(@NotNull BackendMarkupModelContributor $this$bind, @NotNull Lifetime lifetime, @NotNull MarkupModelEx markupModel) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$bind, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)markupModel, (String)"markupModel");
        MarkupModelListener listener2 = new MarkupModelListener(lifetime, $this$bind){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ BackendMarkupModelContributor $this_bind;
            {
                this.$lifetime = $lifetime;
                this.$this_bind = $receiver;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isAlive() {
                if (!RLifetimeKt.isAlive((Lifetime)this.$lifetime)) return false;
                if (this.$this_bind.getAppSession().isDisposed()) return false;
                Project project = this.$this_bind.getProject();
                if (project == null) return true;
                if (!project.isDisposed()) return true;
                return false;
            }

            public void attributesChanged(RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                EdtInvocationManager.invokeLaterIfNeeded(() -> bind.listener.1.attributesChanged$lambda$0(this, highlighter, this.$this_bind));
            }

            public void afterRemoved(RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                EdtInvocationManager.invokeLaterIfNeeded(() -> bind.listener.1.afterRemoved$lambda$1(this, this.$this_bind, highlighter));
            }

            public void afterAdded(RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                EdtInvocationManager.invokeLaterIfNeeded(() -> bind.listener.1.afterAdded$lambda$2(this, highlighter, this.$this_bind));
            }

            private static final Unit attributesChanged$lambda$0$0(bind.listener.1 this$0, RangeHighlighterEx $highlighter, BackendMarkupModelContributor $this_bind) {
                if (this$0.isAlive() && $highlighter.isValid()) {
                    $this_bind.addOrUpdateRangeMarkers$intellij_platform_backend_split((Iterable)new SmartList((Object)$highlighter));
                }
                return Unit.INSTANCE;
            }

            private static final void attributesChanged$lambda$0(bind.listener.1 this$0, RangeHighlighterEx $highlighter, BackendMarkupModelContributor $this_bind) {
                ActionsKt.runReadAction(() -> bind.listener.1.attributesChanged$lambda$0$0(this$0, $highlighter, $this_bind));
            }

            private static final Unit afterRemoved$lambda$1$0(bind.listener.1 this$0, BackendMarkupModelContributor $this_bind, RangeHighlighterEx $highlighter) {
                if (this$0.isAlive()) {
                    $this_bind.removeRangeMarkers((Iterable)new SmartList((Object)$highlighter));
                }
                return Unit.INSTANCE;
            }

            private static final void afterRemoved$lambda$1(bind.listener.1 this$0, BackendMarkupModelContributor $this_bind, RangeHighlighterEx $highlighter) {
                ActionsKt.runReadAction(() -> bind.listener.1.afterRemoved$lambda$1$0(this$0, $this_bind, $highlighter));
            }

            private static final Unit afterAdded$lambda$2$0(bind.listener.1 this$0, RangeHighlighterEx $highlighter, BackendMarkupModelContributor $this_bind) {
                if (this$0.isAlive() && $highlighter.isValid()) {
                    $this_bind.addOrUpdateRangeMarkers$intellij_platform_backend_split((Iterable)new SmartList((Object)$highlighter));
                }
                return Unit.INSTANCE;
            }

            private static final void afterAdded$lambda$2(bind.listener.1 this$0, RangeHighlighterEx $highlighter, BackendMarkupModelContributor $this_bind) {
                ActionsKt.runReadAction(() -> bind.listener.1.afterAdded$lambda$2$0(this$0, $highlighter, $this_bind));
            }
        };
        RangeHighlighter[] rangeHighlighterArray = markupModel.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Iterable iterable = CollectionsKt.chunked((Iterable)ArraysKt.asIterable((Object[])rangeHighlighterArray), (int)200);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            $this$bind.addOrUpdateRangeMarkers$intellij_platform_backend_split(it);
        }
        if (BackendMarkupModelBinderKt.access$getLOG$p().isDebugEnabled()) {
            BackendMarkupModelBinderKt.access$getLOG$p().debug("Registering MarkupModelListener");
        }
        markupModel.addMarkupModelListener(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), listener2);
        ClientProjectSession clientProjectSession = $this$bind.getProjectSession();
        if (clientProjectSession == null) {
            return;
        }
        ClientProjectSession session = clientProjectSession;
        Boxed guard = new Boxed((Object)false);
        IOptProperty settingsModel = $this$bind.getProtocolMarkupModel().getDaemon().getSettings();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)session.getProject()).getPsiFile($this$bind.getDocument());
        if (psiFile != null) {
            void $this$usingTrueFlag_u24default$iv;
            PsiFile it = psiFile;
            boolean bl = false;
            Boxed boxed = guard;
            KMutableProperty1 flag$iv = (KMutableProperty1)bind.2.1.INSTANCE;
            boolean set$iv = true;
            boolean $i$f$usingTrueFlag = false;
            if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
                boolean bl2 = false;
                FileHighlightingSetting fileHighlightingSetting = HighlightingSettingsPerFile.getInstance((Project)session.getProject()).getHighlightingSettingForRoot((PsiElement)it);
                Intrinsics.checkNotNullExpressionValue((Object)fileHighlightingSetting, (String)"getHighlightingSettingForRoot(...)");
                settingsModel.set((Object)ModelUtilKt.toModel((FileHighlightingSetting)fileHighlightingSetting));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
            }
        }
        settingsModel.advise(lifetime, arg_0 -> BackendMarkupModelBinder.bind$lambda$2(guard, session, $this$bind, settingsModel, arg_0));
        MessageBusConnection messageBusConnection = session.getProject().getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        Topic topic = FileHighlightingSettingListener.SETTING_CHANGE;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"SETTING_CHANGE");
        messageBusConnection.subscribe(topic, (arg_0, arg_1) -> BackendMarkupModelBinder.bind$lambda$3(session, $this$bind, guard, settingsModel, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit bind$lambda$2(Boxed $guard, ClientProjectSession $session, BackendMarkupModelContributor $this_bind, IOptProperty $settingsModel, HighlightingSettingsModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (((Boolean)$guard.getValue()).booleanValue()) {
            return Unit.INSTANCE;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$session.getProject()).getPsiFile($this_bind.getDocument());
        if (psiFile == null) {
            return Unit.INSTANCE;
        }
        PsiFile psiFile2 = psiFile;
        if (!ClientPermissionManager.Companion.getInstance($session).isWritable($this_bind.getDocument())) {
            void $this$usingTrueFlag_u24default$iv;
            FileHighlightingSetting fileHighlightingSetting = HighlightingSettingsPerFile.getInstance((Project)$session.getProject()).getHighlightingSettingForRoot((PsiElement)psiFile2);
            Intrinsics.checkNotNullExpressionValue((Object)fileHighlightingSetting, (String)"getHighlightingSettingForRoot(...)");
            HighlightingSettingsModel settings = ModelUtilKt.toModel((FileHighlightingSetting)fileHighlightingSetting);
            Boxed boxed = $guard;
            KMutableProperty1 flag$iv = (KMutableProperty1)bind.3.1.INSTANCE;
            boolean set$iv = true;
            boolean $i$f$usingTrueFlag = false;
            if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
                boolean bl = false;
                if (it.getState() != settings.getState()) {
                    $settingsModel.set((Object)settings);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
            }
            return Unit.INSTANCE;
        }
        FileHighlightingSetting fileHighlightingSetting = HighlightingSettingsPerFile.getInstance((Project)$session.getProject()).getHighlightingSettingForRoot((PsiElement)psiFile2);
        Intrinsics.checkNotNullExpressionValue((Object)fileHighlightingSetting, (String)"getHighlightingSettingForRoot(...)");
        FileHighlightingSetting settings = fileHighlightingSetting;
        FileHighlightingSetting newSettings = ModelUtilKt.fromModel((HighlightingSettingsModel)it);
        if (settings == newSettings) {
            return Unit.INSTANCE;
        }
        HighlightLevelUtil.forceRootHighlighting((PsiElement)((PsiElement)psiFile2), (FileHighlightingSetting)newSettings);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void bind$lambda$3(ClientProjectSession $session, BackendMarkupModelContributor $this_bind, Boxed $guard, IOptProperty $settingsModel, PsiElement root, FileHighlightingSetting change) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$session.getProject()).getPsiFile($this_bind.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        if (Intrinsics.areEqual((Object)root.getContainingFile(), (Object)psiFile2)) {
            void $this$usingTrueFlag_u24default$iv;
            Boxed boxed = $guard;
            KMutableProperty1 flag$iv = (KMutableProperty1)bind.4.1.INSTANCE;
            boolean set$iv = true;
            boolean $i$f$usingTrueFlag = false;
            if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            try {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
                boolean bl = false;
                HighlightingSettingsModel oldValue = (HighlightingSettingsModel)$settingsModel.getValueOrNull();
                HighlightingSettingsModel newValue = ModelUtilKt.toModel((FileHighlightingSetting)change);
                HighlightingSettingsModel highlightingSettingsModel = oldValue;
                if ((highlightingSettingsModel != null ? highlightingSettingsModel.getState() : null) != newValue.getState()) {
                    $settingsModel.set((Object)newValue);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
            }
        }
    }
}

