/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.diagnostics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.ide.model.FileTransmissionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.FileTransmissionRequest;
import com.jetbrains.rd.platform.codeWithMe.diagnostics.FileTransmissionHandler;
import com.jetbrains.rd.platform.codeWithMe.diagnostics.FileTransmissionService;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/diagnostics/BackendFileTransmissionHost;", "Lcom/jetbrains/rd/platform/codeWithMe/diagnostics/FileTransmissionService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "protocol", "Lcom/jetbrains/rd/framework/Protocol;", "handler", "Lcom/jetbrains/rd/platform/codeWithMe/diagnostics/FileTransmissionHandler;", "sendFileAsync", "Ljava/util/concurrent/CompletableFuture;", "", "file", "Ljava/io/File;", "request", "Lcom/jetbrains/rd/ide/model/FileTransmissionRequest;", "receiveFileAsync", "fetchFile", "remoteFileSystemIndependentPath", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.backend.split"})
public final class BackendFileTransmissionHost
extends FileTransmissionService {
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final FileTransmissionHandler handler;

    public BackendFileTransmissionHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        ThreadingAssertions.assertEventDispatchThread();
        this.protocol = RemoteSessionKt.getProtocol(this.session);
        this.handler = new FileTransmissionHandler(this.getServiceLifetime(), FileTransmissionModel_GeneratedKt.getFileTransmissionModel((IProtocol)((IProtocol)this.protocol)));
    }

    @NotNull
    public CompletableFuture<Unit> sendFileAsync(@NotNull File file2, @NotNull FileTransmissionRequest request) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (CompletableFuture)ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendFileTransmissionHost.sendFileAsync$lambda$0(this, file2, request));
    }

    @NotNull
    public CompletableFuture<File> receiveFileAsync(@NotNull FileTransmissionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (CompletableFuture)ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendFileTransmissionHost.receiveFileAsync$lambda$0(this, request));
    }

    @Nullable
    public Object fetchFile(@NotNull String remoteFileSystemIndependentPath, @NotNull Continuation<? super File> $completion) {
        return this.handler.fetchFile(remoteFileSystemIndependentPath, $completion);
    }

    private static final CompletableFuture sendFileAsync$lambda$0(BackendFileTransmissionHost this$0, File $file, FileTransmissionRequest $request) {
        return this$0.handler.sendFileAsync($file, $request);
    }

    private static final CompletableFuture receiveFileAsync$lambda$0(BackendFileTransmissionHost this$0, FileTransmissionRequest $request) {
        return this$0.handler.receiveFileAsync($request);
    }
}

