/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.util;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Alarm;
import com.jetbrains.rd.platform.codeWithMe.lux.util.ReflectionKt;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.sun.java.swing.SwingUtilities3;
import java.awt.Window;
import java.awt.image.BufferStrategy;
import java.lang.reflect.Constructor;
import java.time.Instant;
import java.util.List;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/lux/util/LuxFlushAwareAlarm;", "Lcom/intellij/util/Alarm;", "adapter", "Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "<init>", "(Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;)V", "lastFlushTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "notifyFlush", "", "inspect", "schedule", "delayMillis", "", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxFlushAwareAlarm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxFlushAwareAlarm.kt\ncom/jetbrains/rdserver/lux/util/LuxFlushAwareAlarm\n+ 2 reflection.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/util/ReflectionKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n47#2,2:110\n49#2,2:113\n47#2,2:115\n49#2,2:118\n1#3:112\n1#3:117\n1#3:120\n13#4:121\n*S KotlinDebug\n*F\n+ 1 LuxFlushAwareAlarm.kt\ncom/jetbrains/rdserver/lux/util/LuxFlushAwareAlarm\n*L\n55#1:110,2\n55#1:113,2\n58#1:115,2\n58#1:118,2\n55#1:112\n58#1:117\n31#1:121\n*E\n"})
public final class LuxFlushAwareAlarm
extends Alarm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LuxComponentAdapter adapter;
    private Instant lastFlushTime;
    @NotNull
    private static final String FLUSH_AWARE_ENABLED_KEY = "lux.flushAware.enabled";
    @NotNull
    private static final String FLUSH_AWARE_INFORM_KEY = "lux.flushAware.informEnabled";
    @NotNull
    private static final String FLUSH_AWARE_INTERVAL_KEY = "lux.flushAware.intervalMs";
    @NotNull
    private static final String FLUSH_AWARE_FIRST_FLUSH_DELAY_KEY = "lux.flushAware.firstFlushDelayMs";
    @NotNull
    private static final String FLUSH_AWARE_FORCE_FLUSH_KEY = "lux.flushAware.forceFlush";
    @NotNull
    private static final String FLUSH_AWARE_AUTO_RECOVERY = "lux.flushAware.autoRecovery";
    private static final boolean flushAwareEnabled;
    private static final boolean flushAwareInformEnabled;
    private static final int flushAwareIntervalMs;
    private static final int flushAwareFirstFlushDelayMs;
    private static final boolean flushAwareForceFlush;
    private static final boolean flushAwareAutoRecovery;
    @NotNull
    private static final Logger logger;

    public LuxFlushAwareAlarm(@NotNull LuxComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super(adapter.getDisposable());
        this.adapter = adapter;
        this.lastFlushTime = Instant.now();
        if (flushAwareEnabled) {
            this.schedule(flushAwareFirstFlushDelayMs);
        }
    }

    public final void notifyFlush() {
        this.lastFlushTime = Instant.now();
    }

    /*
     * WARNING - void declaration
     */
    private final void inspect() {
        Instant now = Instant.now();
        long msFromLastFlush = now.toEpochMilli() - this.lastFlushTime.toEpochMilli();
        int commands = this.adapter.drawOperationsCollected();
        if (this.adapter.isBound() && commands > 0 && msFromLastFlush > (long)flushAwareIntervalMs) {
            Boolean useTrueBuffering;
            KProperty1 property$iv;
            Object v0;
            Object object;
            void $this$getFieldValue$iv;
            RepaintManager repaintManager;
            JRootPane rootPane;
            Window window;
            block17: {
                window = this.adapter.getWindow();
                Intrinsics.checkNotNull((Object)window, (String)"null cannot be cast to non-null type javax.swing.RootPaneContainer");
                rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                repaintManager = RepaintManager.currentManager(window);
                Intrinsics.checkNotNull((Object)repaintManager);
                RepaintManager repaintManager2 = repaintManager;
                String fieldName$iv = "paintManager";
                boolean $i$f$getFieldValue = false;
                object = ((Iterable)KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass($this$getFieldValue$iv.getClass()))).iterator();
                while (object.hasNext()) {
                    Object t = object.next();
                    KProperty1 it$iv = (KProperty1)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it$iv.getName(), (Object)fieldName$iv)) continue;
                    v0 = t;
                    break block17;
                }
                v0 = null;
            }
            Object var17_22 = v0;
            KProperty1 kProperty1 = property$iv = var17_22 instanceof KProperty1 ? (KProperty1)var17_22 : null;
            if (kProperty1 != null) {
                KCallablesJvm.setAccessible((KCallable)((KCallable)kProperty1), (boolean)true);
            }
            KProperty1 kProperty12 = property$iv;
            Object object2 = kProperty12 != null ? kProperty12.get((Object)$this$getFieldValue$iv) : null;
            if (!(object2 instanceof Object)) {
                object2 = null;
            }
            Intrinsics.checkNotNull((Object)object2);
            String string = object2.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String[] stringArray = new String[]{"."};
            String paintManagerClassName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            BufferStrategy bufferStrategy = window.getBufferStrategy();
            boolean vsyncRequested = SwingUtilities3.isVsyncRequested(window);
            JRootPane jRootPane = rootPane;
            if (jRootPane != null) {
                KProperty1 property$iv2;
                Object v6;
                void $this$getFieldValue$iv2;
                block18: {
                    JRootPane $i$f$getFieldValue = jRootPane;
                    String fieldName$iv = "useTrueDoubleBuffering";
                    boolean $i$f$getFieldValue2 = false;
                    for (Object e : (Iterable)KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass($this$getFieldValue$iv2.getClass()))) {
                        KProperty1 it$iv = (KProperty1)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it$iv.getName(), (Object)fieldName$iv)) continue;
                        v6 = e;
                        break block18;
                    }
                    v6 = null;
                }
                Object var19_27 = v6;
                KProperty1 kProperty13 = property$iv2 = var19_27 instanceof KProperty1 ? (KProperty1)var19_27 : null;
                if (kProperty13 != null) {
                    KCallablesJvm.setAccessible((KCallable)((KCallable)kProperty13), (boolean)true);
                }
                KProperty1 kProperty14 = property$iv2;
                Object object3 = kProperty14 != null ? kProperty14.get((Object)$this$getFieldValue$iv2) : null;
                if (!(object3 instanceof Boolean)) {
                    object3 = null;
                }
                v10 = (Boolean)object3;
            } else {
                v10 = useTrueBuffering = null;
            }
            if (flushAwareInformEnabled) {
                String message = StringsKt.trimIndent((String)("\n        No flush commands for " + msFromLastFlush + " ms. " + commands + " commands stuck. " + (flushAwareForceFlush ? "Force flush." : "") + "\n        To disable this message set system property lux.flushAware.informEnabled to false.\n        To change force flush interval set system property lux.flushAware.intervalMs to desired value in ms.\n        Possible reasons: disabled double buffering, disabled VSync for host window, disabled true double buffering for root pane or just slow rendering.\n        PaintManager=" + paintManagerClassName + "\n        BufferStrategy=" + bufferStrategy + "\n        VSync: " + vsyncRequested + "\n        True double buffering for rootPane: " + useTrueBuffering + "\n        "));
                logger.warn(message);
            }
            if (flushAwareAutoRecovery) {
                logger.info("Trying to fix...");
                logger.info("Checking paint manager...");
                if (!Intrinsics.areEqual((Object)paintManagerClassName, (Object)"BufferStrategyPaintManager")) {
                    logger.info("Wrong paint manager. Setting it to BufferStrategyPaintManager");
                    Object $this$inspect_u24lambda_u240 = object = Class.forName("javax.swing.BufferStrategyPaintManager").getDeclaredConstructor(new Class[0]);
                    boolean bl = false;
                    ((Constructor)$this$inspect_u24lambda_u240).setAccessible(true);
                    Object bufferStrategyPaintManager = ((Constructor)object).newInstance(new Object[0]);
                    ReflectionKt.setField((Object)repaintManager, (String)"paintManager", bufferStrategyPaintManager);
                }
                logger.info("Checking buffer strategy...");
                if (bufferStrategy == null) {
                    logger.info("Buffer strategy is null. Creating new one.");
                    window.createBufferStrategy(2);
                }
                logger.info("Checking VSync...");
                if (!vsyncRequested) {
                    logger.info("VSync is disabled. Enabling it.");
                    SwingUtilities3.setVsyncRequested(window, true);
                }
                logger.info("Checking true double buffering...");
                if (Intrinsics.areEqual(useTrueBuffering, (Object)false)) {
                    logger.info("True double buffering is disabled. Enabling it.");
                    ReflectionKt.setField((Object)rootPane, (String)"useTrueDoubleBuffering", (Object)true);
                }
            }
            if (flushAwareForceFlush) {
                this.adapter.flush();
            }
        }
        if (!this.isDisposed()) {
            this.schedule(flushAwareIntervalMs);
        }
    }

    private final void schedule(int delayMillis) {
        this.addRequest(this::inspect, delayMillis, ModalityState.any());
    }

    static {
        String string = System.getProperty(FLUSH_AWARE_ENABLED_KEY);
        flushAwareEnabled = !(string != null ? !Boolean.parseBoolean(string) : false);
        String string2 = System.getProperty(FLUSH_AWARE_INFORM_KEY);
        flushAwareInformEnabled = !(string2 != null ? !Boolean.parseBoolean(string2) : false);
        Object object = System.getProperty(FLUSH_AWARE_INTERVAL_KEY);
        flushAwareIntervalMs = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 100;
        Object object2 = System.getProperty(FLUSH_AWARE_FIRST_FLUSH_DELAY_KEY);
        flushAwareFirstFlushDelayMs = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 2000;
        String string3 = System.getProperty(FLUSH_AWARE_FORCE_FLUSH_KEY);
        flushAwareForceFlush = !(string3 != null ? !Boolean.parseBoolean(string3) : false);
        String string4 = System.getProperty(FLUSH_AWARE_AUTO_RECOVERY);
        flushAwareAutoRecovery = !(string4 != null ? !Boolean.parseBoolean(string4) : false);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LuxFlushAwareAlarm.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LuxFlushAwareAlarm.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/lux/util/LuxFlushAwareAlarm$Companion;", "", "<init>", "()V", "FLUSH_AWARE_ENABLED_KEY", "", "FLUSH_AWARE_INFORM_KEY", "FLUSH_AWARE_INTERVAL_KEY", "FLUSH_AWARE_FIRST_FLUSH_DELAY_KEY", "FLUSH_AWARE_FORCE_FLUSH_KEY", "FLUSH_AWARE_AUTO_RECOVERY", "flushAwareEnabled", "", "flushAwareInformEnabled", "flushAwareIntervalMs", "", "flushAwareFirstFlushDelayMs", "flushAwareForceFlush", "flushAwareAutoRecovery", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

