/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.platform.impl.toolkit.IdeMouseInfoPeer;
import com.intellij.platform.impl.toolkit.IdeToolkit;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.LxEvent;
import com.jetbrains.rd.ide.model.LxIdeFrameRef;
import com.jetbrains.rd.ide.model.LxInputMethodEvent;
import com.jetbrains.rd.ide.model.LxKeyEvent;
import com.jetbrains.rd.ide.model.LxLuxWindowRef;
import com.jetbrains.rd.ide.model.LxMouseEventBase;
import com.jetbrains.rd.ide.model.LxNonLuxWindowRef;
import com.jetbrains.rd.ide.model.LxPopupWindowRef;
import com.jetbrains.rd.ide.model.LxWindowEvent;
import com.jetbrains.rd.ide.model.LxWindowRef;
import com.jetbrains.rd.platform.codeWithMe.lux.util.EventsKt;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.awt.peer.LuxWindowPeer;
import com.jetbrains.rdserver.lux.services.LuxHostService;
import com.jetbrains.rdserver.ui.popup.BackendBeAbstractPopup;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0002J.\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdserver/lux/util/UnattendedHostEventHelper;", "", "<init>", "()V", "hostService", "Lcom/jetbrains/rdserver/lux/services/LuxHostService;", "getHostService", "()Lcom/jetbrains/rdserver/lux/services/LuxHostService;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "convertAndDispatchLxEvent", "Ljava/awt/AWTEvent;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "lxEvent", "Lcom/jetbrains/rd/ide/model/LxEvent;", "target", "Ljava/awt/Window;", "refEvent", "Ljava/awt/event/MouseEvent;", "selectPreviousCharacter", "", "editorComponent", "convertLxEvent", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "e", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nUnattendedHostEventHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostEventHelper.kt\ncom/jetbrains/rdserver/lux/util/UnattendedHostEventHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n67#2,4:94\n60#2,5:98\n23#2:104\n1#3:103\n*S KotlinDebug\n*F\n+ 1 UnattendedHostEventHelper.kt\ncom/jetbrains/rdserver/lux/util/UnattendedHostEventHelper\n*L\n40#1:94,4\n42#1:98,5\n36#1:104\n*E\n"})
public final class UnattendedHostEventHelper {
    @NotNull
    public static final UnattendedHostEventHelper INSTANCE;
    @NotNull
    private static final Logger logger;

    private UnattendedHostEventHelper() {
    }

    private final LuxHostService getHostService() {
        return LuxHostService.Companion.getInstance();
    }

    @Nullable
    public final AWTEvent convertAndDispatchLxEvent(@NotNull ClientAppSession session, @NotNull LxEvent lxEvent, @NotNull Window target, @Nullable MouseEvent refEvent) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lxEvent, (String)"lxEvent");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        AWTEvent aWTEvent = this.convertLxEvent(session.getClientId(), lxEvent, target, refEvent);
        if (aWTEvent == null) {
            return null;
        }
        AWTEvent event = aWTEvent;
        Logger $this$trace$iv = UnattendedHostEventHelper.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received event " + lxEvent + ", converted to " + event);
        }
        if (event instanceof WindowEvent) {
            Logger logger2 = FocusManagerImpl.FOCUS_REQUESTS_LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"FOCUS_REQUESTS_LOG");
            Logger $this$debug_u24default$iv = logger2;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Controller-sent event: " + event, t$iv);
            }
            if (!Registry.Companion.is("lux.focus.old.logic")) {
                switch (((WindowEvent)event).getID()) {
                    case 207: {
                        IdeToolkit.Companion.getInstance().getKeyboardFocusManagerPeer().setCurrentFocusedWindow(((WindowEvent)event).getWindow());
                        break;
                    }
                    case 208: {
                        IdeToolkit.Companion.getInstance().getKeyboardFocusManagerPeer().setCurrentFocusedWindow(null);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (event instanceof MouseEvent) {
            IdeMouseInfoPeer.INSTANCE.processMouseEvent((MouseEvent)event, target);
            if (((MouseEvent)event).getID() == 505) {
                ((LuxWindowPeer)AWTAccessor.getComponentAccessor().getPeer(target)).updateCursorImmediately();
            }
        } else if (lxEvent instanceof LxInputMethodEvent && ((LxInputMethodEvent)lxEvent).getSelectPreviousCharacter()) {
            this.selectPreviousCharacter(event.getSource());
        }
        IdeEventQueue.Companion.getInstance().dispatchEvent(event);
        return event;
    }

    public static /* synthetic */ AWTEvent convertAndDispatchLxEvent$default(UnattendedHostEventHelper unattendedHostEventHelper, ClientAppSession clientAppSession, LxEvent lxEvent, Window window, MouseEvent mouseEvent, int n, Object object) {
        if ((n & 8) != 0) {
            mouseEvent = null;
        }
        return unattendedHostEventHelper.convertAndDispatchLxEvent(clientAppSession, lxEvent, window, mouseEvent);
    }

    private final void selectPreviousCharacter(Object editorComponent) {
        int offset;
        if (editorComponent instanceof EditorComponentImpl) {
            EditorImpl editorImpl = ((EditorComponentImpl)editorComponent).getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"getEditor(...)");
            EditorImpl editor = editorImpl;
            int offset2 = editor.getCaretModel().getOffset();
            if (offset2 > 0) {
                editor.getSelectionModel().setSelection(offset2 - 1, offset2);
            }
        } else if (editorComponent instanceof JTextComponent && (offset = ((JTextComponent)editorComponent).getCaret().getDot()) > 0) {
            ((JTextComponent)editorComponent).select(offset - 1, offset);
        }
    }

    private final AWTEvent convertLxEvent(ClientId clientId, LxEvent e, Window target, MouseEvent refEvent) {
        AWTEvent aWTEvent;
        LxEvent lxEvent = e;
        if (lxEvent instanceof LxKeyEvent) {
            aWTEvent = EventsKt.fromLx((LxKeyEvent)((LxKeyEvent)e), (ClientId)clientId, (Component)target);
        } else if (lxEvent instanceof LxMouseEventBase) {
            aWTEvent = EventsKt.fromLx((LxMouseEventBase)((LxMouseEventBase)e), (ClientId)clientId, (Component)target, (boolean)false, (MouseEvent)refEvent);
        } else if (lxEvent instanceof LxInputMethodEvent) {
            aWTEvent = EventsKt.fromLx((LxInputMethodEvent)((LxInputMethodEvent)e), (ClientId)clientId, (Component)target);
        } else if (lxEvent instanceof LxWindowEvent) {
            aWTEvent = EventsKt.fromLx((LxWindowEvent)((LxWindowEvent)e), (ClientId)clientId, (Window)target, UnattendedHostEventHelper::convertLxEvent$lambda$0);
        } else {
            throw new IllegalStateException(("Unknown event " + e).toString());
        }
        return aWTEvent;
    }

    private static final Window convertLxEvent$lambda$0(LxWindowRef it) {
        Window window;
        LxWindowRef lxWindowRef = it;
        if (lxWindowRef == null) {
            window = null;
        } else if (lxWindowRef instanceof LxIdeFrameRef || lxWindowRef instanceof LxNonLuxWindowRef) {
            window = IdeFocusManager.getGlobalInstance().getLastFocusedIdeWindow();
        } else if (lxWindowRef instanceof LxLuxWindowRef) {
            LuxComponentAdapter luxComponentAdapter = INSTANCE.getHostService().getAdapter(((LxLuxWindowRef)it).getId());
            window = luxComponentAdapter != null ? luxComponentAdapter.getWindow() : null;
        } else if (lxWindowRef instanceof LxPopupWindowRef) {
            Window window2;
            Window window3;
            ClientAppSession clientAppSession = UtilKt.getControllerSessionOrNull(ApplicationKt.getApplication());
            if (clientAppSession != null) {
                ClientAppSession s = clientAppSession;
                boolean bl = false;
                window3 = BackendBeAbstractPopup.Companion.getPopupWindow(((LxPopupWindowRef)it).getId(), s);
            } else {
                window3 = null;
            }
            Window window4 = window2 = window3;
            boolean bl = false;
            if (window4 == null) {
                logger.warn("Popup with id " + ((LxPopupWindowRef)it).getId() + " not found");
            }
            window = window2;
        } else {
            throw new IllegalStateException(("Unknown window ref: " + it).toString());
        }
        return window;
    }

    static {
        UnattendedHostEventHelper $this$thisLogger$iv = INSTANCE = new UnattendedHostEventHelper();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UnattendedHostEventHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UnattendedHostEventHelper.logger = logger;
    }
}

