/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.utils;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0017\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/portForwarding/utils/MacOSProcessInfoUtil;", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil;", "<init>", "()V", "get", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "pid", "", "getCommandLine", "", "Lcom/intellij/openapi/util/NlsSafe;", "getExecutable", "Ljava/nio/file/Path;", "getParentPid", "(J)Ljava/lang/Long;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nMacOSProcessInfoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOSProcessInfoUtil.kt\ncom/jetbrains/rdserver/portForwarding/utils/MacOSProcessInfoUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class MacOSProcessInfoUtil
implements ProcessInfoUtil {
    @NotNull
    public static final MacOSProcessInfoUtil INSTANCE = new MacOSProcessInfoUtil();

    private MacOSProcessInfoUtil() {
    }

    @Override
    @NotNull
    public ProcessInfoUtil.ProcessInfo get(long pid) {
        Path executable = this.getExecutable(pid);
        String commandLine2 = this.getCommandLine(pid);
        Long parentPid = this.getParentPid(pid);
        return new ProcessInfoUtil.ProcessInfo(pid, commandLine2, executable, parentPid);
    }

    private final String getCommandLine(long pid) {
        String[] stringArray = new String[]{"ps", "-p", String.valueOf(pid), "-o", "command"};
        GeneralCommandLine cli = new GeneralCommandLine(stringArray);
        ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cli, (int)5000);
        if (output2.getExitCode() != 0) {
            return null;
        }
        String string = output2.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)string, (CharSequence)"COMMAND"))).toString();
    }

    private final Path getExecutable(long pid) {
        Path path;
        String executable;
        String[] stringArray = new String[]{"lsof", "-p", String.valueOf(pid), "-Fn"};
        GeneralCommandLine cli = new GeneralCommandLine(stringArray);
        ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cli, (int)5000);
        if (output2.getExitCode() != 0) {
            return null;
        }
        List list = output2.getStdoutLines();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
        String string = (String)CollectionsKt.getOrNull((List)list, (int)4);
        String string2 = executable = string != null ? StringsKt.removePrefix((String)string, (CharSequence)"n/") : null;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            path = Path.of(it, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    private final Long getParentPid(long pid) {
        String[] stringArray = new String[]{"ps", "-p", String.valueOf(pid), "-o", "ppid"};
        GeneralCommandLine cli = new GeneralCommandLine(stringArray);
        ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)cli, (int)5000);
        if (output2.getExitCode() != 0) {
            return null;
        }
        List list = output2.getStdoutLines();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
        String string = (String)CollectionsKt.getOrNull((List)list, (int)1);
        return string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null ? StringsKt.toLongOrNull((String)string) : null;
    }
}

