/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.projectView;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.AbstractProjectViewPaneWithAsyncSupport;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.projectView.BackendProjectPaneProvider;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/projectView/BackendProjectViewAsyncPaneProvider;", "Lcom/jetbrains/rdserver/projectView/BackendProjectPaneProvider;", "project", "Lcom/intellij/openapi/project/Project;", "paneId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectView", "Lcom/intellij/ide/projectView/impl/ProjectViewImpl;", "isAvailable", "", "getProjectViewPane", "Lcom/intellij/ide/projectView/impl/AbstractProjectViewPane;", "createAsyncTreeModel", "Lcom/intellij/ui/tree/AsyncTreeModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createSelectVisitor", "Lcom/intellij/ui/tree/TreeVisitor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.backend.split"})
public abstract class BackendProjectViewAsyncPaneProvider
implements BackendProjectPaneProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final String paneId;
    @NotNull
    private final ProjectViewImpl projectView;

    public BackendProjectViewAsyncPaneProvider(@NotNull Project project, @NotNull String paneId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
        this.project = project;
        this.paneId = paneId;
        ProjectView projectView = ProjectView.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)projectView, (String)"null cannot be cast to non-null type com.intellij.ide.projectView.impl.ProjectViewImpl");
        this.projectView = (ProjectViewImpl)projectView;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean isAvailable() {
        return this.projectView.getProjectViewPaneById(this.paneId) != null;
    }

    @Override
    @NotNull
    public AbstractProjectViewPane getProjectViewPane() {
        AbstractProjectViewPane abstractProjectViewPane = this.projectView.getProjectViewPaneById(this.paneId);
        Intrinsics.checkNotNullExpressionValue((Object)abstractProjectViewPane, (String)"getProjectViewPaneById(...)");
        return abstractProjectViewPane;
    }

    @Override
    @NotNull
    public AsyncTreeModel createAsyncTreeModel(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        GroupByTypeComparator comparator = new GroupByTypeComparator(this.project, this.paneId);
        AbstractProjectViewPane abstractProjectViewPane = this.projectView.getProjectViewPaneById(this.paneId);
        Intrinsics.checkNotNull((Object)abstractProjectViewPane, (String)"null cannot be cast to non-null type com.intellij.ide.projectView.impl.AbstractProjectViewPaneWithAsyncSupport");
        AbstractProjectViewPaneWithAsyncSupport pane = (AbstractProjectViewPaneWithAsyncSupport)abstractProjectViewPane;
        AsyncProjectViewSupport asyncProjectViewSupport = pane.createAsyncSupport(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), (Comparator)comparator);
        Intrinsics.checkNotNullExpressionValue((Object)asyncProjectViewSupport, (String)"createAsyncSupport(...)");
        AsyncProjectViewSupport asyncSupport = asyncProjectViewSupport;
        AsyncTreeModel asyncTreeModel = asyncSupport.getTreeModel();
        Intrinsics.checkNotNullExpressionValue((Object)asyncTreeModel, (String)"getTreeModel(...)");
        return asyncTreeModel;
    }

    @Override
    @Nullable
    public TreeVisitor createSelectVisitor(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        PsiFile element = PsiManager.getInstance((Project)this.project).findFile(file2);
        return AbstractProjectViewPane.createVisitor((PsiElement)((PsiElement)element), (VirtualFile)file2);
    }
}

