/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.settings;

import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.l10n.LocalizationStateService;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.model.LocaleAndRegionModel;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.settings.BackendLanguageAndRegionSettingsListenerKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/settings/BackendLanguageAndRegionSettingsListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/SettingsModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "subscribeForFrontendChanges", "handleChange", "locale", "", "region", "Utils", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendLanguageAndRegionSettingsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLanguageAndRegionSettingsListener.kt\ncom/jetbrains/rdserver/settings/BackendLanguageAndRegionSettingsListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n296#2,2:93\n67#3,4:95\n67#3,4:99\n*S KotlinDebug\n*F\n+ 1 BackendLanguageAndRegionSettingsListener.kt\ncom/jetbrains/rdserver/settings/BackendLanguageAndRegionSettingsListener\n*L\n60#1:93,2\n63#1:95,4\n74#1:99,4\n*E\n"})
public final class BackendLanguageAndRegionSettingsListener
implements RootExtListener<SettingsModel> {
    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull SettingsModel model2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        if (!session.isController()) {
            return;
        }
        this.subscribeForFrontendChanges(lifetime, session, model2);
    }

    private final void subscribeForFrontendChanges(Lifetime lifetime, ClientAppSession session, SettingsModel model2) {
        IScheduler backgroundScheduler = IRdDispatcherKt.getAsRdDispatcher((IScheduler)RemoteSessionKt.getProtocol(session).getScheduler()).getBackgroundScheduler();
        model2.getFrontendLocaleAndRegion().adviseOn(lifetime, backgroundScheduler, arg_0 -> BackendLanguageAndRegionSettingsListener.subscribeForFrontendChanges$lambda$0(lifetime, this, arg_0));
    }

    private final void handleChange(String locale, String region) {
        Logger logger;
        Object v0;
        block6: {
            ThreadingAssertions.assertEventDispatchThread();
            Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Region it = (Region)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.externalName(), (Object)region)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        Region targetRegion = v0;
        if (targetRegion != null) {
            RegionSettings.setRegion((Region)targetRegion);
            Logger $this$trace$iv = BackendLanguageAndRegionSettingsListenerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Region is set to " + targetRegion);
            }
        } else {
            BackendLanguageAndRegionSettingsListenerKt.access$getLogger$p().warn("Unknown region: " + region + ", known regions: [" + CollectionsKt.joinToString$default((Iterable)((Iterable)EntriesMappings.entries$0), null, null, null, (int)0, null, null, (int)63, null) + "]");
        }
        LocalizationStateService localizationStateService = LocalizationStateService.getInstance();
        if (localizationStateService == null) {
            BackendLanguageAndRegionSettingsListener $this$handleChange_u24lambda_u242 = this;
            boolean bl = false;
            BackendLanguageAndRegionSettingsListenerKt.access$getLogger$p().error("Failed to get LocalizationStateService");
            return;
        }
        LocalizationStateService localizationService = localizationStateService;
        localizationService.setSelectedLocale(locale);
        Logger $this$trace$iv = BackendLanguageAndRegionSettingsListenerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Locale is set to " + locale);
        }
    }

    private static final Unit subscribeForFrontendChanges$lambda$0(Lifetime $lifetime, BackendLanguageAndRegionSettingsListener this$0, LocaleAndRegionModel localeAndRegion) {
        if (localeAndRegion == null) {
            return Unit.INSTANCE;
        }
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        LifetimeCoroutineUtilKt.launch$default((Lifetime)$lifetime, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, localeAndRegion, null){
            int label;
            final /* synthetic */ BackendLanguageAndRegionSettingsListener this$0;
            final /* synthetic */ LocaleAndRegionModel $localeAndRegion;
            {
                this.this$0 = $receiver;
                this.$localeAndRegion = $localeAndRegion;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BackendLanguageAndRegionSettingsListener.access$handleChange(this.this$0, this.$localeAndRegion.getLocale(), this.$localeAndRegion.getRegion());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleChange(BackendLanguageAndRegionSettingsListener $this, String locale, String region) {
        $this.handleChange(locale, region);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Region> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Region.values()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/settings/BackendLanguageAndRegionSettingsListener$Utils;", "", "<init>", "()V", "sendInitialLanguageAndRegion", "", "model", "Lcom/jetbrains/rd/ide/model/SettingsModel;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendLanguageAndRegionSettingsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLanguageAndRegionSettingsListener.kt\ncom/jetbrains/rdserver/settings/BackendLanguageAndRegionSettingsListener$Utils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n67#2,4:93\n*S KotlinDebug\n*F\n+ 1 BackendLanguageAndRegionSettingsListener.kt\ncom/jetbrains/rdserver/settings/BackendLanguageAndRegionSettingsListener$Utils\n*L\n84#1:93,4\n*E\n"})
    public static final class Utils {
        @NotNull
        public static final Utils INSTANCE = new Utils();

        private Utils() {
        }

        public final void sendInitialLanguageAndRegion(@NotNull SettingsModel model2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            IProperty iProperty = model2.getBackendLocaleAndRegion();
            String string = LocalizationUtil.getLocale$default((LocalizationUtil)LocalizationUtil.INSTANCE, (boolean)false, (int)1, null).toLanguageTag();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageTag(...)");
            String string2 = RegionSettings.getRegion().externalName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalName(...)");
            iProperty.set((Object)new LocaleAndRegionModel(string, string2));
            Logger $this$trace$iv = BackendLanguageAndRegionSettingsListenerKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Initial locale and region settings: locale=" + LocalizationUtil.getLocale$default((LocalizationUtil)LocalizationUtil.INSTANCE, (boolean)false, (int)1, null).toLanguageTag() + ", region=" + RegionSettings.getRegion().externalName());
            }
        }
    }
}

