/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\b&\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH&J\b\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H$J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\b\u0010\u0019\u001a\u00020\tH&J\b\u0010\u001a\u001a\u00020\tH&J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0018H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "", "<init>", "()V", "key", "", "getKey", "()Ljava/lang/String;", "open", "", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "requesterProcessInfo", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "calcRequesterProcessInfo", "pid", "", "close", "cleanup", "getProcessTree", "processInfo", "targetProcessId", "Companion", "Streams", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nSshAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1924#2,2:104\n1926#2:107\n1#3:106\n*S KotlinDebug\n*F\n+ 1 SshAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc\n*L\n81#1:104,2\n81#1:107\n*E\n"})
public abstract class SshAgentIpc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SshRequesterProcessInfo missingProcessInfo = new SshRequesterProcessInfo(-1L, "", "", null);

    @NotNull
    public abstract String getKey();

    public abstract void open();

    public abstract boolean isOpen();

    @NotNull
    public abstract Streams accept();

    @NotNull
    public abstract SshRequesterProcessInfo getRequesterProcessInfo();

    protected abstract boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo var1);

    @NotNull
    protected final SshRequesterProcessInfo calcRequesterProcessInfo(long pid) {
        ProcessInfoUtil.ProcessInfo parentProcessInfo;
        ProcessInfoUtil.ProcessInfo processInfo = ProcessInfoUtil.Companion.getForCurrentOs().get(pid);
        Long parentPid = processInfo.getParentPid();
        if (this.isSshProcess(processInfo) && parentPid != null && (parentProcessInfo = ProcessInfoUtil.Companion.getForCurrentOs().get(parentPid)).getExecutable() != null) {
            long currentProcessId = ProcessHandle.current().pid();
            String processTree = this.getProcessTree(processInfo, currentProcessId);
            return SshAgentIpc.calcRequesterProcessInfo$toModel(parentProcessInfo, parentPid, processTree);
        }
        return SshAgentIpc.calcRequesterProcessInfo$toModel(processInfo, pid, null);
    }

    public abstract void close();

    public abstract void cleanup();

    /*
     * WARNING - void declaration
     */
    private final String getProcessTree(ProcessInfoUtil.ProcessInfo processInfo, long targetProcessId) {
        ProcessInfoUtil processUtil = ProcessInfoUtil.Companion.getForCurrentOs();
        List processList = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)processInfo, arg_0 -> SshAgentIpc.getProcessTree$lambda$0(targetProcessId, processUtil, arg_0)));
        StringBuilder builder = new StringBuilder();
        Iterable $this$forEachIndexed$iv = CollectionsKt.reversed((Iterable)processList);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void processInfo2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProcessInfoUtil.ProcessInfo processInfo3 = (ProcessInfoUtil.ProcessInfo)item$iv;
            int index = n;
            boolean bl = false;
            int n2 = index * 2;
            int n3 = 0;
            while (n3 < n2) {
                int it = n3++;
                boolean bl2 = false;
                builder.append(" ");
            }
            if (index != 0) {
                builder.append("\u2514\u2500");
            }
            Path path = processInfo2.getExecutable();
            StringBuilder stringBuilder = builder.append(path != null ? PathsKt.getName((Path)path) : null).append(" [").append(processInfo2.getPid()).append("] ");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            stringBuilder.append(processInfo2.getCommandLine()).append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final SshRequesterProcessInfo calcRequesterProcessInfo$toModel(ProcessInfoUtil.ProcessInfo $this$calcRequesterProcessInfo_u24toModel, long pid, String processTree) {
        String string;
        Object object = $this$calcRequesterProcessInfo_u24toModel.getExecutable();
        if (object == null || (object = object.getFileName()) == null || (object = object.toString()) == null) {
            object = "";
        }
        if ((string = $this$calcRequesterProcessInfo_u24toModel.getCommandLine()) == null) {
            string = "";
        }
        return new SshRequesterProcessInfo(pid, (String)object, string, processTree);
    }

    private static final ProcessInfoUtil.ProcessInfo getProcessTree$lambda$0(long $targetProcessId, ProcessInfoUtil $processUtil, ProcessInfoUtil.ProcessInfo process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Long l = process2.getPid();
        long l2 = $targetProcessId;
        if (l != null && l == l2 || process2.getParentPid() == null) {
            return null;
        }
        return $processUtil.get(process2.getParentPid());
    }

    @NotNull
    public static final SshRequesterProcessInfo getMissingProcessInfo() {
        return Companion.getMissingProcessInfo();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Companion;", "", "<init>", "()V", "missingProcessInfo", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "getMissingProcessInfo$annotations", "getMissingProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SshRequesterProcessInfo getMissingProcessInfo() {
            return missingProcessInfo;
        }

        @JvmStatic
        public static /* synthetic */ void getMissingProcessInfo$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "Ljava/io/Closeable;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "intellij.platform.backend.split"})
    public static interface Streams
    extends Closeable {
        @NotNull
        public InputStream getInputStream();

        @NotNull
        public OutputStream getOutputStream();
    }
}

