/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u0011H\u0016J\b\u0010$\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "socketFile", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "key", "", "getKey", "()Ljava/lang/String;", "socket", "Ljava/nio/channels/ServerSocketChannel;", "getSocket", "()Ljava/nio/channels/ServerSocketChannel;", "socket$delegate", "Lkotlin/Lazy;", "open", "", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "getRequesterPid", "", "acceptedChannel", "Ljava/nio/channels/SocketChannel;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "close", "cleanup", "CLib", "Ucred", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nUnixDomainSocketAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnixDomainSocketAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 reflection.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/util/ReflectionKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n23#2:136\n23#2:137\n23#2:148\n47#3,2:138\n49#3,2:141\n47#3,2:143\n49#3,2:146\n1#4:140\n1#4:145\n*S KotlinDebug\n*F\n+ 1 UnixDomainSocketAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc\n*L\n47#1:136\n61#1:137\n115#1:148\n80#1:138,2\n80#1:141,2\n81#1:143,2\n81#1:146,2\n80#1:140\n81#1:145\n*E\n"})
public final class UnixDomainSocketAgentIpc
extends SshAgentIpc {
    @NotNull
    private final Path socketFile;
    @NotNull
    private final String key;
    @NotNull
    private final Lazy socket$delegate;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;

    public UnixDomainSocketAgentIpc(@NotNull Path socketFile) {
        Intrinsics.checkNotNullParameter((Object)socketFile, (String)"socketFile");
        this.socketFile = socketFile;
        this.key = ((Object)this.socketFile.toAbsolutePath()).toString();
        this.socket$delegate = LazyKt.lazy(UnixDomainSocketAgentIpc::socket_delegate$lambda$0);
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final ServerSocketChannel getSocket() {
        Lazy lazy = this.socket$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ServerSocketChannel)object;
    }

    @Override
    public void open() {
        UnixDomainSocketAddress address = UnixDomainSocketAddress.of(this.socketFile);
        UnixDomainSocketAgentIpc $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(UnixDomainSocketAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Binding unix socket to address " + address);
        this.getSocket().bind(address);
    }

    @Override
    public boolean isOpen() {
        return this.getSocket().isOpen();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshRequesterProcessInfo sshRequesterProcessInfo;
        UnixDomainSocketAgentIpc unixDomainSocketAgentIpc;
        SocketChannel socketChannel = this.getSocket().accept();
        UnixDomainSocketAgentIpc unixDomainSocketAgentIpc2 = this;
        try {
            unixDomainSocketAgentIpc = unixDomainSocketAgentIpc2;
            Intrinsics.checkNotNull((Object)socketChannel);
            long pid = this.getRequesterPid(socketChannel);
            sshRequesterProcessInfo = this.calcRequesterProcessInfo(pid);
        }
        catch (Throwable throwable) {
            void e;
            unixDomainSocketAgentIpc = unixDomainSocketAgentIpc2;
            UnixDomainSocketAgentIpc $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UnixDomainSocketAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get the SSH requester process info", (Throwable)e);
            sshRequesterProcessInfo = SshAgentIpc.Companion.getMissingProcessInfo();
        }
        unixDomainSocketAgentIpc.requestorProcessValue = sshRequesterProcessInfo;
        return new SshAgentIpc.Streams(socketChannel){
            private final InputStream inputStream;
            private final OutputStream outputStream;
            {
                this.inputStream = Channels.newInputStream($socketChannel);
                this.outputStream = Channels.newOutputStream($socketChannel);
            }

            public InputStream getInputStream() {
                return this.inputStream;
            }

            public OutputStream getOutputStream() {
                return this.outputStream;
            }

            public void close() {
                this.getInputStream().close();
                this.getOutputStream().close();
            }
        };
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Path path = process2.getExecutable();
        return path != null ? path.endsWith("ssh") : false;
    }

    /*
     * WARNING - void declaration
     */
    private final int getRequesterPid(SocketChannel acceptedChannel) {
        int n;
        try {
            int n2;
            KProperty1 property$iv;
            Object v5;
            void $this$getFieldValue$iv;
            block17: {
                KProperty1 property$iv2;
                Object v0;
                void $this$getFieldValue$iv2;
                Object fieldName$iv;
                block16: {
                    SocketChannel socketChannel = acceptedChannel;
                    fieldName$iv = "fd";
                    boolean $i$f$getFieldValue = false;
                    for (Object object : (Iterable)KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass($this$getFieldValue$iv2.getClass()))) {
                        KProperty1 it$iv = (KProperty1)object;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it$iv.getName(), (Object)fieldName$iv)) continue;
                        v0 = object;
                        break block16;
                    }
                    v0 = null;
                }
                Object var11_18 = v0;
                KProperty1 kProperty1 = property$iv2 = var11_18 instanceof KProperty1 ? (KProperty1)var11_18 : null;
                if (kProperty1 != null) {
                    KCallablesJvm.setAccessible((KCallable)((KCallable)kProperty1), (boolean)true);
                }
                KProperty1 kProperty12 = property$iv2;
                Object object = kProperty12 != null ? kProperty12.get((Object)$this$getFieldValue$iv2) : null;
                if (!(object instanceof FileDescriptor)) {
                    object = null;
                }
                FileDescriptor fileDescriptor = (FileDescriptor)object;
                if (fileDescriptor == null) {
                    throw new IllegalStateException("Failed to get the fd field".toString());
                }
                FileDescriptor socketFileDescriptor = fileDescriptor;
                fieldName$iv = socketFileDescriptor;
                String fieldName$iv2 = "fd";
                boolean $i$f$getFieldValue = false;
                for (Object e : (Iterable)KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass($this$getFieldValue$iv.getClass()))) {
                    KProperty1 it$iv = (KProperty1)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it$iv.getName(), (Object)fieldName$iv2)) continue;
                    v5 = e;
                    break block17;
                }
                v5 = null;
            }
            Object var12_20 = v5;
            KProperty1 kProperty1 = property$iv = var12_20 instanceof KProperty1 ? (KProperty1)var12_20 : null;
            if (kProperty1 != null) {
                KCallablesJvm.setAccessible((KCallable)((KCallable)kProperty1), (boolean)true);
            }
            KProperty1 kProperty13 = property$iv;
            Object object = kProperty13 != null ? kProperty13.get((Object)$this$getFieldValue$iv) : null;
            if (!(object instanceof Integer)) {
                object = null;
            }
            Integer n3 = (Integer)object;
            if (n3 == null) {
                throw new IllegalStateException("Failed to get the fd field".toString());
            }
            int rawFd = n3;
            if (SystemInfo.isLinux) {
                int SOL_SOCKET = 1;
                int SO_PEERCRED = 17;
                Ucred ucred = new Ucred();
                IntByReference len = new IntByReference(ucred.size());
                CLib cLib = CLib.Companion.getINSTANCE();
                Pointer pointer = ucred.getPointer();
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
                int result = cLib.getsockopt(rawFd, SOL_SOCKET, SO_PEERCRED, pointer, len);
                if (result != 0) {
                    throw new IllegalStateException("getsockopt failed".toString());
                }
                ucred.read();
                n2 = ucred.pid;
            } else if (SystemInfo.isMac) {
                int SOL_LOCAL = 0;
                int LOCAL_PEERPID = 2;
                IntByReference pid = new IntByReference();
                CLib cLib = CLib.Companion.getINSTANCE();
                Pointer pointer = pid.getPointer();
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getPointer(...)");
                int result = cLib.getsockopt(rawFd, SOL_LOCAL, LOCAL_PEERPID, pointer, new IntByReference(8));
                if (result != 0) {
                    throw new IllegalStateException("getsockopt failed".toString());
                }
                n2 = pid.getValue();
            } else {
                throw new IllegalStateException(("Unsupported OS: " + SystemInfo.OS_NAME).toString());
            }
            n = n2;
        }
        catch (Throwable e) {
            UnixDomainSocketAgentIpc $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UnixDomainSocketAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to get requester PID", e);
            n = -1;
        }
        return n;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    @Override
    public void close() {
        this.getSocket().close();
    }

    @Override
    public void cleanup() {
        Files.deleteIfExists(this.socketFile);
    }

    private static final ServerSocketChannel socket_delegate$lambda$0() {
        return ServerSocketChannel.open(StandardProtocolFamily.UNIX);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bb\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc$CLib;", "Lcom/sun/jna/Library;", "getsockopt", "", "socket", "level", "optname", "optval", "Lcom/sun/jna/Pointer;", "optlen", "Lcom/sun/jna/ptr/IntByReference;", "Companion", "intellij.platform.backend.split"})
    private static interface CLib
    extends Library {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public int getsockopt(int var1, int var2, int var3, @NotNull Pointer var4, @NotNull IntByReference var5);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc$CLib$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc$CLib;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc$CLib;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final CLib INSTANCE;

            private Companion() {
            }

            @NotNull
            public final CLib getINSTANCE() {
                return INSTANCE;
            }

            static {
                $$INSTANCE = new Companion();
                Library library = Native.load((String)Platform.C_LIBRARY_NAME, CLib.class);
                Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
                INSTANCE = (CLib)library;
            }
        }
    }

    @Structure.FieldOrder(value={"pid", "uid", "gid"})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/UnixDomainSocketAgentIpc$Ucred;", "Lcom/sun/jna/Structure;", "<init>", "()V", "pid", "", "uid", "gid", "intellij.platform.backend.split"})
    public static final class Ucred
    extends Structure {
        @JvmField
        public int pid;
        @JvmField
        public int uid;
        @JvmField
        public int gid;
    }
}

