/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.toolWindow;

import com.intellij.ide.actions.CloseAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.jetbrains.rdserver.toolWindow.BackendContentManager;
import com.jetbrains.rdserver.toolWindow.BackendToolWindow;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdserver/toolWindow/BackendContentUI;", "Lcom/intellij/ui/content/ContentUI;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "panel", "Ljavax/swing/JPanel;", "contentManager", "Lcom/jetbrains/rdserver/toolWindow/BackendContentManager;", "ownContent", "", "<init>", "(Ljavax/swing/JPanel;Lcom/jetbrains/rdserver/toolWindow/BackendContentManager;Z)V", "getPanel", "()Ljavax/swing/JPanel;", "getContentManager", "()Lcom/jetbrains/rdserver/toolWindow/BackendContentManager;", "hideContent", "", "showContent", "content", "Lcom/intellij/ui/content/Content;", "getComponent", "Ljavax/swing/JComponent;", "setManager", "manager", "Lcom/intellij/ui/content/ContentManager;", "isSingleSelection", "isToSelectAddedContent", "canBeEmptySelection", "canChangeSelectionTo", "implicit", "getCloseActionName", "", "getCloseAllButThisActionName", "getPreviousContentActionName", "getNextContentActionName", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.platform.backend.split"})
final class BackendContentUI
implements ContentUI,
UiDataProvider {
    @NotNull
    private final JPanel panel;
    @NotNull
    private final BackendContentManager contentManager;

    public BackendContentUI(@NotNull JPanel panel, @NotNull BackendContentManager contentManager, boolean ownContent) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)((Object)contentManager), (String)"contentManager");
        this.panel = panel;
        this.contentManager = contentManager;
        if (ownContent) {
            this.contentManager.addContentManagerListener(new ContentManagerListener(){

                public void selectionChanged(@NotNull ContentManagerEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (ContentManagerEvent.ContentOperation.add == event.getOperation()) {
                        Content content = event.getContent();
                        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                        this.showContent(content);
                    } else if (ContentManagerEvent.ContentOperation.remove == event.getOperation()) {
                        this.hideContent();
                    }
                }
            });
        }
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final BackendContentManager getContentManager() {
        return this.contentManager;
    }

    private final void hideContent() {
        this.panel.removeAll();
        this.panel.revalidate();
        this.panel.repaint();
    }

    public final void showContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.panel.getComponentCount() != 1 || this.panel.getComponent(0) != content.getComponent()) {
            this.panel.removeAll();
            this.panel.add((Component)content.getComponent(), "Center");
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    public void setManager(@NotNull ContentManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public boolean canChangeSelectionTo(@NotNull Content content, boolean implicit) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = UIBundle.message((String)"tabbed.pane.select.previous.tab", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = UIBundle.message((String)"tabbed.pane.select.next.tab", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        BackendToolWindow window = this.contentManager.getToolWindow();
        DataKey dataKey = PlatformDataKeys.TOOL_WINDOW;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"TOOL_WINDOW");
        sink.set(dataKey, (Object)window);
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        sink.set(dataKey2, (Object)window.getProject());
        DataSink.Companion.uiDataSnapshot(sink, (Object)IdeFrameImpl.Companion.getActiveFrame());
        DataKey dataKey3 = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"HELP_ID");
        sink.set(dataKey3, (Object)window.getHelpId());
        DataKey dataKey4 = CloseAction.CloseTarget.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey4, (String)"KEY");
        sink.set(dataKey4, (Object)ToolWindowContentUi.computeCloseTarget((ToolWindow)((ToolWindow)window)));
    }
}

