/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.contextProviders;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.ide.model.uiautomation.BePosition;
import com.jetbrains.rd.ide.model.BeEditorAnchor;
import com.jetbrains.rd.ide.model.BePopupPositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionEditorAnchorContext;
import com.jetbrains.rd.ide.model.BePopupPositionEditorContext;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rdserver.actions.ClientRelativePoint;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import com.jetbrains.rdserver.ui.BeBackendContextProvider;
import java.awt.Component;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/ui/contextProviders/EditorPointContextProvider;", "Lcom/jetbrains/rdserver/ui/BeBackendContextProvider;", "<init>", "()V", "tryGetContext", "Lcom/jetbrains/rd/ide/model/BePopupPositionContext;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "desiredSize", "Ljava/awt/Dimension;", "relativePosition", "Lcom/jetbrains/ide/model/uiautomation/BePosition;", "intellij.platform.backend.split"})
public final class EditorPointContextProvider
implements BeBackendContextProvider {
    @Override
    @Nullable
    public BePopupPositionContext tryGetContext(@NotNull ClientAppSession session, @NotNull RelativePoint point, @Nullable Dimension desiredSize, @NotNull BePosition relativePosition) {
        BePopupPositionContext bePopupPositionContext;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)relativePosition, (String)"relativePosition");
        Component component = point.getOriginalComponent();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getOriginalComponent(...)");
        Component component2 = component;
        if (!(component2 instanceof EditorComponentImpl)) {
            return null;
        }
        EditorImpl editorImpl = ((EditorComponentImpl)component2).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorImpl, (String)"getEditor(...)");
        EditorImpl editor = editorImpl;
        TextControlId textControlId = BackendEditorHost.Companion.textControlIdForSession((Editor)editor, session);
        if (textControlId == null) {
            return null;
        }
        TextControlId editorId = textControlId;
        LogicalPosition logicalPosition = editor.xyToLogicalPosition(point.getOriginalPoint());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        if (point instanceof ClientRelativePoint) {
            bePopupPositionContext = (BePopupPositionContext)new BePopupPositionEditorContext(editorId, relativePosition);
        } else {
            BeEditorAnchor anchor = new BeEditorAnchor(logicalPosition2.line, logicalPosition2.column, logicalPosition2.leansForward);
            bePopupPositionContext = (BePopupPositionContext)new BePopupPositionEditorAnchorContext(anchor, editorId, relativePosition);
        }
        return bePopupPositionContext;
    }
}

