/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.notification;

import com.intellij.notification.ActionCenter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.codeWithMe.model.HyperLinkEvent;
import com.jetbrains.codeWithMe.model.NewNotificationModel;
import com.jetbrains.codeWithMe.model.NewNotificationsModel;
import com.jetbrains.codeWithMe.model.NewNotificationsModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.RdNotificationGroupModel;
import com.jetbrains.ide.model.notifications.RdNotificationEntryType;
import com.jetbrains.rd.actions.ActionsKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.ide.model.ActionRegistrationModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.ui.BackendNotificationFilter;
import com.jetbrains.rdserver.ui.notification.BackendNotificationsHostKt;
import com.jetbrains.rdserver.ui.notification.BackendNotificationsTracker;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ*\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u00100\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lcom/jetbrains/rdserver/ui/notification/BackendNotificationsHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "fakeVisibleComponent", "Ljavax/swing/JPanel;", "getFakeVisibleComponent", "()Ljavax/swing/JPanel;", "fakeVisibleComponent$delegate", "Lkotlin/Lazy;", "knownNotifications", "Ljava/util/HashMap;", "", "Lcom/intellij/notification/Notification;", "Lkotlin/collections/HashMap;", "notificationIdCounter", "newNotificationsModel", "Lcom/jetbrains/codeWithMe/model/NewNotificationsModel;", "getNewNotificationsModel", "()Lcom/jetbrains/codeWithMe/model/NewNotificationsModel;", "newNotificationsModel$delegate", "sendNotification", "", "notification", "project", "Lcom/intellij/openapi/project/Project;", "convertNotification", "Lcom/jetbrains/codeWithMe/model/NewNotificationModel;", "projectId", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "suppressShowingAnyPopups", "", "toUrl", "Ljava/net/URL;", "urlAsString", "", "ensureGroupModelIsSent", "group", "Lcom/intellij/notification/NotificationGroup;", "convertAction", "Lcom/jetbrains/rd/ide/model/ActionRegistrationModel;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "getNotification", "notificationId", "Companion", "SessionListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendNotificationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,223:1\n1642#2,10:224\n1915#2:234\n1916#2:236\n1652#2:237\n1#3:235\n1#3:238\n13#4:239\n*S KotlinDebug\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHost\n*L\n129#1:224,10\n129#1:234\n129#1:236\n129#1:237\n129#1:235\n51#1:239\n*E\n"})
public final class BackendNotificationsHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Lazy fakeVisibleComponent$delegate;
    @NotNull
    private final HashMap<Integer, Notification> knownNotifications;
    private int notificationIdCounter;
    @NotNull
    private final Lazy newNotificationsModel$delegate;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String REMOTE_NOTIFICATIONS_GROUP = "RemoteNotificationsGroup";
    @NotNull
    private static final ExtensionPointName<BackendNotificationFilter> EP_NAME;

    public BackendNotificationsHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.fakeVisibleComponent$delegate = LazyKt.lazy(BackendNotificationsHost::fakeVisibleComponent_delegate$lambda$0);
        this.knownNotifications = new HashMap();
        this.newNotificationsModel$delegate = LazyKt.lazy(() -> BackendNotificationsHost.newNotificationsModel_delegate$lambda$0(this));
    }

    @NotNull
    public final JPanel getFakeVisibleComponent() {
        Lazy lazy = this.fakeVisibleComponent$delegate;
        return (JPanel)lazy.getValue();
    }

    private final NewNotificationsModel getNewNotificationsModel() {
        Lazy lazy = this.newNotificationsModel$delegate;
        return (NewNotificationsModel)lazy.getValue();
    }

    public final void sendNotification(@NotNull Notification notification, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        if (EP_NAME.findFirstSafe(arg_0 -> BackendNotificationsHost.sendNotification$lambda$1(arg_0 -> BackendNotificationsHost.sendNotification$lambda$0(notification, this, project, arg_0), arg_0)) != null) {
            return;
        }
        LifetimeDefinition lifetime = this.getServiceLifetime().createNested();
        int n = this.notificationIdCounter;
        this.notificationIdCounter = n + 1;
        int id = n;
        boolean suppressShowingAnyPopups = BackendNotificationsTracker.Companion.getInstance(this.session).wasShown(notification);
        Project project2 = project;
        NewNotificationModel model2 = this.convertNotification((RdProjectId)(project2 != null ? ProjectUtilKt.getRdProjectId((Project)project2) : null), notification, (Lifetime)lifetime, suppressShowingAnyPopups);
        ((Map)this.getNewNotificationsModel().getNotifications()).put(id, model2);
        BackendNotificationsTracker.Companion.getInstance(this.session).markAsShown(notification);
        ((Map)this.knownNotifications).put(id, notification);
        this.getNewNotificationsModel().getNotifications().adviseAddRemove((Lifetime)lifetime, (arg_0, arg_1, arg_2) -> BackendNotificationsHost.sendNotification$lambda$2(id, lifetime, arg_0, arg_1, arg_2));
        notification.whenExpired(() -> BackendNotificationsHost.sendNotification$lambda$3(lifetime, model2));
        model2.isExpired().advise((Lifetime)lifetime, arg_0 -> BackendNotificationsHost.sendNotification$lambda$4(notification, lifetime, arg_0));
        lifetime.onTermination(() -> BackendNotificationsHost.sendNotification$lambda$5(this, id));
    }

    /*
     * WARNING - void declaration
     */
    private final NewNotificationModel convertNotification(RdProjectId projectId, Notification notification, Lifetime lifetime, boolean suppressShowingAnyPopups) {
        void $this$mapNotNullTo$iv$iv;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(notification.getGroupId());
        if (notificationGroup != null) {
            NotificationGroup it = notificationGroup;
            boolean bl = false;
            this.ensureGroupModelIsSent(it);
        }
        List list = notification.getActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActions(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable bl = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ActionRegistrationModel it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            AnAction it = (AnAction)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            if (this.convertAction(it, lifetime) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actions = (List)destination$iv$iv;
        String string = notification.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        String string2 = notification.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getContent(...)");
        NotificationType notificationType = notification.getType();
        Intrinsics.checkNotNullExpressionValue((Object)notificationType, (String)"getType(...)");
        RdNotificationEntryType rdNotificationEntryType = BackendNotificationsHostKt.access$toProtocol(notificationType);
        String string3 = notification.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getGroupId(...)");
        Icon icon2 = notification.getIcon();
        NewNotificationModel model2 = new NewNotificationModel(projectId, string, string2, rdNotificationEntryType, string3, notification.isImportant(), notification.isSuggestionType(), notification.isImportantSuggestion(), notification.isShowingPopupSuppressed() || suppressShowingAnyPopups, (IconModel)(icon2 != null ? UtilKt.toModel((Icon)icon2) : null), actions, notification.getToolWindowId(), Long.valueOf(notification.getTimestamp()));
        model2.getMessageHyperlinkActivated().advise(lifetime, arg_0 -> BackendNotificationsHost.convertNotification$lambda$2(notification, this, arg_0));
        return model2;
    }

    private final URL toUrl(String urlAsString) {
        if (urlAsString == null) {
            return null;
        }
        try {
            return new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private final void ensureGroupModelIsSent(NotificationGroup group2) {
        String groupId = group2.getDisplayId();
        this.getNewNotificationsModel().getNotificationsGroups().computeIfAbsent((Object)groupId, arg_0 -> BackendNotificationsHost.ensureGroupModelIsSent$lambda$1(arg_0 -> BackendNotificationsHost.ensureGroupModelIsSent$lambda$0(groupId, group2, arg_0), arg_0));
    }

    private final ActionRegistrationModel convertAction(AnAction action, Lifetime lifetime) {
        return ActionsKt.toBeModel((AnAction)action, (Lifetime)lifetime, (ClientAppSession)this.session);
    }

    @Nullable
    public final Notification getNotification(int notificationId) {
        return this.knownNotifications.get(notificationId);
    }

    private static final JPanel fakeVisibleComponent_delegate$lambda$0() {
        JPanel jPanel;
        JPanel it = jPanel = new JPanel();
        boolean bl = false;
        UIUtil.markAsShowing((JComponent)it, (boolean)true);
        return jPanel;
    }

    private static final NewNotificationsModel newNotificationsModel_delegate$lambda$0(BackendNotificationsHost this$0) {
        Protocol protocol = RemoteSessionKt.getProtocol(this$0.session);
        return NewNotificationsModel_GeneratedKt.getNewNotificationsModel((IProtocol)((IProtocol)protocol));
    }

    private static final boolean sendNotification$lambda$0(Notification $notification, BackendNotificationsHost this$0, Project $project, BackendNotificationFilter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.blockNotification($notification, this$0.session, $project);
    }

    private static final boolean sendNotification$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit sendNotification$lambda$2(int $id, LifetimeDefinition $lifetime, AddRemove operation, int notificationId, NewNotificationModel newNotificationModel) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)newNotificationModel, (String)"<unused var>");
        if (operation == AddRemove.Remove && notificationId == $id) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)$lifetime, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final void sendNotification$lambda$3(LifetimeDefinition $lifetime, NewNotificationModel $model) {
        RdCoroutinesUtilKt.launchOnUiAllowInlining$default((Lifetime)((Lifetime)$lifetime), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($model, $lifetime, null){
            int label;
            final /* synthetic */ NewNotificationModel $model;
            final /* synthetic */ LifetimeDefinition $lifetime;
            {
                this.$model = $model;
                this.$lifetime = $lifetime;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$model.isExpired().set((Object)Boxing.boxBoolean((boolean)true));
                        LifetimeDefinition.terminate$default((LifetimeDefinition)this.$lifetime, (boolean)false, (int)1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final Unit sendNotification$lambda$4(Notification $notification, LifetimeDefinition $lifetime, boolean isExpired) {
        if (isExpired) {
            $notification.expire();
            LifetimeDefinition.terminate$default((LifetimeDefinition)$lifetime, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendNotification$lambda$5(BackendNotificationsHost this$0, int $id) {
        this$0.knownNotifications.remove($id);
        this$0.getNewNotificationsModel().getNotifications().remove((Object)$id);
        return Unit.INSTANCE;
    }

    private static final Unit convertNotification$lambda$2(Notification $notification, BackendNotificationsHost this$0, HyperLinkEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            NotificationListener notificationListener = $notification.getListener();
            if (notificationListener == null) break block0;
            notificationListener.hyperlinkUpdate($notification, new HyperlinkEvent($notification, HyperlinkEvent.EventType.ACTIVATED, this$0.toUrl(event.getUrl()), event.getDesc()));
        }
        return Unit.INSTANCE;
    }

    private static final RdNotificationGroupModel ensureGroupModelIsSent$lambda$0(String $groupId, NotificationGroup $group, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RdNotificationGroupModel($groupId, BackendNotificationsHostKt.access$toModel($group.getDisplayType()), $group.isLogByDefault(), $group.getToolWindowId(), $group.isHideFromSettings(), NotificationGroup.Companion.getGroupTitle($groupId));
    }

    private static final RdNotificationGroupModel ensureGroupModelIsSent$lambda$1(Function1 $tmp0, Object p0) {
        return (RdNotificationGroupModel)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendNotificationsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        EP_NAME = ExtensionPointName.Companion.create("com.intellij.rdserver.notificationFilter");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/ui/notification/BackendNotificationsHost$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REMOTE_NOTIFICATIONS_GROUP", "", "getREMOTE_NOTIFICATIONS_GROUP$annotations", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rdserver/ui/BackendNotificationFilter;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstance", "Lcom/jetbrains/rdserver/ui/notification/BackendNotificationsHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "showNotImplementedNotification", "", "Lcom/intellij/openapi/client/ClientSession;", "logReason", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendNotificationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,223:1\n23#2:224\n*S KotlinDebug\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHost$Companion\n*L\n59#1:224\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getREMOTE_NOTIFICATIONS_GROUP$annotations() {
        }

        @NotNull
        public final ExtensionPointName<BackendNotificationFilter> getEP_NAME() {
            return EP_NAME;
        }

        @NotNull
        public final BackendNotificationsHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendNotificationsHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (BackendNotificationsHost)((Object)object);
        }

        public final void showNotImplementedNotification(@NotNull ClientSession session, @NotNull String logReason) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)logReason, (String)"logReason");
            LOG.warn(logReason + ", showing notification instead", new Throwable());
            Notification notification = new Notification(BackendNotificationsHost.REMOTE_NOTIFICATIONS_GROUP, SplitBackendBundle.INSTANCE.message("notification.not.implemented", new Object[0]), NotificationType.ERROR);
            BackendNotificationsHostKt.notifyClient(notification, session);
        }

        public static /* synthetic */ void showNotImplementedNotification$default(Companion companion, ClientSession clientSession, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "Something went wrong";
            }
            companion.showNotImplementedNotification(clientSession, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/ui/notification/BackendNotificationsHost$SessionListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "projectSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendNotificationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHost$SessionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1915#2,2:224\n*S KotlinDebug\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHost$SessionListener\n*L\n174#1:224,2\n*E\n"})
    public static final class SessionListener
    implements RemoteClientSessionListener {
        @Override
        public void projectSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            if (session.isController()) {
                Iterable $this$forEach$iv = ActionCenter.getNotifications((Project)session.getProject());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Notification it = (Notification)element$iv;
                    boolean bl = false;
                    BackendNotificationsHostKt.notifyClient(it, session);
                }
            }
        }
    }
}

