/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication.ui;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.AccountsPanelActionsController;
import com.intellij.openapi.project.Project;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginSource;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginUtil;
import org.jetbrains.plugins.gitlab.authentication.LoginResult;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabAccountsListModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0017J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabAccountsPanelActionsController;", "Lcom/intellij/collaboration/auth/ui/AccountsPanelActionsController;", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabAccountsListModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabAccountsListModel;)V", "isAddActionWithPopup", "", "()Z", "addAccount", "", "parentComponent", "Ljavax/swing/JComponent;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "editAccount", "account", "isAccountUnique", "serverPath", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "username", "", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabAccountsPanelActionsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabAccountsPanelActionsController.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabAccountsPanelActionsController\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,37:1\n19#2:38\n19#2:39\n*S KotlinDebug\n*F\n+ 1 GitLabAccountsPanelActionsController.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabAccountsPanelActionsController\n*L\n24#1:38\n31#1:39\n*E\n"})
public final class GitLabAccountsPanelActionsController
implements AccountsPanelActionsController<GitLabAccount> {
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabAccountsListModel model;
    private final boolean isAddActionWithPopup;

    public GitLabAccountsPanelActionsController(@NotNull Project project, @NotNull GitLabAccountsListModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.project = project;
        this.model = model;
    }

    public boolean isAddActionWithPopup() {
        return this.isAddActionWithPopup;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void addAccount(@NotNull JComponent parentComponent, @Nullable RelativePoint point) {
        void $this$asSafely$iv;
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        LoginResult loginResult2 = GitLabLoginUtil.logInViaToken$default(GitLabLoginUtil.INSTANCE, this.project, parentComponent, null, GitLabLoginSource.SETTINGS, (Function2)new Function2<GitLabServerPath, String, Boolean>((Object)this){

            public final Boolean invoke(GitLabServerPath p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return GitLabAccountsPanelActionsController.access$isAccountUnique((GitLabAccountsPanelActionsController)this.receiver, p0, p1);
            }
        }, 4, null);
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof LoginResult.Success)) {
            v0 = null;
        }
        LoginResult.Success success = v0;
        if (success == null) {
            return;
        }
        LoginResult.Success loginResult3 = success;
        this.model.add((Account)loginResult3.getAccount(), loginResult3.getToken());
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void editAccount(@NotNull JComponent parentComponent, @NotNull GitLabAccount account) {
        void $this$asSafely$iv;
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        LoginResult loginResult2 = GitLabLoginUtil.INSTANCE.updateToken(this.project, parentComponent, account, GitLabLoginSource.SETTINGS, (Function2<? super GitLabServerPath, ? super String, Boolean>)((Function2)new Function2<GitLabServerPath, String, Boolean>((Object)this){

            public final Boolean invoke(GitLabServerPath p0, String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return GitLabAccountsPanelActionsController.access$isAccountUnique((GitLabAccountsPanelActionsController)this.receiver, p0, p1);
            }
        }));
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof LoginResult.Success)) {
            v0 = null;
        }
        LoginResult.Success success = v0;
        if (success == null) {
            return;
        }
        LoginResult.Success loginResult3 = success;
        this.model.update((Account)account, loginResult3.getToken());
    }

    private final boolean isAccountUnique(GitLabServerPath serverPath, String username) {
        return GitLabLoginUtil.INSTANCE.isAccountUnique(this.model.getAccounts(), serverPath, username);
    }

    public static final /* synthetic */ boolean access$isAccountUnique(GitLabAccountsPanelActionsController $this, GitLabServerPath serverPath, String username) {
        return $this.isAccountUnique(serverPath, username);
    }
}

