/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Notifications {
    @Topic.AppLevel
    @Topic.ProjectLevel
    public static final Topic<Notifications> TOPIC = new Topic("Notifications", Notifications.class, Topic.BroadcastDirection.NONE);
    @Deprecated(forRemoval=true)
    public static final String SYSTEM_MESSAGES_GROUP_ID = "System Messages";

    default public void notify(@NotNull Notification notification) {
        if (notification == null) {
            Notifications.$$$reportNull$$$0(0);
        }
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType) {
        if (groupDisplayName == null) {
            Notifications.$$$reportNull$$$0(1);
        }
        if (defaultDisplayType == null) {
            Notifications.$$$reportNull$$$0(2);
        }
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType, boolean shouldLog) {
        if (groupDisplayName == null) {
            Notifications.$$$reportNull$$$0(3);
        }
        if (defaultDisplayType == null) {
            Notifications.$$$reportNull$$$0(4);
        }
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupDisplayName == null) {
            Notifications.$$$reportNull$$$0(5);
        }
        if (defaultDisplayType == null) {
            Notifications.$$$reportNull$$$0(6);
        }
    }

    default public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType defaultDisplayType, boolean shouldLog, boolean shouldReadAloud, @Nullable String toolWindowId) {
        if (groupDisplayName == null) {
            Notifications.$$$reportNull$$$0(7);
        }
        if (defaultDisplayType == null) {
            Notifications.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultDisplayType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/notification/Notifications";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Bus {
        private Bus() {
        }

        public static void notify(@NotNull Notification notification) {
            if (notification == null) {
                Bus.$$$reportNull$$$0(0);
            }
            Bus.notify(notification, null);
        }

        public static void notify(@NotNull Notification notification, @Nullable Project project) {
            if (notification == null) {
                Bus.$$$reportNull$$$0(1);
            }
            notification.assertHasTitleOrContent();
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isDispatchThread()) {
                if (project != null && project.isDisposed()) {
                    return;
                }
                Bus.doNotify(notification, project);
            } else if (project == null) {
                app.invokeLater(() -> Bus.doNotify(notification, null));
            } else {
                app.invokeLater(() -> Bus.doNotify(notification, project), project.getDisposed());
            }
        }

        private static void doNotify(Notification notification, @Nullable Project project) {
            if (project != null && !project.isDisposed() && !project.isDefault()) {
                ((Notifications)project.getMessageBus().syncPublisher(TOPIC)).notify(notification);
                Disposable notificationDisposable = () -> notification.expire();
                Disposer.register((Disposable)project, (Disposable)notificationDisposable);
                notification.whenExpired(() -> Disposer.dispose((Disposable)notificationDisposable));
            } else {
                Application app = ApplicationManager.getApplication();
                if (!app.isDisposed()) {
                    ((Notifications)app.getMessageBus().syncPublisher(TOPIC)).notify(notification);
                }
            }
        }

        @ApiStatus.Experimental
        public static void notifyAndHide(@NotNull Notification notification, @Nullable Project project) {
            if (notification == null) {
                Bus.$$$reportNull$$$0(2);
            }
            Bus.notify(notification);
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> notification.expire(), 5L, TimeUnit.SECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "notification";
            objectArray2[1] = "com/intellij/notification/Notifications$Bus";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notify";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyAndHide";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

