/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.ProgressMonitorInputStream;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private static final Logger LOG = Logger.getInstance(HttpRequests.class);
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    public static final int CONNECTION_TIMEOUT = SystemProperties.getIntProperty((String)"idea.connection.timeout", (int)10000);
    public static final int READ_TIMEOUT = SystemProperties.getIntProperty((String)"idea.read.timeout", (int)60000);
    public static final int REDIRECT_LIMIT = SystemProperties.getIntProperty((String)"idea.redirect.limit", (int)10);
    public static final int CUSTOM_ERROR_CODE = 451;
    private static final int[] REDIRECTS = new int[]{302, 307, 301, 303, 308};

    private HttpRequests() {
    }

    public static RequestBuilder request(@NotNull Url url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(0);
        }
        return HttpRequests.request(url.toExternalForm());
    }

    public static RequestBuilder request(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(1);
        }
        return new RequestBuilderImpl(url, null);
    }

    public static RequestBuilder head(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(2);
        }
        return new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("HEAD"));
    }

    public static RequestBuilder delete(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(3);
        }
        return new RequestBuilderImpl(url, connection -> ((HttpURLConnection)connection).setRequestMethod("DELETE"));
    }

    public static RequestBuilder delete(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(4);
        }
        return HttpRequests.requestWithBody(url, "DELETE", contentType, null);
    }

    public static RequestBuilder post(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(5);
        }
        return HttpRequests.requestWithBody(url, "POST", contentType, null);
    }

    public static RequestBuilder put(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(6);
        }
        return HttpRequests.requestWithBody(url, "PUT", contentType, null);
    }

    public static RequestBuilder patch(@NotNull String url, @Nullable String contentType) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(7);
        }
        return HttpRequests.requestWithBody(url, "POST", contentType, connection -> connection.setRequestProperty("X-HTTP-Method-Override", "PATCH"));
    }

    public static RequestBuilder requestWithRange(@NotNull String url, @NotNull String bytes) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(8);
        }
        if (bytes == null) {
            HttpRequests.$$$reportNull$$$0(9);
        }
        return HttpRequests.requestWithBody(url, "GET", null, connection -> connection.setRequestProperty("Range", "bytes=" + bytes));
    }

    private static RequestBuilder requestWithBody(String url, String requestMethod, @Nullable String contentType, @Nullable ConnectionTuner tuner) {
        return new RequestBuilderImpl(url, rawConnection -> {
            HttpURLConnection connection = (HttpURLConnection)rawConnection;
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(true);
            if (contentType != null) {
                connection.setRequestProperty("Content-Type", contentType);
            }
            if (tuner != null) {
                tuner.tune(connection);
            }
        });
    }

    @NotNull
    public static String createErrorMessage(@NotNull IOException e, @NotNull Request request2, boolean includeHeaders) {
        if (e == null) {
            HttpRequests.$$$reportNull$$$0(10);
        }
        if (request2 == null) {
            HttpRequests.$$$reportNull$$$0(11);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot download '").append(request2.getURL()).append("': ").append(e.getMessage());
        try {
            URLConnection connection = request2.getConnection();
            if (includeHeaders) {
                builder.append("\n, headers: ").append(connection.getHeaderFields());
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                builder.append("\n, response: ").append(httpConnection.getResponseCode()).append(' ').append(httpConnection.getResponseMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = builder.toString();
        if (string == null) {
            HttpRequests.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static <T> T process(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        Application app = ApplicationManager.getApplication();
        LOG.assertTrue(app == null || app.isUnitTestMode() || app.isHeadlessEnvironment() || !app.holdsReadLock(), (Object)"Network must not be accessed in EDT or inside read action, because this may take considerable amount of time, and write actions will be blocked during that time so user won't be able to perform tasks in the IDE");
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null && HttpRequests.shouldOverrideContextClassLoader()) {
            try {
                T t;
                try (URLClassLoader cl = new URLClassLoader(new URL[0], contextLoader);){
                    Thread.currentThread().setContextClassLoader(cl);
                    t = HttpRequests.doProcess(builder, processor);
                }
                return t;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return HttpRequests.doProcess(builder, processor);
    }

    private static boolean shouldOverrideContextClassLoader() {
        return SystemProperties.getBooleanProperty((String)"http.requests.override.context.classloader", (boolean)true);
    }

    private static <T> T doProcess(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        try (RequestImpl request2 = new RequestImpl(builder);){
            HttpURLConnection urlConnection;
            int responseCode;
            URLConnection connection;
            T result = processor.process(request2);
            if (builder.myThrowStatusCodeException && (connection = request2.myConnection) != null && connection.getDoOutput() && (responseCode = (urlConnection = (HttpURLConnection)connection).getResponseCode()) >= 400) {
                HttpRequests.throwHttpStatusError(urlConnection, request2, builder, responseCode);
            }
            T t = result;
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URLConnection openConnection(RequestBuilderImpl builder, RequestImpl request2) throws IOException {
        int responseCode;
        HttpURLConnection httpURLConnection;
        URLConnection connection;
        block23: {
            if (builder.myForceHttps && request2.myUrl.startsWith("http:")) {
                request2.myUrl = "https:" + request2.myUrl.substring(5);
            }
            int i = 0;
            while (i < builder.myRedirectLimit) {
                String url = request2.myUrl;
                try {
                    IdeUiService uiService;
                    connection = !builder.myUseProxy ? new URI(url).toURL().openConnection(Proxy.NO_PROXY) : ((uiService = HttpRequests.getIdeUiService()) != null ? uiService.openHttpConnection(url) : new URI(url).toURL().openConnection());
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                if (connection instanceof HttpsURLConnection) {
                    HttpRequests.configureSslConnection(url, (HttpsURLConnection)connection);
                }
                connection.setConnectTimeout(builder.myConnectTimeout);
                connection.setReadTimeout(builder.myTimeout);
                if (builder.myUserAgent != null) {
                    connection.setRequestProperty("User-Agent", builder.myUserAgent);
                }
                if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
                }
                if (builder.myGzip) {
                    connection.setRequestProperty("Accept-Encoding", "gzip");
                }
                if (builder.myAccept != null) {
                    connection.setRequestProperty("Accept", builder.myAccept);
                }
                connection.setUseCaches(false);
                if (builder.myInternalTuner != null) {
                    builder.myInternalTuner.tune(connection);
                }
                if (builder.myTuner != null) {
                    builder.myTuner.tune(connection);
                }
                HttpRequests.checkRequestHeadersForNulBytes(connection);
                if (!(connection instanceof HttpURLConnection)) return connection;
                httpURLConnection = (HttpURLConnection)connection;
                httpURLConnection.setInstanceFollowRedirects(false);
                if (connection.getDoOutput()) {
                    return connection;
                }
                String method = httpURLConnection.getRequestMethod();
                LOG.assertTrue(method.equals("GET") || method.equals("HEAD") || method.equals("DELETE"), (Object)("'" + method + "' not supported; please use GET, HEAD, DELETE, PUT or POST"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connecting to " + url);
                }
                try {
                    responseCode = httpURLConnection.getResponseCode();
                }
                catch (SSLHandshakeException e) {
                    SSLException sSLException;
                    if (!NetUtils.isSniEnabled()) {
                        sSLException = new SSLException("SSL error probably caused by disabled SNI", e);
                        throw sSLException;
                    }
                    sSLException = e;
                    throw sSLException;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response from " + url + ": " + responseCode);
                }
                if (responseCode >= 200) {
                    if (responseCode < 300) return connection;
                    if (responseCode == 304) return connection;
                }
                if (ArrayUtil.indexOf((int[])REDIRECTS, (int)responseCode) < 0) break block23;
                if (!builder.myFollowRedirects) {
                    return connection;
                }
                httpURLConnection.disconnect();
                String loc = connection.getHeaderField("Location");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("redirect from " + url + ": " + loc);
                }
                if (loc == null) break block23;
                if (!loc.contains("://")) {
                    try {
                        loc = new URI(url).resolve(new URI(loc)).toString();
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                }
                request2.myUrl = loc;
                ++i;
            }
            throw new IOException(IdeCoreBundle.message("error.connection.failed.redirects", new Object[0]));
        }
        if (!builder.myThrowStatusCodeException) return connection;
        HttpRequests.throwHttpStatusError(httpURLConnection, request2, builder, responseCode);
        return connection;
    }

    private static void throwHttpStatusError(HttpURLConnection connection, RequestImpl request2, RequestBuilderImpl builder, int statusCode) throws IOException {
        String message = null;
        if (statusCode == 451) {
            message = connection.getHeaderField("Error-Message");
        }
        if ((message == null || message.isEmpty()) && builder.myIsReadResponseOnError) {
            message = request2.readError(connection);
        }
        if (message == null || message.isEmpty()) {
            message = IdeCoreBundle.message("error.connection.failed.status", statusCode);
        }
        connection.disconnect();
        if (statusCode == 407) {
            IdeUiService uiService = HttpRequests.getIdeUiService();
            if (uiService != null) {
                uiService.showProxyAuthNotification();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("proxy auth failed for " + request2.getURL() + "; Proxy-Authenticate=" + connection.getHeaderField("Proxy-Authenticate"), (Throwable)new Exception());
            }
        }
        throw new HttpStatusException(message, statusCode, Objects.requireNonNullElse(request2.myUrl, "Empty URL"));
    }

    private static void configureSslConnection(String url, HttpsURLConnection connection) {
        IdeUiService uiService = HttpRequests.getIdeUiService();
        if (uiService == null) {
            LOG.info("Application is not initialized yet; Using default SSL configuration to connect to " + url);
            return;
        }
        try {
            SSLSocketFactory factory = uiService.getSslSocketFactory();
            if (factory == null) {
                LOG.info("SSLSocketFactory is not defined by the IDE Certificate Manager; Using default SSL configuration to connect to " + url);
            } else {
                connection.setSSLSocketFactory(factory);
            }
        }
        catch (Throwable e) {
            LOG.info("Problems configuring SSL connection to " + url, e);
        }
    }

    @Nullable
    private static IdeUiService getIdeUiService() {
        Application app = ApplicationManager.getApplication();
        return app != null ? (IdeUiService)app.getServiceIfCreated(IdeUiService.class) : null;
    }

    private static void checkRequestHeadersForNulBytes(URLConnection connection) {
        block0: for (Map.Entry<String, List<String>> header : connection.getRequestProperties().entrySet()) {
            for (String headerValue : header.getValue()) {
                if (headerValue.indexOf(0) < 0) continue;
                connection.setRequestProperty(header.getKey(), null);
                LOG.error(String.format("Problem during request to '%s'. Header's '%s' value contains NUL bytes: '%s'. Omitting this header.", connection.getURL().toString(), header.getKey(), headerValue));
                continue block0;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/HttpRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/HttpRequests";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "head";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "post";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "patch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "requestWithRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createErrorMessage";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }

    private static final class RequestBuilderImpl
    extends RequestBuilder {
        private final String myUrl;
        private int myConnectTimeout = CONNECTION_TIMEOUT;
        private int myTimeout = READ_TIMEOUT;
        private boolean myFollowRedirects = true;
        private int myRedirectLimit = REDIRECT_LIMIT;
        private boolean myGzip = true;
        private boolean myForceHttps;
        private boolean myUseProxy = true;
        private boolean myIsReadResponseOnError;
        private HostnameVerifier myHostnameVerifier;
        private String myUserAgent;
        private String myAccept;
        private ConnectionTuner myTuner;
        private final ConnectionTuner myInternalTuner;
        private boolean myThrowStatusCodeException = true;

        private RequestBuilderImpl(String url, @Nullable ConnectionTuner internalTuner) {
            this.myUrl = url;
            this.myInternalTuner = internalTuner;
        }

        @Override
        public RequestBuilder connectTimeout(int value) {
            this.myConnectTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder readTimeout(int value) {
            this.myTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder followRedirects(boolean value) {
            this.myFollowRedirects = value;
            return this;
        }

        @Override
        public RequestBuilder redirectLimit(int redirectLimit) {
            if (redirectLimit < 1) {
                throw new IllegalArgumentException("Redirect limit should be positive");
            }
            this.myRedirectLimit = redirectLimit;
            return this;
        }

        @Override
        public RequestBuilder gzip(boolean value) {
            this.myGzip = value;
            return this;
        }

        @Override
        public RequestBuilder forceHttps(boolean forceHttps) {
            this.myForceHttps = forceHttps;
            return this;
        }

        @Override
        public RequestBuilder useProxy(boolean useProxy) {
            this.myUseProxy = useProxy;
            return this;
        }

        @Override
        public RequestBuilder isReadResponseOnError(boolean isReadResponseOnError) {
            this.myIsReadResponseOnError = isReadResponseOnError;
            return this;
        }

        @Override
        public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            this.myHostnameVerifier = hostnameVerifier;
            return this;
        }

        @Override
        public RequestBuilder userAgent(@Nullable String userAgent) {
            this.myUserAgent = userAgent;
            return this;
        }

        @Override
        public RequestBuilder productNameAsUserAgent() {
            Object userAgent;
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
                userAgent = productName + "/" + version;
            } else {
                userAgent = "IntelliJ";
            }
            String currentBuildUrl = System.getenv("BUILD_URL");
            if (currentBuildUrl != null) {
                userAgent = (String)userAgent + " (" + currentBuildUrl + ")";
            }
            return this.userAgent((String)userAgent);
        }

        @Override
        public RequestBuilder accept(@Nullable String mimeType) {
            this.myAccept = mimeType;
            return this;
        }

        @Override
        public RequestBuilder tuner(@Nullable ConnectionTuner tuner) {
            this.myTuner = tuner;
            return this;
        }

        @Override
        @NotNull
        public RequestBuilder throwStatusCodeException(boolean shouldThrow) {
            this.myThrowStatusCodeException = shouldThrow;
            RequestBuilderImpl requestBuilderImpl = this;
            if (requestBuilderImpl == null) {
                RequestBuilderImpl.$$$reportNull$$$0(0);
            }
            return requestBuilderImpl;
        }

        @Override
        public <T> T connect(@NotNull RequestProcessor<T> processor) throws IOException {
            if (processor == null) {
                RequestBuilderImpl.$$$reportNull$$$0(1);
            }
            return HttpRequests.process(this, processor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$RequestBuilderImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "throwStatusCodeException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestBuilderImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "connect";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static interface ConnectionTuner {
        public void tune(@NotNull URLConnection var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public String getURL();

        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;

        @NotNull
        public BufferedReader getReader() throws IOException;

        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator var1) throws IOException;

        @ApiStatus.Obsolete
        @NotNull
        default public File saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
            if (file == null) {
                Request.$$$reportNull$$$0(0);
            }
            File file2 = this.saveToFile(file.toPath(), indicator).toFile();
            if (file2 == null) {
                Request.$$$reportNull$$$0(1);
            }
            return file2;
        }

        @NotNull
        public Path saveToFile(@NotNull Path var1, @Nullable ProgressIndicator var2) throws IOException;

        @NotNull
        public Path saveToFile(@NotNull Path var1, @Nullable ProgressIndicator var2, boolean var3) throws IOException;

        public byte @NotNull [] readBytes(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        public String readString(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        default public String readString() throws IOException {
            String string = this.readString(null);
            if (string == null) {
                Request.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator var1) throws IOException;

        @Nullable
        public String readError() throws IOException;

        default public void write(@NotNull String data) throws IOException {
            if (data == null) {
                Request.$$$reportNull$$$0(3);
            }
            this.write(data.getBytes(StandardCharsets.UTF_8));
        }

        default public void write(byte @NotNull [] data) throws IOException {
            if (data == null) {
                Request.$$$reportNull$$$0(4);
            }
            HttpURLConnection connection = (HttpURLConnection)this.getConnection();
            connection.setFixedLengthStreamingMode(data.length);
            try (OutputStream stream = connection.getOutputStream();){
                stream.write(data);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$Request";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$Request";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "saveToFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "saveToFile";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    private static final class RequestImpl
    implements Request,
    AutoCloseable {
        private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([^;]+)");
        private final RequestBuilderImpl myBuilder;
        private String myUrl;
        private URLConnection myConnection;
        private InputStream myInputStream;
        private BufferedReader myReader;

        private RequestImpl(RequestBuilderImpl builder) {
            this.myBuilder = builder;
            this.myUrl = this.myBuilder.myUrl;
        }

        @Override
        @NotNull
        public String getURL() {
            String string = this.myUrl;
            if (string == null) {
                RequestImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public URLConnection getConnection() throws IOException {
            if (this.myConnection == null) {
                this.myConnection = HttpRequests.openConnection(this.myBuilder, this);
            }
            URLConnection uRLConnection = this.myConnection;
            if (uRLConnection == null) {
                RequestImpl.$$$reportNull$$$0(1);
            }
            return uRLConnection;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            if (this.myInputStream == null) {
                URLConnection connection = this.getConnection();
                this.myInputStream = this.unzipStreamIfNeeded(connection, connection.getInputStream());
            }
            InputStream inputStream = this.myInputStream;
            if (inputStream == null) {
                RequestImpl.$$$reportNull$$$0(2);
            }
            return inputStream;
        }

        private InputStream unzipStreamIfNeeded(URLConnection connection, InputStream stream) throws IOException {
            return this.myBuilder.myGzip && "gzip".equalsIgnoreCase(connection.getContentEncoding()) ? CountingGZIPInputStream.create((InputStream)stream) : stream;
        }

        @Override
        @NotNull
        public BufferedReader getReader() throws IOException {
            BufferedReader bufferedReader = this.getReader(null);
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(3);
            }
            return bufferedReader;
        }

        @Override
        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator indicator) throws IOException {
            if (this.myReader == null) {
                long contentLength;
                InputStream inputStream = this.getInputStream();
                if (indicator != null && (contentLength = this.getConnection().getContentLengthLong()) > 0L) {
                    inputStream = new ProgressMonitorInputStream(indicator, inputStream, contentLength);
                }
                this.myReader = new BufferedReader(new InputStreamReader(inputStream, this.getCharset()));
            }
            BufferedReader bufferedReader = this.myReader;
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(4);
            }
            return bufferedReader;
        }

        private Charset getCharset() throws IOException {
            return RequestImpl.getCharset(this.getConnection());
        }

        private static Charset getCharset(URLConnection connection) throws IOException {
            Matcher m;
            String contentType = connection.getContentType();
            if (contentType != null && !contentType.isEmpty() && (m = CHARSET_PATTERN.matcher(contentType)).find()) {
                try {
                    return Charset.forName(StringUtil.unquoteString((String)m.group(1)));
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Unknown charset: " + contentType, e);
                }
            }
            return StandardCharsets.UTF_8;
        }

        @Override
        public byte @NotNull [] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
            byte[] byArray = this.doReadBytes(indicator).toByteArray();
            if (byArray == null) {
                RequestImpl.$$$reportNull$$$0(5);
            }
            return byArray;
        }

        @Override
        @NotNull
        public String readString(@Nullable ProgressIndicator indicator) throws IOException {
            BufferExposingByteArrayOutputStream stream = this.doReadBytes(indicator);
            return stream.size() == 0 ? "" : new String(stream.getInternalBuffer(), 0, stream.size(), this.getCharset());
        }

        @Override
        @NotNull
        public CharSequence readChars(@Nullable ProgressIndicator indicator) throws IOException {
            BufferExposingByteArrayOutputStream stream = this.doReadBytes(indicator);
            CharSequence charSequence = stream.size() == 0 ? "" : this.getCharset().decode(ByteBuffer.wrap(stream.getInternalBuffer(), 0, stream.size()));
            if (charSequence == null) {
                RequestImpl.$$$reportNull$$$0(6);
            }
            return charSequence;
        }

        private BufferExposingByteArrayOutputStream doReadBytes(@Nullable ProgressIndicator indicator) throws IOException {
            long contentLength = this.getConnection().getContentLengthLong();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IOException("Cannot download more than 2 GiB; content length is " + contentLength);
            }
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0L ? (int)contentLength : 16384);
            NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)this.getInputStream(), (OutputStream)out, (long)contentLength, (boolean)false);
            return out;
        }

        @Override
        @Nullable
        public String readError() throws IOException {
            return this.readError((HttpURLConnection)this.getConnection());
        }

        @Nullable
        private String readError(HttpURLConnection connection) throws IOException {
            InputStream stream = connection.getErrorStream();
            return stream == null ? null : StreamUtil.readText((Reader)new InputStreamReader(this.unzipStreamIfNeeded(connection, stream), RequestImpl.getCharset(connection)));
        }

        @Override
        @NotNull
        public Path saveToFile(@NotNull Path file, @Nullable ProgressIndicator indicator) throws IOException {
            if (file == null) {
                RequestImpl.$$$reportNull$$$0(7);
            }
            Path path = this.saveToFile(file, indicator, false);
            if (path == null) {
                RequestImpl.$$$reportNull$$$0(8);
            }
            return path;
        }

        @Override
        @NotNull
        public Path saveToFile(@NotNull Path file, @Nullable ProgressIndicator indicator, boolean progressDescription) throws IOException {
            if (file == null) {
                RequestImpl.$$$reportNull$$$0(9);
            }
            NioFiles.createDirectories((Path)file.getParent());
            boolean deleteFile = true;
            try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)this.getInputStream(), (OutputStream)out, (long)this.getConnection().getContentLengthLong(), (boolean)progressDescription);
                deleteFile = false;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
            }
            finally {
                if (deleteFile) {
                    Files.deleteIfExists(file);
                }
            }
            Path path = file;
            if (path == null) {
                RequestImpl.$$$reportNull$$$0(10);
            }
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try (InputStream s = this.myInputStream;){
                BufferedReader r = this.myReader;
                if (r != null) {
                    ((Reader)r).close();
                }
            }
            finally {
                if (this.myConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.myConnection).disconnect();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 7, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBytes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readChars";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "saveToFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 7: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "saveToFile";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 7, 9 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class HttpStatusException
    extends IOException {
        private final int myStatusCode;
        private final String myUrl;

        public HttpStatusException(@NotNull String message, int statusCode, @NotNull String url) {
            if (message == null) {
                HttpStatusException.$$$reportNull$$$0(0);
            }
            if (url == null) {
                HttpStatusException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myStatusCode = statusCode;
            this.myUrl = url;
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @NotNull
        public String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                HttpStatusException.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public String toString() {
            return super.toString() + ". Status=" + this.myStatusCode + ", Url=" + this.myUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

