/*
 * Decompiled with CFR 0.152.
 */
package liquibase.das;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.liquibase.orm.db.DasDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.das.DasSnapshotGenerator;
import liquibase.das.DasToDbObjectsConverter;
import liquibase.database.Database;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\f"}, d2={"Lliquibase/das/DasSchemaSnapshotGenerator;", "Lliquibase/das/DasSnapshotGenerator;", "<init>", "()V", "snapshotObject", "Lliquibase/structure/DatabaseObject;", "example", "snapshot", "Lliquibase/snapshot/DatabaseSnapshot;", "addTo", "", "foundObject", "intellij.liquibase.orm"})
public final class DasSchemaSnapshotGenerator
extends DasSnapshotGenerator {
    public DasSchemaSnapshotGenerator() {
        Class[] classArray = new Class[]{Catalog.class};
        super(Schema.class, classArray);
    }

    @Override
    @NotNull
    protected DatabaseObject snapshotObject(@NotNull DatabaseObject example, @NotNull DatabaseSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (example.getSnapshotId() != null || !(example instanceof Schema)) {
            return example;
        }
        Database database = snapshot.getDatabase();
        Intrinsics.checkNotNull((Object)database, (String)"null cannot be cast to non-null type com.intellij.liquibase.orm.db.DasDatabase");
        DasDatabase dasDatabase = (DasDatabase)database;
        Schema schema = new Schema(((Schema)example).getCatalog(), ((Schema)example).getName()).setDefault(Boolean.valueOf(StringsKt.equals((String)dasDatabase.getDefaultSchemaName(), (String)((Schema)example).getName(), (boolean)true)));
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"setDefault(...)");
        return (DatabaseObject)schema;
    }

    @Override
    protected void addTo(@NotNull DatabaseObject foundObject, @NotNull DatabaseSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)foundObject, (String)"foundObject");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (!snapshot.getSnapshotControl().shouldInclude(Schema.class) || !(foundObject instanceof Catalog)) {
            return;
        }
        Database database = snapshot.getDatabase();
        Intrinsics.checkNotNull((Object)database, (String)"null cannot be cast to non-null type com.intellij.liquibase.orm.db.DasDatabase");
        DasDatabase dasDatabase = (DasDatabase)database;
        String catalog = dasDatabase.getDefaultCatalogName();
        for (DasNamespace dasSchema : DasToDbObjectsConverter.INSTANCE.getNonSystemSchemas((DasDataSource)dasDatabase.getDbDataSource())) {
            if (dasDatabase.supportsCatalogs() && catalog != null) {
                DasObject dasObject = dasSchema.getDasParent();
                if (!Intrinsics.areEqual((Object)catalog, (Object)(dasObject != null ? dasObject.getName() : null))) continue;
            }
            ((Catalog)foundObject).addDatabaseObject((DatabaseObject)new Schema((Catalog)foundObject, dasSchema.getName()));
        }
    }
}

